/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class FindBugsSummaryStats
extends PreorderVisitor
implements Detector,
BugReporterObserver {
    private ProjectStats stats;
    BitSet lines = new BitSet(500);
    int methods = 0;
    int fields = 0;
    int classCodeSize;
    boolean sawLineNumbers;

    public void visit(JavaClass obj) {
        this.lines.clear();
        this.methods = 0;
        this.fields = 0;
        this.classCodeSize = 0;
        this.sawLineNumbers = false;
    }

    public void visit(Method obj) {
        ++this.methods;
    }

    public void visit(Field obj) {
        ++this.fields;
    }

    public void visit(Code obj) {
        this.classCodeSize += obj.getCode().length;
    }

    public void visitAfter(JavaClass obj) {
        int linesNCSS = 1 + this.methods + this.fields;
        linesNCSS = this.sawLineNumbers ? (linesNCSS += this.lines.cardinality()) : (linesNCSS += this.classCodeSize / 10);
        this.stats.addClass(this.getDottedClassName(), obj.isInterface(), linesNCSS);
    }

    public void visit(LineNumber obj) {
        this.sawLineNumbers = true;
        int line = obj.getLineNumber();
        this.lines.set(line);
    }

    public FindBugsSummaryStats(BugReporter bugReporter) {
        this.stats = bugReporter.getProjectStats();
        bugReporter.addObserver((BugReporterObserver)this);
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    public void reportBug(BugInstance bug) {
        this.stats.addBug(bug);
    }
}

