/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.LiveLocalStoreAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.detect.DeadLocalStoreProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ConstantPushInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.IINC;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.StoreInstruction;

public class FindDeadLocalStores
implements Detector {
    private static final boolean DEBUG = Boolean.getBoolean("fdls.debug");
    private static final String FINDBUGS_EXCLUDED_LOCALS_PROP_NAME = "findbugs.dls.exclusions";
    private static final Set<String> EXCLUDED_LOCALS = new HashSet<String>();
    private static final boolean DO_EXCLUDE_LOCALS = System.getProperty("findbugs.dls.exclusions") != null;
    private static final BitSet defensiveConstantValueOpcodes;
    private BugReporter bugReporter;

    public FindDeadLocalStores(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            System.out.println("Debugging FindDeadLocalStores detector");
        }
    }

    private boolean prescreen(ClassContext classContext, Method method) {
        return true;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method method = arr$[i$];
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null || !this.prescreen(classContext, method)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("Error analyzing " + method.toString(), (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        if (DEBUG) {
            System.out.println("    Analyzing method " + method.toString());
        }
        JavaClass javaClass = classContext.getJavaClass();
        LiveLocalStoreDataflow llsaDataflow = classContext.getLiveLocalStoreDataflow(method);
        int numLocals = method.getCode().getMaxLocals();
        int[] localStoreCount = new int[numLocals];
        int[] localLoadCount = new int[numLocals];
        int[] localIncrementCount = new int[numLocals];
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        BitSet liveStoreSetAtEntry = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getResultFact(cfg.getEntry());
        BitSet complainedAbout = new BitSet();
        int localsThatAreParameters = method.getArgumentTypes().length;
        if (!method.isStatic()) {
            ++localsThatAreParameters;
        }
        this.countLocalStoresLoadsAndIncrements(localStoreCount, localLoadCount, localIncrementCount, cfg);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            int priority;
            InstructionHandle prev2;
            Instruction prevIns;
            InstructionHandle prevInsHandle;
            boolean parameterThatIsDeadAtEntry;
            LocalVariable lv1;
            Location location = (Location)i.next();
            WarningPropertySet propertySet = new WarningPropertySet();
            if (!this.isStore(location)) continue;
            if (location.getBasicBlock().isExceptionHandler()) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.EXCEPTION_HANDLER);
            }
            IndexedInstruction ins = (IndexedInstruction)location.getHandle().getInstruction();
            int local = ins.getIndex();
            int position = location.getHandle().getPosition() + 1;
            LocalVariableTable localVariableTable = method.getLocalVariableTable();
            String localName = "?";
            if (localVariableTable != null && (lv1 = localVariableTable.getLocalVariable(local, position)) != null) {
                localName = lv1.getName();
                if (EXCLUDED_LOCALS.contains(localName)) continue;
                propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, localName);
            }
            boolean bl = parameterThatIsDeadAtEntry = local < localsThatAreParameters && !((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSetAtEntry, local);
            if (parameterThatIsDeadAtEntry && !complainedAbout.get(local)) {
                LocalVariableAnnotation lvAnnotation = new LocalVariableAnnotation(localName, local, position);
                lvAnnotation.setDescription(localName.equals("?") ? "LOCAL_VARIABLE_UNKNOWN" : "LOCAL_VARIABLE_NAMED");
                BugInstance bugInstance = new BugInstance((Detector)this, "IP_PARAMETER_IS_DEAD_BUT_OVERWRITTEN", 2).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation).addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle());
                this.bugReporter.reportBug(bugInstance);
                complainedAbout.set(local);
            }
            if ((prevInsHandle = location.getHandle().getPrev()) != null && ((prevIns = prevInsHandle.getInstruction()) instanceof LDC || prevIns instanceof ConstantPushInstruction || prevIns instanceof ACONST_NULL)) continue;
            BitSet liveStoreSet = (BitSet)((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).getFactAtLocation(location);
            if (((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).isStoreAlive(liveStoreSet, local)) continue;
            boolean killedBySubsequentStore = ((LiveLocalStoreAnalysis)llsaDataflow.getAnalysis()).killedByStore(liveStoreSet, local);
            if (killedBySubsequentStore) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.KILLED_BY_SUBSEQUENT_STORE);
            }
            InstructionHandle prev = location.getBasicBlock().getPredecessorOf(location.getHandle());
            int prevOpCode = -1;
            if (prev != null && defensiveConstantValueOpcodes.get(prev.getInstruction().getOpcode())) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEFENSIVE_CONSTANT_OPCODE);
                prevOpCode = prev.getInstruction().getOpcode();
            }
            InstructionHandle instructionHandle = prev2 = prev == null ? null : prev.getPrev();
            if (prev2 != null && prev2.getInstruction() instanceof ALOAD && prev.getInstruction() instanceof GETFIELD) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.CACHING_VALUE);
            }
            if (ins instanceof IINC) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_INCREMENT);
                if (localIncrementCount[local] == 1) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_DEAD_INCREMENT);
                }
            } else if (ins instanceof ASTORE && prev != null) {
                Instruction prevIns2 = prev.getInstruction();
                if (prevIns2 instanceof INVOKESPECIAL && ((INVOKESPECIAL)prevIns2).getMethodName(methodGen.getConstantPool()).equals("<init>") || prevIns2 instanceof ANEWARRAY || prevIns2 instanceof NEWARRAY || prevIns2 instanceof MULTIANEWARRAY) {
                    propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.DEAD_OBJECT_STORE);
                }
            } else if (!killedBySubsequentStore && localStoreCount[local] == 2 && localLoadCount[local] > 0) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.TWO_STORES_MULTIPLE_LOADS);
            } else if (!parameterThatIsDeadAtEntry && localStoreCount[local] == 1) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.SINGLE_STORE);
            } else if (!parameterThatIsDeadAtEntry && localLoadCount[local] == 0) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.NO_LOADS);
            }
            if (parameterThatIsDeadAtEntry) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.PARAM_DEAD_ON_ENTRY);
            }
            if (localStoreCount[local] > 3) {
                propertySet.addProperty((WarningProperty)DeadLocalStoreProperty.MANY_STORES);
            }
            if ((priority = propertySet.computePriority(2)) > 4) continue;
            LocalVariableAnnotation lvAnnotation = new LocalVariableAnnotation(localName, local, position);
            lvAnnotation.setDescription(localName.equals("?") ? "LOCAL_VARIABLE_UNKNOWN" : "LOCAL_VARIABLE_NAMED");
            BugInstance bugInstance = new BugInstance((Detector)this, "DLS_DEAD_LOCAL_STORE", priority).addClassAndMethod(methodGen, javaClass.getSourceFileName()).add((BugAnnotation)lvAnnotation).addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle());
            if (DEBUG) {
                System.out.println(javaClass.getSourceFileName() + " : " + methodGen.getName());
                System.out.println("priority: " + priority);
                System.out.println("Reporting " + bugInstance);
                System.out.println(propertySet);
            }
            if (FindBugsAnalysisFeatures.isRelaxedMode()) {
                WarningPropertyUtil.addPropertiesForLocation((WarningPropertySet)propertySet, (ClassContext)classContext, (Method)method, (Location)location);
                propertySet.decorateBugInstance(bugInstance);
            }
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private void countLocalStoresLoadsAndIncrements(int[] localStoreCount, int[] localLoadCount, int[] localIncrementCount, CFG cfg) {
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location location = (Location)i.next();
            if (location.getBasicBlock().isExceptionHandler()) continue;
            boolean isStore = this.isStore(location);
            boolean isLoad = this.isLoad(location);
            if (!isStore && !isLoad) continue;
            IndexedInstruction ins = (IndexedInstruction)location.getHandle().getInstruction();
            int local = ins.getIndex();
            if (ins instanceof IINC) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                int n2 = local;
                localLoadCount[n2] = localLoadCount[n2] + 1;
                int n3 = local;
                localIncrementCount[n3] = localIncrementCount[n3] + 1;
                continue;
            }
            if (isStore) {
                int n = local;
                localStoreCount[n] = localStoreCount[n] + 1;
                continue;
            }
            int n = local;
            localLoadCount[n] = localLoadCount[n] + 1;
        }
    }

    private void checkLocalVariableName(LocalVariableTable lvt, int local, int pc, WarningPropertySet propertySet) {
        LocalVariable lv;
        if (lvt != null && (lv = lvt.getLocalVariable(local, pc)) != null) {
            String localName = lv.getName();
            propertySet.setProperty((WarningProperty)DeadLocalStoreProperty.LOCAL_NAME, localName);
        }
    }

    private boolean isStore(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof StoreInstruction || ins instanceof IINC;
    }

    private boolean isLoad(Location location) {
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LoadInstruction || ins instanceof IINC;
    }

    public void report() {
    }

    static {
        String exclLocalsProperty = System.getProperty(FINDBUGS_EXCLUDED_LOCALS_PROP_NAME);
        if (exclLocalsProperty != null) {
            EXCLUDED_LOCALS.addAll(Arrays.asList(exclLocalsProperty.split(",")));
            EXCLUDED_LOCALS.remove("");
        }
        defensiveConstantValueOpcodes = new BitSet();
        defensiveConstantValueOpcodes.set(14);
        defensiveConstantValueOpcodes.set(15);
        defensiveConstantValueOpcodes.set(11);
        defensiveConstantValueOpcodes.set(12);
        defensiveConstantValueOpcodes.set(1);
        defensiveConstantValueOpcodes.set(3);
        defensiveConstantValueOpcodes.set(4);
    }
}

