/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class FindJSR166LockMonitorenter
implements Detector,
StatelessDetector {
    private BugReporter bugReporter;
    private static final ObjectType LOCK_TYPE = new ObjectType("java.util.concurrent.locks.Lock");

    public FindJSR166LockMonitorenter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass jclass = classContext.getJavaClass();
        Method[] arr$ = methodList = jclass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            BitSet bytecodeSet;
            Method method = arr$[i$];
            if (method.getCode() == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null || !bytecodeSet.get(194)) continue;
            try {
                this.analyzeMethod(classContext, method);
                continue;
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindJSR166LockMonitorEnter caught exception", (Throwable)e);
                continue;
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindJSR166LockMonitorEnter caught exception", (Throwable)e);
            }
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        CFG cfg = classContext.getCFG(method);
        TypeDataflow typeDataflow = classContext.getTypeDataflow(method);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            boolean isSubtype;
            TypeFrame frame;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (ins.getOpcode() != 194 || !(frame = typeDataflow.getFactAtLocation(location)).isValid()) continue;
            Type type = (Type)frame.getInstance(ins, cpg);
            if (!(type instanceof ReferenceType)) {
                return;
            }
            try {
                isSubtype = Hierarchy.isSubtype((ReferenceType)((ReferenceType)type), (ReferenceType)LOCK_TYPE);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
                return;
            }
            if (!isSubtype) continue;
            MethodGen mg = classContext.getMethodGen(method);
            String sourceFile = classContext.getJavaClass().getSourceFileName();
            this.bugReporter.reportBug(new BugInstance((Detector)this, "JLM_JSR166_LOCK_MONITORENTER", 2).addClassAndMethod(mg, sourceFile).addSourceLine(classContext, mg, sourceFile, handle));
        }
    }

    public void report() {
    }
}

