/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class FindMaskedFields
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private int numParms;
    private Set<Field> maskedFields = new HashSet<Field>();
    private Map<String, Field> classFields = new HashMap<String, Field>();
    private boolean staticMethod;
    private static final boolean ENABLE_LOCALS = Boolean.getBoolean("findbugs.maskedfields.locals");

    public FindMaskedFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        if (!obj.isInterface()) {
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    public void visit(JavaClass obj) {
        String fieldName;
        Field[] fields;
        this.classFields.clear();
        Field[] arr$ = fields = obj.getFields();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Field field = arr$[i$];
            fieldName = field.getName();
            this.classFields.put(fieldName, field);
        }
        try {
            JavaClass[] superClasses;
            JavaClass[] arr$2 = superClasses = Repository.getSuperClasses((JavaClass)obj);
            int len$2 = arr$2.length;
            for (int i$ = 0; i$ < len$2; ++i$) {
                JavaClass superClass = arr$2[i$];
                fields = superClass.getFields();
                for (int f = 0; f < fields.length; ++f) {
                    Field fld = fields[f];
                    if (fld.isStatic() || this.maskedFields.contains(fld) || !fld.isPublic() && !fld.isProtected() || (fieldName = fld.getName()).length() == 1 || fieldName.equals("serialVersionUID") || !this.classFields.containsKey(fieldName)) continue;
                    this.maskedFields.add(fld);
                    Field maskingField = this.classFields.get(fieldName);
                    FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), maskingField.getName(), maskingField.getSignature(), maskingField.isStatic());
                    int priority = 2;
                    if (maskingField.isStatic() || maskingField.isFinal()) {
                        ++priority;
                    } else if (fld.getSignature().charAt(0) == 'L' && !fld.getSignature().startsWith("Ljava/lang/") || fld.getSignature().charAt(0) == '[') {
                        --priority;
                    }
                    if (fld.getAccessFlags() != maskingField.getAccessFlags()) {
                        ++priority;
                    }
                    if (!fld.getSignature().equals(maskingField.getSignature())) {
                        ++priority;
                    }
                    FieldAnnotation maskedFieldAnnotation = FieldAnnotation.fromBCELField((String)superClass.getClassName(), (Field)fld);
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "MF_CLASS_MASKS_FIELD", priority).addClass((PreorderVisitor)this).addField(maskedFieldAnnotation).describe("FIELD_MASKED").addField(fa).describe("FIELD_MASKING"));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.numParms = obj.getArgumentTypes().length;
        if (!obj.isStatic()) {
            ++this.numParms;
        }
        this.staticMethod = obj.isStatic();
    }

    public void visit(LocalVariableTable obj) {
        if (ENABLE_LOCALS) {
            LocalVariable[] vars;
            if (this.staticMethod) {
                return;
            }
            LocalVariable[] arr$ = vars = obj.getLocalVariableTable();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Field f;
                String varName;
                LocalVariable var = arr$[i$];
                if (var.getIndex() < this.numParms || (varName = var.getName()).equals("serialVersionUID") || (f = this.classFields.get(varName)) == null) continue;
                FieldAnnotation fa = FieldAnnotation.fromBCELField((String)this.getClassName(), (Field)f);
                this.bugReporter.reportBug(new BugInstance((Detector)this, "MF_METHOD_MASKS_FIELD", 3).addClassAndMethod((PreorderVisitor)this).addField(fa).addSourceLine((BytecodeScanningDetector)this, var.getStartPC() - 1));
            }
        }
        super.visit(obj);
    }
}

