/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamFactory;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;

public class IOStreamFactory
implements StreamFactory {
    private ObjectType baseClassType;
    private ObjectType[] uninterestingSubclassTypeList;
    private String bugType;

    public IOStreamFactory(String baseClass, String[] uninterestingSubclassList, String bugType) {
        this.baseClassType = new ObjectType(baseClass);
        this.uninterestingSubclassTypeList = new ObjectType[uninterestingSubclassList.length];
        for (int i = 0; i < uninterestingSubclassList.length; ++i) {
            this.uninterestingSubclassTypeList[i] = new ObjectType(uninterestingSubclassList[i]);
        }
        this.bugType = bugType;
    }

    public Stream createStream(Location location, ObjectType type, ConstantPoolGen cpg, RepositoryLookupFailureCallback lookupFailureCallback) {
        try {
            Instruction ins = location.getHandle().getInstruction();
            if (ins.getOpcode() != 187) {
                return null;
            }
            if (Hierarchy.isSubtype((ReferenceType)type, (ReferenceType)this.baseClassType)) {
                boolean isUninteresting = false;
                ObjectType[] arr$ = this.uninterestingSubclassTypeList;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ObjectType aUninterestingSubclassTypeList = arr$[i$];
                    if (!Hierarchy.isSubtype((ReferenceType)type, (ReferenceType)aUninterestingSubclassTypeList)) continue;
                    isUninteresting = true;
                    break;
                }
                Stream result = new Stream(location, type.getClassName(), this.baseClassType.getClassName()).setIgnoreImplicitExceptions(true);
                if (!isUninteresting) {
                    result.setInteresting(this.bugType);
                }
                return result;
            }
        }
        catch (ClassNotFoundException e) {
            lookupFailureCallback.reportMissingClass(e);
        }
        return null;
    }
}

