/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class TestingGround
extends BytecodeScanningDetector {
    private static final boolean active = Boolean.getBoolean("findbugs.tg.active");
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        if (active) {
            this.stack.resetForMethodEntry((PreorderVisitor)this);
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 184 && this.getNameConstantOperand().equals("forName") && this.getClassConstantOperand().equals("java/lang/Class") && this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
            if (this.stack.getStackDepth() == 0) {
                System.out.println("empty stack");
            } else {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                Object constantValue = item.getConstant();
                if (constantValue != null && constantValue instanceof String) {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(" + constantValue + ")");
                } else {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(???)");
                }
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

