/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class DoInsideDoPriviledged
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    boolean isDoPriviledged = false;

    public DoInsideDoPriviledged(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        try {
            this.isDoPriviledged = Repository.implementationOf((String)this.getClassName(), (String)"java/security/PrivilegedAction") || Repository.implementationOf((String)this.getClassName(), (String)"java/security/PrivilegedExceptionAction");
        }
        catch (ClassNotFoundException e) {
            this.isDoPriviledged = true;
        }
    }

    public void visit(Code obj) {
        if (this.isDoPriviledged && this.getMethodName().equals("run")) {
            return;
        }
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        try {
            String classOfConstructedClass;
            JavaClass constructedClass;
            if (!(seen != 187 || !Repository.instanceOf((JavaClass)(constructedClass = Repository.lookupClass((String)(classOfConstructedClass = this.getClassConstantOperand()))), (String)"java/lang/ClassLoader") || this.getMethodName().equals("main") && this.getMethodSig().equals("([Ljava/lang/String;)V") && this.getMethod().isStatic())) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEDGED", 2).addClassAndMethod((PreorderVisitor)this).addClass(constructedClass).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

