/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;

public class FindLocalSelfAssignment2
extends BytecodeScanningDetector
implements StatelessDetector {
    private BugReporter bugReporter;
    private int previousLoadOf = -1;
    private int previousGotoTarget;
    private int gotoCount;

    public FindLocalSelfAssignment2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(Code obj) {
        this.previousLoadOf = -1;
        this.previousGotoTarget = -1;
        this.gotoCount = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (seen == 167) {
            this.previousGotoTarget = this.getBranchTarget();
            ++this.gotoCount;
        } else if (this.isRegisterLoad()) {
            this.previousLoadOf = this.getRegisterOperand();
        } else {
            if (this.isRegisterStore() && this.previousLoadOf == this.getRegisterOperand() && this.gotoCount < 2 && this.getPC() != this.previousGotoTarget) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SA_LOCAL_SELF_ASSIGNMENT", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
            this.previousLoadOf = -1;
            this.gotoCount = 0;
        }
    }
}

