/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Naming
extends PreorderVisitor
implements Detector {
    String baseClassName;
    boolean classIsPublicOrProtected;
    HashMap<String, HashSet<String>> canonicalToTrueMapping = new HashMap();
    HashMap<String, HashSet<MyMethod>> canonicalToMyMethod = new HashMap();
    HashSet<String> visited = new HashSet();
    private BugReporter bugReporter;
    private static Pattern sigType = Pattern.compile("L([^;]*/)?([^/]+;)");

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            try {
                MyMethod m3;
                boolean r;
                if (!m.confusingMethodNames(m2) || !Repository.instanceOf((String)m.className, (String)m2.className) || (r = others.contains(m3 = new MyMethod(m.className, m2.methodName, m2.methodSig, m.isStatic)))) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_VERY_CONFUSING", 1).addClass(m.getClassName()).addMethod(m.getClassName(), m.methodName, m.methodSig, m.isStatic).addClass(m2.getClassName()).addMethod(m2.getClassName(), m2.methodName, m2.methodSig, m2.isStatic));
                return true;
            }
            catch (ClassNotFoundException e) {
            }
        }
        return false;
    }

    private boolean checkNonSuper(MyMethod m, HashSet<MyMethod> others) {
        for (MyMethod m2 : others) {
            if (!m.confusingMethodNames(m2)) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CONFUSING", 3).addClass(m.getClassName()).addMethod(m.getClassName(), m.methodName, m.methodSig, m.isStatic).addClass(m2.getClassName()).addMethod(m2.getClassName(), m2.methodName, m2.methodSig, m2.isStatic));
            return true;
        }
        return false;
    }

    public void report() {
        for (String allSmall : this.canonicalToTrueMapping.keySet()) {
            HashSet<String> s = this.canonicalToTrueMapping.get(allSmall);
            if (s.size() <= 1) continue;
            HashSet<MyMethod> conflictingMethods = this.canonicalToMyMethod.get(allSmall);
            Iterator<MyMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            for (MyMethod conflictingMethod : conflictingMethods) {
                if (this.checkNonSuper(conflictingMethod, conflictingMethods)) break;
            }
        }
    }

    public void visitJavaClass(JavaClass obj) {
        if (obj.isInterface()) {
            return;
        }
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        try {
            JavaClass[] supers;
            for (JavaClass aSuper : supers = Repository.getSuperClasses((JavaClass)obj)) {
                this.visitJavaClass(aSuper);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        super.visitJavaClass(obj);
    }

    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$+.]");
        this.baseClassName = parts[parts.length - 1];
        boolean bl = this.classIsPublicOrProtected = obj.isPublic() || obj.isProtected();
        if (this.baseClassName.length() == 1) {
            return;
        }
        if (Character.isLetter(this.baseClassName.charAt(0)) && !Character.isUpperCase(this.baseClassName.charAt(0)) && this.baseClassName.indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NAMING_CONVENTION", this.classIsPublicOrProtected ? 2 : 3).addClass((PreorderVisitor)this));
        }
        if (name.endsWith("Exception") && !obj.getSuperclassName().endsWith("Exception") && !obj.getSuperclassName().endsWith("Error") && !obj.getSuperclassName().endsWith("Throwable")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NOT_EXCEPTION", 2).addClass((PreorderVisitor)this));
        }
        super.visit(obj);
    }

    public void visit(Field obj) {
        if (this.getFieldName().length() == 1) {
            return;
        }
        if (!obj.isFinal() && Character.isLetter(this.getFieldName().charAt(0)) && !Character.isLowerCase(this.getFieldName().charAt(0)) && this.getFieldName().indexOf("_") == -1 && Character.isLetter(this.getFieldName().charAt(1)) && Character.isLowerCase(this.getFieldName().charAt(1))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_FIELD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
        }
    }

    public void visit(Method obj) {
        Code code;
        if (this.getMethodName().length() == 1) {
            return;
        }
        if (Character.isLetter(this.getMethodName().charAt(0)) && !Character.isLowerCase(this.getMethodName().charAt(0)) && Character.isLetter(this.getMethodName().charAt(1)) && Character.isLowerCase(this.getMethodName().charAt(1)) && this.getMethodName().indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClassAndMethod((PreorderVisitor)this));
        }
        String sig = this.getMethodSig();
        if (this.getMethodName().equals(this.baseClassName) && sig.equals("()V") && (code = obj.getCode()) != null) {
            byte[] codeBytes = code.getCode();
            int priority = 2;
            if (codeBytes.length > 1) {
                --priority;
                int lastOpcode = codeBytes[codeBytes.length - 1] & 0xFF;
                if (codeBytes.length < 10 && lastOpcode == 191) {
                    return;
                }
            }
            if (!obj.isPublic() && this.getThisClass().isPublic()) {
                --priority;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_CONSTRUCTOR_CONFUSION", priority).addClassAndMethod((PreorderVisitor)this));
            return;
        }
        if (obj.isAbstract()) {
            return;
        }
        if (obj.isPrivate()) {
            return;
        }
        if (this.getMethodName().equals("equal") && sig.equals("(Ljava/lang/Object;)Z")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_BAD_EQUAL", 1).addClassAndMethod((PreorderVisitor)this));
            return;
        }
        if (this.getMethodName().equals("hashcode") && sig.equals("()I")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_HASHCODE", 1).addClassAndMethod((PreorderVisitor)this));
            return;
        }
        if (this.getMethodName().equals("tostring") && sig.equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_TOSTRING", 1).addClassAndMethod((PreorderVisitor)this));
            return;
        }
        if (obj.isPrivate() || obj.isStatic() || this.getMethodName().equals("<init>")) {
            return;
        }
        String trueName = new StringBuffer().append(this.getMethodName()).append(sig).toString();
        String sig2 = Naming.removePackageNamesFromSignature(sig);
        String allSmall = new StringBuffer().append(this.getMethodName().toLowerCase()).append(sig2).toString();
        MyMethod mm = new MyMethod(this.getThisClass().getClassName(), this.getMethodName(), sig, obj.isStatic());
        HashSet<Object> s = this.canonicalToTrueMapping.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToTrueMapping.put(allSmall, s);
        }
        s.add(trueName);
        s = this.canonicalToMyMethod.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToMyMethod.put(allSmall, s);
        }
        s.add((String)((Object)mm));
    }

    private static String removePackageNamesFromSignature(String sig) {
        int end = sig.indexOf(")");
        Matcher m = sigType.matcher(sig.substring(0, end));
        return new StringBuffer().append(m.replaceAll("L$2")).append(sig.substring(end)).toString();
    }

    static class MyMethod {
        final String className;
        final String methodName;
        final String methodSig;
        final boolean isStatic;

        MyMethod(String cName, String n, String s, boolean isStatic) {
            this.className = cName;
            this.methodName = n;
            this.methodSig = s;
            this.isStatic = isStatic;
        }

        public String getClassName() {
            return this.className;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MyMethod)) {
                return false;
            }
            MyMethod m2 = (MyMethod)o;
            return this.className.equals(m2.className) && this.methodName.equals(m2.methodName) && this.methodSig.equals(m2.methodSig);
        }

        public int hashCode() {
            return this.className.hashCode() + this.methodName.hashCode() + this.methodSig.hashCode();
        }

        public boolean confusingMethodNames(MyMethod m) {
            if (this.className.equals(m.className)) {
                return false;
            }
            if (this.methodName.equalsIgnoreCase(m.methodName) && !this.methodName.equals(m.methodName)) {
                return true;
            }
            if (this.methodSig.equals(m.methodSig)) {
                return false;
            }
            return Naming.removePackageNamesFromSignature(this.methodSig).equals(Naming.removePackageNamesFromSignature(m.methodSig));
        }

        public String toString() {
            return this.className + "." + this.methodName + ":" + this.methodSig;
        }
    }
}

