/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class TestingGround
extends BytecodeScanningDetector {
    private static final boolean active = Boolean.getBoolean("findbugs.tg.active");
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();
    boolean isInnerClass = false;

    public TestingGround(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void visit(JavaClass obj) {
        this.isInnerClass = false;
        String name = this.getClassName();
        int i = name.lastIndexOf(36);
        if (i >= 0 && i + 1 < name.length()) {
            this.isInnerClass = Character.isDigit(name.charAt(i + 1));
        }
    }

    boolean definedInThisClassOrSuper(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        System.out.println("Checking to see if " + method + " is defined in " + clazz.getClassName());
        Method[] arr$ = clazz.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            if (!method.equals(m.getName() + ":" + m.getSignature())) continue;
            return true;
        }
        return this.definedInSuperClassOrInterface(clazz, method);
    }

    boolean definedInSuperClassOrInterface(JavaClass clazz, String method) throws ClassNotFoundException {
        if (clazz == null) {
            return false;
        }
        JavaClass superClass = clazz.getSuperClass();
        if (this.definedInThisClassOrSuper(superClass, method)) {
            return true;
        }
        JavaClass[] arr$ = clazz.getInterfaces();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            JavaClass i = arr$[i$];
            if (!this.definedInThisClassOrSuper(i, method)) continue;
            return true;
        }
        return false;
    }

    public void visit(Method obj) {
        try {
            if (this.isInnerClass) {
                if (this.getMethodName().equals("<init>")) {
                    return;
                }
                JavaClass clazz = this.getThisClass();
                XMethod xmethod = XFactory.createXMethod((JavaClass)clazz, (Method)obj);
                if (!this.definedInSuperClassOrInterface(clazz, obj.getName() + ":" + obj.getSignature())) {
                    System.out.println("XXXX");
                }
            }
        }
        catch (ClassNotFoundException e) {
            System.out.println("FOFO");
        }
    }

    public void visit(Code obj) {
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 184 && this.getNameConstantOperand().equals("forName") && this.getClassConstantOperand().equals("java/lang/Class") && this.getSigConstantOperand().equals("(Ljava/lang/String;)Ljava/lang/Class;")) {
            if (this.stack.getStackDepth() == 0) {
                System.out.println("empty stack");
            } else {
                OpcodeStack.Item item = this.stack.getStackItem(0);
                Object constantValue = item.getConstant();
                if (constantValue != null && constantValue instanceof String) {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(" + constantValue + ")");
                } else {
                    System.out.println("XXYYZ: " + this.getFullyQualifiedMethodName() + " Class.forName(???)");
                }
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
    }
}

