/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class FindBugsTask
extends Task {
    private static final String FINDBUGS_JAR = "findbugs.jar";
    private static final long DEFAULT_TIMEOUT = 600000L;
    private boolean debug = false;
    private boolean sorted = true;
    private boolean quietErrors = false;
    private File homeDir = null;
    private File projectFile = null;
    private File excludeFile = null;
    private File includeFile = null;
    private Path auxClasspath = null;
    private Path sourcePath = null;
    private String outputFormat = "xml";
    private String reportLevel = null;
    private String jvmargs = "";
    private String visitors = null;
    private String omitVisitors = null;
    private String outputFileName = null;
    private List classLocations = new ArrayList();
    private long timeout = 600000L;
    private Path classpath = null;
    private Path pluginList = null;
    private Java findbugsEngine = null;

    public void setJvmargs(String args) {
        this.jvmargs = args;
    }

    public void setVisitors(String commaSeperatedString) {
        this.visitors = commaSeperatedString;
    }

    public void setOmitVisitors(String commaSeperatedString) {
        this.omitVisitors = commaSeperatedString;
    }

    public void setHome(File homeDir) {
        this.homeDir = homeDir;
    }

    public void setOutput(String format) {
        this.outputFormat = format;
    }

    public void setReportLevel(String level) {
        this.reportLevel = level;
    }

    public void setSort(boolean flag) {
        this.sorted = flag;
    }

    public void setQuietErrors(boolean flag) {
        this.quietErrors = flag;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public void setExcludeFilter(File filterFile) {
        this.excludeFile = filterFile;
    }

    public void setIncludeFilter(File filterFile) {
        this.includeFile = filterFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setAuxClasspath(Path src) {
        if (this.auxClasspath == null) {
            this.auxClasspath = src;
        } else {
            this.auxClasspath.append(src);
        }
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.project);
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createAuxClasspath().setRefid(r);
    }

    public void setSourcePath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public Path createSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.project);
        }
        return this.sourcePath.createPath();
    }

    public void setSourcePathRef(Reference r) {
        this.createSourcePath().setRefid(r);
    }

    public ClassLocation createClass() {
        ClassLocation cl = new ClassLocation();
        this.classLocations.add(cl);
        return cl;
    }

    public void setOutputFile(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.execFindbugs();
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setPluginList(Path src) {
        if (this.pluginList == null) {
            this.pluginList = src;
        } else {
            this.pluginList.append(src);
        }
    }

    public Path createPluginList() {
        if (this.pluginList == null) {
            this.pluginList = new Path(this.project);
        }
        return this.pluginList.createPath();
    }

    public void setPluginListRef(Reference r) {
        this.createPluginList().setRefid(r);
    }

    private void checkParameters() {
        if (this.homeDir == null && (this.classpath == null || this.pluginList == null)) {
            throw new BuildException("either home attribute or classpath and pluginList attributes  must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.pluginList != null) {
            String[] pluginFileList = this.pluginList.list();
            for (int i = 0; i < pluginFileList.length; ++i) {
                String pluginFile = pluginFileList[i];
                if (pluginFile.endsWith(".jar")) continue;
                throw new BuildException("plugin file " + pluginFile + " is not a Jar file " + "in task <" + this.getTaskName() + "/>", this.getLocation());
            }
        }
        if (this.projectFile == null && this.classLocations.size() == 0) {
            throw new BuildException("either projectfile or <class/> child elements must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.outputFormat != null && !this.outputFormat.trim().equalsIgnoreCase("xml") && !this.outputFormat.trim().equalsIgnoreCase("text")) {
            throw new BuildException("output attribute must be either 'text' or 'xml' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.reportLevel == null || this.reportLevel.trim().equalsIgnoreCase("low") || this.reportLevel.trim().equalsIgnoreCase("medium") || this.reportLevel.trim().equalsIgnoreCase("high"))) {
            throw new BuildException("reportlevel attribute must be either 'low' or 'medium' or 'high' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.excludeFile != null && this.includeFile != null) {
            throw new BuildException("only one of excludeFile and includeFile  attributes may be used in task <" + this.getTaskName() + "/>", this.getLocation());
        }
    }

    private void addArg(String arg) {
        this.findbugsEngine.createArg().setValue(arg);
    }

    private void execFindbugs() throws BuildException {
        this.findbugsEngine = (Java)this.project.createTask("java");
        this.findbugsEngine.setTaskName(this.getTaskName());
        this.findbugsEngine.setFork(true);
        this.findbugsEngine.setTimeout(new Long(this.timeout));
        if (this.debug) {
            this.jvmargs = this.jvmargs + " -Dfindbugs.debug=true";
        }
        this.findbugsEngine.createJvmarg().setLine(this.jvmargs);
        if (this.homeDir != null) {
            this.findbugsEngine.setJar(new File(this.homeDir + File.separator + "lib" + File.separator + FINDBUGS_JAR));
            this.addArg("-home");
            this.addArg(this.homeDir.getPath());
        } else {
            this.findbugsEngine.setClasspath(this.classpath);
            this.findbugsEngine.setClassname("edu.umd.cs.findbugs.FindBugs");
            this.addArg("-pluginList");
            this.addArg(this.pluginList.toString());
        }
        if (this.sorted) {
            this.addArg("-sortByClass");
        }
        if (this.outputFormat != null && this.outputFormat.trim().equalsIgnoreCase("xml")) {
            this.addArg("-xml");
        }
        if (this.quietErrors) {
            this.addArg("-quiet");
        }
        if (this.reportLevel != null) {
            this.addArg("-" + this.reportLevel.trim().toLowerCase());
        }
        if (this.projectFile != null) {
            this.addArg("-project");
            this.addArg(this.projectFile.getPath());
        }
        if (this.excludeFile != null) {
            this.addArg("-exclude");
            this.addArg(this.excludeFile.getPath());
        }
        if (this.includeFile != null) {
            this.addArg("-include");
            this.addArg(this.includeFile.getPath());
        }
        if (this.visitors != null) {
            this.addArg("-visitors");
            this.addArg(this.visitors);
        }
        if (this.omitVisitors != null) {
            this.addArg("-omitVisitors");
            this.addArg(this.omitVisitors);
        }
        if (this.auxClasspath != null) {
            this.addArg("-auxclasspath");
            this.addArg(this.auxClasspath.toString());
        }
        if (this.sourcePath != null) {
            this.addArg("-sourcepath");
            this.addArg(this.sourcePath.toString());
        }
        if (this.outputFileName != null) {
            this.addArg("-outputFile");
            this.addArg(this.outputFileName);
        }
        this.addArg("-exitcode");
        Iterator itr = this.classLocations.iterator();
        while (itr.hasNext()) {
            this.addArg(itr.next().toString());
        }
        this.log("Running FindBugs...");
        int rc = this.findbugsEngine.executeJava();
        if ((rc & 4) != 0) {
            throw new BuildException("Execution of findbugs failed.");
        }
        if ((rc & 1) != 0) {
            this.log("Bugs were found");
        } else {
            this.log("No bugs were found");
        }
        if ((rc & 2) != 0) {
            this.log("Classes needed for analysis were missing");
        }
        if (this.outputFileName != null) {
            this.log("Output saved to " + this.outputFileName);
        }
    }

    public class ClassLocation {
        File classLocation = null;

        public void setLocation(File location) {
            this.classLocation = location;
        }

        public File getLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.classLocation != null ? this.classLocation.toString() : "";
        }
    }
}

