/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.anttask;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class FindBugsTask
extends Task {
    private static final String FINDBUGS_JAR = "findbugs.jar";
    private static final long DEFAULT_TIMEOUT = 600000L;
    private boolean debug = false;
    private String effort;
    private boolean conserveSpace = false;
    private boolean sorted = true;
    private boolean timestampNow = true;
    private boolean quietErrors = false;
    private boolean failOnError = false;
    private String errorProperty = null;
    private String warningsProperty = null;
    private boolean workHard = false;
    private boolean relaxed = false;
    private boolean adjustExperimental = false;
    private File homeDir = null;
    private File projectFile = null;
    private File excludeFile = null;
    private File includeFile = null;
    private Path auxClasspath = null;
    private Path sourcePath = null;
    private String outputFormat = "xml";
    private String reportLevel = null;
    private String jvmargs = "";
    private String visitors = null;
    private String omitVisitors = null;
    private String outputFileName = null;
    private String stylesheet = null;
    private List<ClassLocation> classLocations = new ArrayList<ClassLocation>();
    private long timeout = 600000L;
    private Path classpath = null;
    private Path pluginList = null;
    private List<SystemProperty> systemPropertyList = new ArrayList<SystemProperty>();
    private Java findbugsEngine = null;

    public void setJvmargs(String args) {
        this.jvmargs = args;
    }

    public void setWorkHard(boolean workHard) {
        this.workHard = workHard;
    }

    public void setRelaxed(boolean relaxed) {
        this.relaxed = relaxed;
    }

    public void setAdjustExperimental(boolean adjustExperimental) {
        this.adjustExperimental = adjustExperimental;
    }

    public void setVisitors(String commaSeperatedString) {
        this.visitors = commaSeperatedString;
    }

    public void setOmitVisitors(String commaSeperatedString) {
        this.omitVisitors = commaSeperatedString;
    }

    public void setHome(File homeDir) {
        this.homeDir = homeDir;
    }

    public void setOutput(String format) {
        this.outputFormat = format;
    }

    public void setStylesheet(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public void setReportLevel(String level) {
        this.reportLevel = level;
    }

    public void setSort(boolean flag) {
        this.sorted = flag;
    }

    public void setTimestampNow(boolean flag) {
        this.timestampNow = flag;
    }

    public void setQuietErrors(boolean flag) {
        this.quietErrors = flag;
    }

    public void setFailOnError(boolean flag) {
        this.failOnError = flag;
    }

    public void setErrorProperty(String name) {
        this.errorProperty = name;
    }

    public void setWarningsProperty(String name) {
        this.warningsProperty = name;
    }

    public void setDebug(boolean flag) {
        this.debug = flag;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public void setConserveSpace(boolean flag) {
        this.conserveSpace = flag;
    }

    public void setExcludeFilter(File filterFile) {
        this.excludeFile = filterFile;
    }

    public void setIncludeFilter(File filterFile) {
        this.includeFile = filterFile;
    }

    public void setProjectFile(File projectFile) {
        this.projectFile = projectFile;
    }

    public void setAuxClasspath(Path src) {
        String[] elementList;
        boolean nonEmpty = false;
        String[] arr$ = elementList = src.list();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String anElementList = arr$[i$];
            if (anElementList.equals("")) continue;
            nonEmpty = true;
            break;
        }
        if (nonEmpty) {
            if (this.auxClasspath == null) {
                this.auxClasspath = src;
            } else {
                this.auxClasspath.append(src);
            }
        }
    }

    public Path createAuxClasspath() {
        if (this.auxClasspath == null) {
            this.auxClasspath = new Path(this.getProject());
        }
        return this.auxClasspath.createPath();
    }

    public void setAuxClasspathRef(Reference r) {
        this.createAuxClasspath().setRefid(r);
    }

    public void setSourcePath(Path src) {
        if (this.sourcePath == null) {
            this.sourcePath = src;
        } else {
            this.sourcePath.append(src);
        }
    }

    public Path createSourcePath() {
        if (this.sourcePath == null) {
            this.sourcePath = new Path(this.getProject());
        }
        return this.sourcePath.createPath();
    }

    public void setSourcePathRef(Reference r) {
        this.createSourcePath().setRefid(r);
    }

    public ClassLocation createClass() {
        ClassLocation cl = new ClassLocation();
        this.classLocations.add(cl);
        return cl;
    }

    public void setOutputFile(String outputFileName) {
        this.outputFileName = outputFileName;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void execute() throws BuildException {
        block3: {
            this.checkParameters();
            try {
                this.execFindbugs();
            }
            catch (BuildException e) {
                if (this.errorProperty != null) {
                    this.getProject().setProperty(this.errorProperty, "true");
                }
                if (!this.failOnError) break block3;
                throw e;
            }
        }
    }

    public void setClasspath(Path src) {
        if (this.classpath == null) {
            this.classpath = src;
        } else {
            this.classpath.append(src);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public void setPluginList(Path src) {
        if (this.pluginList == null) {
            this.pluginList = src;
        } else {
            this.pluginList.append(src);
        }
    }

    public Path createPluginList() {
        if (this.pluginList == null) {
            this.pluginList = new Path(this.getProject());
        }
        return this.pluginList.createPath();
    }

    public void setPluginListRef(Reference r) {
        this.createPluginList().setRefid(r);
    }

    public SystemProperty createSystemProperty() {
        SystemProperty systemProperty = new SystemProperty();
        this.systemPropertyList.add(systemProperty);
        return systemProperty;
    }

    private void checkParameters() {
        if (this.homeDir == null && (this.classpath == null || this.pluginList == null)) {
            throw new BuildException("either home attribute or classpath and pluginList attributes  must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.pluginList != null) {
            String[] pluginFileList;
            String[] arr$ = pluginFileList = this.pluginList.list();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String pluginFile = arr$[i$];
                if (pluginFile.endsWith(".jar")) continue;
                throw new BuildException("plugin file " + pluginFile + " is not a Jar file " + "in task <" + this.getTaskName() + "/>", this.getLocation());
            }
        }
        if (this.projectFile == null && this.classLocations.size() == 0) {
            throw new BuildException("either projectfile or <class/> child elements must be defined for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.outputFormat == null || this.outputFormat.trim().equalsIgnoreCase("xml") || this.outputFormat.trim().equalsIgnoreCase("xml:withMessages") || this.outputFormat.trim().equalsIgnoreCase("html") || this.outputFormat.trim().equalsIgnoreCase("text") || this.outputFormat.trim().equalsIgnoreCase("xdocs") || this.outputFormat.trim().equalsIgnoreCase("emacs"))) {
            throw new BuildException("output attribute must be either 'text', 'xml', 'html', 'xdocs' or 'emacs' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (!(this.reportLevel == null || this.reportLevel.trim().equalsIgnoreCase("experimental") || this.reportLevel.trim().equalsIgnoreCase("low") || this.reportLevel.trim().equalsIgnoreCase("medium") || this.reportLevel.trim().equalsIgnoreCase("high"))) {
            throw new BuildException("reportlevel attribute must be either 'experimental' or 'low' or 'medium' or 'high' for task <" + this.getTaskName() + "/>", this.getLocation());
        }
        if (this.excludeFile != null && this.includeFile != null) {
            throw new BuildException("only one of excludeFile and includeFile  attributes may be used in task <" + this.getTaskName() + "/>", this.getLocation());
        }
        Iterator<SystemProperty> i$ = this.systemPropertyList.iterator();
        while (i$.hasNext()) {
            SystemProperty aSystemPropertyList = i$.next();
            SystemProperty systemProperty = aSystemPropertyList;
            if (systemProperty.getName() != null && systemProperty.getValue() != null) continue;
            throw new BuildException("systemProperty elements must have name and value attributes");
        }
        if (!(this.effort == null || this.effort.equals("min") || this.effort.equals("default") || this.effort.equals("max"))) {
            throw new BuildException("effort attribute must be one of 'min', 'default', or 'max'");
        }
    }

    private void addArg(String arg) {
        this.findbugsEngine.createArg().setValue(arg);
    }

    private void execFindbugs() throws BuildException {
        this.findbugsEngine = (Java)this.getProject().createTask("java");
        this.findbugsEngine.setTaskName(this.getTaskName());
        this.findbugsEngine.setFork(true);
        this.findbugsEngine.setTimeout(new Long(this.timeout));
        if (this.debug) {
            this.jvmargs = this.jvmargs + " -Dfindbugs.debug=true";
        }
        this.findbugsEngine.createJvmarg().setLine(this.jvmargs);
        Iterator<Object> i$ = this.systemPropertyList.iterator();
        while (i$.hasNext()) {
            SystemProperty aSystemPropertyList;
            SystemProperty systemProperty = aSystemPropertyList = i$.next();
            String jvmArg = "-D" + systemProperty.getName() + "=" + systemProperty.getValue();
            this.findbugsEngine.createJvmarg().setValue(jvmArg);
        }
        if (this.homeDir != null) {
            this.findbugsEngine.setJar(new File(this.homeDir + File.separator + "lib" + File.separator + FINDBUGS_JAR));
            this.addArg("-home");
            this.addArg(this.homeDir.getPath());
        } else {
            this.findbugsEngine.setClasspath(this.classpath);
            this.findbugsEngine.setClassname("edu.umd.cs.findbugs.FindBugs");
            this.addArg("-pluginList");
            this.addArg(this.pluginList.toString());
        }
        if (this.adjustExperimental) {
            this.addArg("-adjustExperimental");
        }
        if (this.conserveSpace) {
            this.addArg("-conserveSpace");
        }
        if (this.workHard) {
            this.addArg("-workHard");
        }
        if (this.effort != null) {
            this.addArg("-effort:" + this.effort);
        }
        if (this.sorted) {
            this.addArg("-sortByClass");
        }
        if (this.timestampNow) {
            this.addArg("-timestampNow");
        }
        if (this.outputFormat != null && !this.outputFormat.trim().equalsIgnoreCase("text")) {
            this.outputFormat = this.outputFormat.trim();
            String outputArg = "-";
            int colon = this.outputFormat.indexOf(58);
            if (colon >= 0) {
                outputArg = outputArg + this.outputFormat.substring(0, colon).toLowerCase();
                outputArg = outputArg + ":";
                outputArg = outputArg + this.outputFormat.substring(colon + 1);
            } else {
                outputArg = outputArg + this.outputFormat.toLowerCase();
                if (this.stylesheet != null) {
                    outputArg = outputArg + ":";
                    outputArg = outputArg + this.stylesheet.trim();
                }
            }
            this.addArg(outputArg);
        }
        if (this.quietErrors) {
            this.addArg("-quiet");
        }
        if (this.reportLevel != null) {
            this.addArg("-" + this.reportLevel.trim().toLowerCase());
        }
        if (this.projectFile != null) {
            this.addArg("-project");
            this.addArg(this.projectFile.getPath());
        }
        if (this.excludeFile != null) {
            this.addArg("-exclude");
            this.addArg(this.excludeFile.getPath());
        }
        if (this.includeFile != null) {
            this.addArg("-include");
            this.addArg(this.includeFile.getPath());
        }
        if (this.visitors != null) {
            this.addArg("-visitors");
            this.addArg(this.visitors);
        }
        if (this.omitVisitors != null) {
            this.addArg("-omitVisitors");
            this.addArg(this.omitVisitors);
        }
        if (this.auxClasspath != null) {
            this.addArg("-auxclasspath");
            this.addArg(this.auxClasspath.toString());
        }
        if (this.sourcePath != null) {
            this.addArg("-sourcepath");
            this.addArg(this.sourcePath.toString());
        }
        if (this.outputFileName != null) {
            this.addArg("-outputFile");
            this.addArg(this.outputFileName);
        }
        if (this.relaxed) {
            this.addArg("-relaxed");
        }
        this.addArg("-exitcode");
        i$ = this.classLocations.iterator();
        while (i$.hasNext()) {
            ClassLocation classLocation = (ClassLocation)i$.next();
            this.addArg(classLocation.toString());
        }
        this.log("Running FindBugs...");
        int rc = this.findbugsEngine.executeJava();
        if ((rc & 4) != 0) {
            throw new BuildException("Execution of findbugs failed.");
        }
        if ((rc & 2) != 0) {
            this.log("Classes needed for analysis were missing");
        }
        if (this.warningsProperty != null && (rc & 1) != 0) {
            this.getProject().setProperty(this.warningsProperty, "true");
        }
        if (this.outputFileName != null) {
            this.log("Output saved to " + this.outputFileName);
        }
    }

    public static class SystemProperty {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static class ClassLocation {
        File classLocation = null;

        public void setLocation(File location) {
            this.classLocation = location;
        }

        public File getLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.classLocation != null ? this.classLocation.toString() : "";
        }
    }
}

