/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.DismantleBytecode;
import java.util.HashSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Method;

public class DumbMethods
extends BytecodeScanningDetector
implements Constants2 {
    private HashSet<String> alreadyReported = new HashSet();
    private BugReporter bugReporter;
    private boolean sawCurrentTimeMillis;
    private BugInstance gcInvocationBugReport;
    private int gcInvocationPC;
    private CodeException[] exceptionTable;
    private static final int OOM_CATCH_LEN = 20;

    public DumbMethods(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method method) {
        this.flush();
        Code code = method.getCode();
        if (code != null) {
            this.exceptionTable = code.getExceptionTable();
        }
        if (this.exceptionTable == null) {
            this.exceptionTable = new CodeException[0];
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 183 && this.classConstant.equals("java/lang/String") && this.nameConstant.equals("<init>") && this.sigConstant.equals("(Ljava/lang/String;)V") && this.alreadyReported.add(this.refConstant)) {
            this.bugReporter.reportBug(new BugInstance("DM_STRING_CTOR", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 183 && this.classConstant.equals("java/lang/String") && this.nameConstant.equals("<init>") && this.sigConstant.equals("()V") && this.alreadyReported.add(this.refConstant)) {
            this.bugReporter.reportBug(new BugInstance("DM_STRING_VOID_CTOR", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if ((seen == 184 && this.classConstant.equals("java/lang/System") || seen == 182 && this.classConstant.equals("java/lang/Runtime")) && this.nameConstant.equals("gc") && this.sigConstant.equals("()V") && !this.betterClassName.startsWith("java.lang") && this.alreadyReported.add(this.refConstant)) {
            this.gcInvocationBugReport = new BugInstance("DM_GC", 1).addClassAndMethod((BetterVisitor)this).addSourceLine((DismantleBytecode)this);
            this.gcInvocationPC = this.PC;
        }
        if (seen == 183 && this.classConstant.equals("java/lang/Boolean") && this.nameConstant.equals("<init>") && !this.className.equals("java/lang/Boolean") && this.alreadyReported.add(this.refConstant)) {
            this.bugReporter.reportBug(new BugInstance("DM_BOOLEAN_CTOR", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((DismantleBytecode)this));
        }
        if (seen == 184 && this.classConstant.equals("java/lang/System") && this.nameConstant.equals("currentTimeMillis")) {
            this.sawCurrentTimeMillis = true;
        }
    }

    public void report() {
        this.flush();
    }

    private void flush() {
        if (this.gcInvocationBugReport != null && !this.sawCurrentTimeMillis) {
            boolean outOfMemoryHandler = false;
            for (int i = 0; i < this.exceptionTable.length; ++i) {
                String exClassName;
                ConstantPool cp;
                Constant constant;
                int catchTypeIndex;
                CodeException handler = this.exceptionTable[i];
                if (this.gcInvocationPC < handler.getHandlerPC() || this.gcInvocationPC > handler.getHandlerPC() + 20 || (catchTypeIndex = handler.getCatchType()) <= 0 || !((constant = (cp = this.thisClass.getConstantPool()).getConstant(catchTypeIndex)) instanceof ConstantClass) || !(exClassName = (String)((ConstantClass)constant).getConstantValue(cp)).equals("java/lang/OutOfMemoryError")) continue;
                outOfMemoryHandler = true;
                break;
            }
            if (!outOfMemoryHandler) {
                this.bugReporter.reportBug(this.gcInvocationBugReport);
            }
        }
        this.sawCurrentTimeMillis = false;
        this.gcInvocationBugReport = null;
        this.alreadyReported.clear();
        this.exceptionTable = null;
    }
}

