/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindNakedNotify
extends BytecodeScanningDetector
implements Constants2 {
    int stage = 0;
    private BugReporter bugReporter;
    boolean synchronizedMethod;
    private int notifyPC;

    public FindNakedNotify(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        int flags = obj.getAccessFlags();
        this.synchronizedMethod = (flags & 0x20) != 0;
    }

    public void visit(Code obj) {
        this.stage = this.synchronizedMethod ? 1 : 0;
        super.visit(obj);
        if (this.synchronizedMethod && this.stage == 4) {
            this.bugReporter.reportBug(new BugInstance("NN_NAKED_NOTIFY", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.notifyPC));
        }
    }

    public void sawOpcode(int seen) {
        switch (this.stage) {
            case 0: {
                if (seen != 194) break;
                this.stage = 1;
                break;
            }
            case 1: {
                this.stage = 2;
                break;
            }
            case 2: {
                if (seen == 182 && (this.nameConstant.equals("notify") || this.nameConstant.equals("notifyAll")) && this.sigConstant.equals("()V")) {
                    this.stage = 3;
                    this.notifyPC = this.PC;
                    break;
                }
                this.stage = 0;
                break;
            }
            case 3: {
                this.stage = 4;
                break;
            }
            case 4: {
                if (seen == 195) {
                    this.bugReporter.reportBug(new BugInstance("NN_NAKED_NOTIFY", 2).addClassAndMethod((BetterVisitor)this).addSourceLine((BetterVisitor)this, this.notifyPC));
                    this.stage = 5;
                    break;
                }
                this.stage = 0;
                break;
            }
        }
    }
}

