/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.daveho.ba.AnalysisException;
import edu.umd.cs.daveho.ba.BasicBlock;
import edu.umd.cs.daveho.ba.CFG;
import edu.umd.cs.daveho.ba.CFGBuilderException;
import edu.umd.cs.daveho.ba.ClassContext;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;

public class DroppedException2
implements Detector {
    private BugReporter bugReporter;

    public DroppedException2(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            Method[] methodList = classContext.getJavaClass().getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                Method method = methodList[i];
                if (classContext.getMethodGen(method) == null) continue;
                CFG cfg = classContext.getCFG(method);
                Iterator j = cfg.blockIterator();
                while (j.hasNext()) {
                    BasicBlock basicBlock = (BasicBlock)j.next();
                    if (basicBlock.isExceptionHandler()) continue;
                }
            }
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("DroppedException2 caught exception: " + (Object)((Object)e), (Throwable)e);
        }
    }

    public void report() {
    }
}

