/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.DismantleBytecode;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

public class FindFinalizeInvocations
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("ffi.debug");
    private BugReporter bugReporter;
    boolean sawSuperFinalize;

    public FindFinalizeInvocations(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("FFI: visiting " + this.betterMethodName);
        }
        if (this.methodName.equals("finalize") && this.methodSig.equals("()V") && (obj.getAccessFlags() & 1) != 0) {
            this.bugReporter.reportBug(new BugInstance("FI_PUBLIC_SHOULD_BE_PROTECTED", 2).addClassAndMethod((BetterVisitor)this));
        }
    }

    public void visit(Code obj) {
        this.sawSuperFinalize = false;
        super.visit(obj);
        if (!this.methodName.equals("finalize") || !this.methodSig.equals("()V")) {
            return;
        }
        String overridesFinalizeIn = Lookup.findSuperImplementor((String)this.betterClassName, (String)"finalize", (String)"()V", (BugReporter)this.bugReporter);
        boolean superHasNoFinalizer = overridesFinalizeIn.equals("java.lang.Object");
        if (obj.getCode().length == 1) {
            if (superHasNoFinalizer) {
                this.bugReporter.reportBug(new BugInstance("FI_EMPTY", 2).addClassAndMethod((BetterVisitor)this));
            } else {
                this.bugReporter.reportBug(new BugInstance("FI_NULLIFY_SUPER", 2).addClassAndMethod((BetterVisitor)this).addClass(overridesFinalizeIn));
            }
        } else if (obj.getCode().length == 5 && this.sawSuperFinalize) {
            this.bugReporter.reportBug(new BugInstance("FI_USELESS", 2).addClassAndMethod((BetterVisitor)this));
        } else if (!this.sawSuperFinalize && !superHasNoFinalizer) {
            this.bugReporter.reportBug(new BugInstance("FI_MISSING_SUPER_CALL", 2).addClassAndMethod((BetterVisitor)this).addClass(overridesFinalizeIn));
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 182 && this.nameConstant.equals("finalize")) {
            this.bugReporter.reportBug(new BugInstance("FI_EXPLICIT_INVOCATION", 2).addClassAndMethod((BetterVisitor)this).addCalledMethod((DismantleBytecode)this).describe("METHOD_CALLED").addSourceLine((BetterVisitor)this, this.PC));
        }
        if (seen == 183 && this.nameConstant.equals("finalize")) {
            this.sawSuperFinalize = true;
        }
    }
}

