/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.pugh.visitclass.BetterVisitor;
import edu.umd.cs.pugh.visitclass.Constants2;
import edu.umd.cs.pugh.visitclass.DismantleBytecode;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockedFields
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("lockedfields.debug");
    HashSet<FieldAnnotation> volatileOrFinalFields = new HashSet();
    HashSet<FieldAnnotation> fieldsWritten = new HashSet();
    HashSet<FieldAnnotation> fieldsRead = new HashSet();
    HashSet<FieldAnnotation> localLocks = new HashSet();
    HashSet<FieldAnnotation> publicFields = new HashSet();
    HashSet<FieldAnnotation> writtenOutsideOfConstructor = new HashSet();
    boolean synchronizedMethod;
    boolean publicMethod;
    boolean protectedMethod;
    boolean inConstructor;
    Map<FieldAnnotation, int[]> stats = new TreeMap<FieldAnnotation, int[]>();
    int state;
    boolean thisOnTopOfStack;
    boolean doubleThisOnTopOfStack;
    boolean thisLocked;
    boolean thisLockingOnly = true;
    private BugReporter bugReporter;
    static final int READ_LOCKED = 0;
    static final int WRITTEN_LOCKED = 1;
    static final int READ_UNLOCKED = 2;
    static final int WRITTEN_UNLOCKED = 3;
    static final String[] names = new String[]{"R/L", "W/L", "R/U", "W/U"};

    public LockedFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    private void updateStats(Set<FieldAnnotation> fields, int mode) {
        if (!(this.publicMethod || this.protectedMethod || mode != 2 && mode != 3)) {
            return;
        }
        for (FieldAnnotation f : fields) {
            int[] theseStats;
            if (f.getClassName().equals(this.betterClassName) && mode <= 1) {
                this.localLocks.add(f);
            }
            if ((theseStats = this.stats.get(f)) == null) {
                theseStats = new int[4];
                this.stats.put(f, theseStats);
            }
            if (DEBUG) {
                System.out.println(new StringBuffer().append(names[mode]).append("\t").append(this.betterMethodName).append("\t").append(f.toString()).toString());
            }
            int n = mode;
            theseStats[n] = theseStats[n] + 1;
        }
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Field obj) {
        boolean finalField;
        super.visit(obj);
        FieldAnnotation f = FieldAnnotation.fromVisitedField((BetterVisitor)this);
        int flags = obj.getAccessFlags();
        boolean publicField = (flags & 1) != 0;
        boolean volatileField = (flags & 0x40) != 0;
        boolean bl = finalField = (flags & 0x10) != 0;
        if (publicField) {
            this.publicFields.add(f);
        }
        if (volatileField || finalField) {
            this.volatileOrFinalFields.add(f);
        }
    }

    public void visit(Method obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        this.publicMethod = (flags & 1) != 0;
        this.protectedMethod = (flags & 4) != 0;
        this.synchronizedMethod = (flags & 0x20) != 0;
        this.state = this.synchronizedMethod ? 1 : 0;
        this.fieldsWritten.clear();
        this.fieldsRead.clear();
        this.inConstructor = this.methodName.equals("<init>") || this.methodName.equals("<clinit>") || this.methodName.equals("readObject") || this.methodName.equals("clone") || this.methodName.equals("close") || this.methodName.equals("finalize");
    }

    public void visit(Code obj) {
        if (this.inConstructor) {
            return;
        }
        this.thisOnTopOfStack = false;
        this.thisLocked = false;
        super.visit(obj);
        if (this.state == 1) {
            this.updateStats(this.fieldsWritten, 1);
            this.updateStats(this.fieldsRead, 0);
        } else if (obj.getCode().length > 6) {
            this.updateStats(this.fieldsWritten, 3);
            this.updateStats(this.fieldsRead, 2);
        }
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 58: 
            case 76: 
            case 77: 
            case 78: {
                this.thisOnTopOfStack = this.doubleThisOnTopOfStack;
                return;
            }
            case 42: {
                this.thisOnTopOfStack = true;
                return;
            }
            case 89: {
                this.doubleThisOnTopOfStack = this.thisOnTopOfStack;
                return;
            }
            case 195: {
                if (this.thisLockingOnly && !this.thisLocked) break;
                this.updateStats(this.fieldsWritten, 1);
                this.updateStats(this.fieldsRead, 0);
                this.state = 2;
                this.fieldsWritten.clear();
                this.fieldsRead.clear();
                break;
            }
            case 194: {
                this.thisLocked = this.thisOnTopOfStack;
                if (this.thisLockingOnly && !this.thisLocked) break;
                this.updateStats(this.fieldsWritten, 3);
                this.updateStats(this.fieldsRead, 2);
                this.state = 1;
                this.fieldsWritten.clear();
                this.fieldsRead.clear();
                break;
            }
            case 181: {
                FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
                this.writtenOutsideOfConstructor.add(f);
                if (!this.className.equals(this.classConstant)) break;
                this.fieldsWritten.add(f);
                break;
            }
            case 180: {
                int next = this.codeBytes[this.PC + 3] & 0xFF;
                if (!this.thisOnTopOfStack || next == 198 || next == 199) break;
                FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
                this.fieldsRead.add(f);
            }
        }
        this.thisOnTopOfStack = false;
        this.doubleThisOnTopOfStack = false;
    }

    public void report() {
        int noLocked = 0;
        int noUnlocked = 0;
        int isPublic = 0;
        int couldBeFinal = 0;
        int noLocalLocks = 0;
        int volatileOrFinalCount = 0;
        int mostlyUnlocked = 0;
        for (Map.Entry<FieldAnnotation, int[]> e : this.stats.entrySet()) {
            int j;
            int freq;
            FieldAnnotation f = e.getKey();
            int[] theseStats = e.getValue();
            int locked = theseStats[0] + theseStats[1];
            int biasedLocked = theseStats[0] + 2 * theseStats[1];
            int unlocked = theseStats[2] + theseStats[3];
            int biasedUnlocked = theseStats[2] + 2 * theseStats[3];
            int writes = theseStats[1] + theseStats[3];
            if (locked == 0) {
                ++noLocked;
                continue;
            }
            if (unlocked == 0) {
                ++noUnlocked;
                continue;
            }
            if (theseStats[2] > 0 && 2 * biasedUnlocked > biasedLocked) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("Mostly unlocked for ").append(f).append(":").toString());
                }
                freq = 100 * locked / (locked + unlocked);
                if (DEBUG) {
                    System.out.print(new StringBuffer().append(freq).append("\t").toString());
                    for (j = 0; j < 4; ++j) {
                        System.out.print(new StringBuffer().append(theseStats[j]).append("\t").toString());
                    }
                    System.out.println(f);
                }
                ++mostlyUnlocked;
                continue;
            }
            if (this.publicFields.contains(f)) {
                ++isPublic;
                continue;
            }
            if (this.volatileOrFinalFields.contains(f)) {
                ++volatileOrFinalCount;
                continue;
            }
            if (!this.writtenOutsideOfConstructor.contains(f)) {
                ++couldBeFinal;
                continue;
            }
            if (!this.localLocks.contains(f)) {
                if (DEBUG) {
                    System.out.println(new StringBuffer().append("No local locks of ").append(f).toString());
                }
                ++noLocalLocks;
                continue;
            }
            freq = 100 * locked / (locked + unlocked);
            this.bugReporter.reportBug(new BugInstance("IS_INCONSISTENT_SYNC", 2).addClass(f.getClassName()).addField(f).addInt(freq).describe("INT_SYNC_PERCENT"));
            if (!DEBUG) continue;
            System.out.print(new StringBuffer().append(freq).append("\t").toString());
            for (j = 0; j < 4; ++j) {
                System.out.print(new StringBuffer().append(theseStats[j]).append("\t").toString());
            }
            System.out.println(f);
        }
        if (DEBUG) {
            int total = this.stats.size();
            System.out.println(new StringBuffer().append("        Total fields: ").append(total).toString());
            System.out.println(new StringBuffer().append("  No locked accesses: ").append(noLocked).toString());
            System.out.println(new StringBuffer().append("No unlocked accesses: ").append(noUnlocked).toString());
            System.out.println(new StringBuffer().append("     Mostly unlocked: ").append(mostlyUnlocked).toString());
            System.out.println(new StringBuffer().append("       public fields: ").append(isPublic).toString());
            if (couldBeFinal > 0) {
                System.out.println(new StringBuffer().append("      could be Final: ").append(couldBeFinal).toString());
            }
            System.out.println(new StringBuffer().append("   volatile or final: ").append(volatileOrFinalCount).toString());
            System.out.println(new StringBuffer().append("      no local locks: ").append(noLocalLocks).toString());
            System.out.println(new StringBuffer().append(" questionable fields: ").append(total - noLocked - noUnlocked - isPublic - volatileOrFinalCount - couldBeFinal - noLocalLocks - mostlyUnlocked).toString());
        }
    }
}

