/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LocationScanner;
import edu.umd.cs.findbugs.ba.LockCount;
import edu.umd.cs.findbugs.ba.LockCountDataflow;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;

public class FindTwoLockWait
implements Detector {
    private BugReporter bugReporter;
    private JavaClass javaClass;

    public FindTwoLockWait(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        this.javaClass = classContext.getJavaClass();
        try {
            Method[] methodList = this.javaClass.getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                Method method = methodList[i];
                final MethodGen methodGen = classContext.getMethodGen(method);
                if (methodGen == null || !this.preScreen(methodGen)) continue;
                CFG cfg = classContext.getCFG(method);
                final LockCountDataflow dataflow = classContext.getAnyLockCountDataflow(method);
                new LocationScanner(cfg).scan(new LocationScanner.Callback(){

                    public void visitLocation(Location location) {
                        FindTwoLockWait.this.visitInstruction(location.getHandle(), location.getBasicBlock(), methodGen, dataflow);
                    }
                });
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException("FindTwoLockWait caught exception: " + e.toString(), (Throwable)e);
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("FindTwoLockWait caught exception: " + e.toString(), (Throwable)e);
        }
    }

    public boolean preScreen(MethodGen mg) {
        ConstantPoolGen cpg = mg.getConstantPool();
        int lockCount = mg.isSynchronized() ? 1 : 0;
        boolean sawWait = false;
        for (InstructionHandle handle = mg.getInstructionList().getStart(); !(handle == null || lockCount >= 2 && sawWait); handle = handle.getNext()) {
            INVOKEVIRTUAL inv;
            Instruction ins = handle.getInstruction();
            if (ins instanceof MONITORENTER) {
                ++lockCount;
                continue;
            }
            if (!(ins instanceof INVOKEVIRTUAL) || !(inv = (INVOKEVIRTUAL)ins).getMethodName(cpg).equals("wait")) continue;
            sawWait = true;
        }
        return lockCount >= 2 && sawWait;
    }

    public void visitInstruction(InstructionHandle handle, BasicBlock bb, MethodGen methodGen, LockCountDataflow dataflow) {
        try {
            LockCount count;
            ConstantPoolGen cpg = methodGen.getConstantPool();
            if (this.isWait(handle, cpg) && (count = dataflow.getFactAtLocation(new Location(handle, bb))).getCount() > 1) {
                String sourceFile = this.javaClass.getSourceFileName();
                this.bugReporter.reportBug(new BugInstance("2LW_TWO_LOCK_WAIT", 2).addClass(this.javaClass).addMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle));
            }
        }
        catch (DataflowAnalysisException e) {
            throw new AnalysisException(e.getMessage());
        }
    }

    private boolean isWait(InstructionHandle handle, ConstantPoolGen cpg) {
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof INVOKEVIRTUAL)) {
            return false;
        }
        INVOKEVIRTUAL inv = (INVOKEVIRTUAL)ins;
        String methodName = inv.getMethodName(cpg);
        String methodSig = inv.getSignature(cpg);
        return methodName.equals("wait") && (methodSig.equals("()V") || methodSig.equals("(J)V") || methodSig.equals("(JI)V"));
    }

    public void report() {
    }
}

