/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class MutableLock
extends BytecodeScanningDetector
implements Constants2 {
    HashSet<String> setFields = new HashSet();
    boolean thisOnTOS = false;
    private BugReporter bugReporter;

    public MutableLock(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.setFields.clear();
        this.thisOnTOS = false;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 42: {
                this.thisOnTOS = true;
                return;
            }
            case 195: {
                this.setFields.clear();
                break;
            }
            case 181: {
                if (this.classConstant != this.className) break;
                this.setFields.add(this.nameConstant);
                break;
            }
            case 180: {
                if (!this.thisOnTOS || this.classConstant != this.className || !this.setFields.contains(this.nameConstant) || this.asUnsignedByte(this.codeBytes[this.PC + 3]) != 89 || this.asUnsignedByte(this.codeBytes[this.PC + 5]) != 194) break;
                this.bugReporter.reportBug(new BugInstance("ML_SYNC_ON_UPDATED_FIELD", 2).addClassAndMethod((BetterVisitor)this).addReferencedField((DismantleBytecode)this).addSourceLine((BetterVisitor)this, this.PC + 5));
                break;
            }
        }
        this.thisOnTOS = false;
    }
}

