/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.BetterVisitor;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantValue;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class UnreadFields
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("unreadfields.debug");
    Set<FieldAnnotation> declaredFields = new TreeSet<FieldAnnotation>();
    Set<FieldAnnotation> myFields = new TreeSet<FieldAnnotation>();
    HashSet<FieldAnnotation> writtenFields = new HashSet();
    HashSet<FieldAnnotation> readFields = new HashSet();
    HashSet<FieldAnnotation> constantFields = new HashSet();
    HashSet<String> needsOuterObjectInConstructor = new HashSet();
    HashSet<String> superReadFields = new HashSet();
    HashSet<String> superWrittenFields = new HashSet();
    HashSet<String> innerClassCannotBeStatic = new HashSet();
    boolean hasNativeMethods;
    private BugReporter bugReporter;
    static final int doNotConsider = 13;
    int count_aload_1;

    public UnreadFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.hasNativeMethods = false;
        if (this.superclassName.indexOf("$") >= 0 || this.superclassName.indexOf("+") >= 0) {
            this.innerClassCannotBeStatic.add(this.betterClassName);
            this.innerClassCannotBeStatic.add(this.betterSuperclassName);
        }
        super.visit(obj);
    }

    public void visitAfter(JavaClass obj) {
        if (!this.hasNativeMethods) {
            this.declaredFields.addAll(this.myFields);
        }
        this.myFields.clear();
    }

    public void visit(Field obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0xD) == 0 && !this.fieldName.equals("serialVersionUID")) {
            FieldAnnotation f = FieldAnnotation.fromVisitedField((BetterVisitor)this);
            this.myFields.add(f);
        }
    }

    public void visit(ConstantValue obj) {
        FieldAnnotation f = FieldAnnotation.fromVisitedField((BetterVisitor)this);
        this.constantFields.add(f);
    }

    public void visit(Code obj) {
        this.count_aload_1 = 0;
        super.visit(obj);
        if (this.methodName.equals("<init>") && this.count_aload_1 > 1 && (this.className.indexOf(36) >= 0 || this.className.indexOf(43) >= 0)) {
            this.needsOuterObjectInConstructor.add(this.betterClassName);
        }
    }

    public void visit(Method obj) {
        super.visit(obj);
        int flags = obj.getAccessFlags();
        if ((flags & 0x100) != 0) {
            this.hasNativeMethods = true;
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 43) {
            ++this.count_aload_1;
        } else if (seen == 180) {
            FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            if (DEBUG) {
                System.out.println("get: " + f);
            }
            this.readFields.add(f);
            if (this.classConstant.equals(this.className) && !this.myFields.contains(f)) {
                this.superReadFields.add(this.nameConstant);
            }
        } else if (seen == 181) {
            FieldAnnotation f = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
            if (DEBUG) {
                System.out.println("put: " + f);
            }
            this.writtenFields.add(f);
            if (this.classConstant.equals(this.className) && !this.myFields.contains(f)) {
                this.superWrittenFields.add(this.nameConstant);
            }
        }
    }

    public void report() {
        String className;
        String fieldName;
        FieldAnnotation f;
        TreeSet<FieldAnnotation> readOnlyFields = new TreeSet<FieldAnnotation>(this.declaredFields);
        readOnlyFields.removeAll(this.writtenFields);
        readOnlyFields.retainAll(this.readFields);
        Set<FieldAnnotation> writeOnlyFields = this.declaredFields;
        writeOnlyFields.removeAll(this.readFields);
        Iterator<FieldAnnotation> i = readOnlyFields.iterator();
        while (i.hasNext()) {
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            this.bugReporter.reportBug(new BugInstance("UWF_UNWRITTEN_FIELD", 2).addClass(className).addField(f));
        }
        i = writeOnlyFields.iterator();
        while (i.hasNext()) {
            boolean easyChange;
            f = i.next();
            fieldName = f.getFieldName();
            className = f.getClassName();
            int lastDollar = Math.max(className.lastIndexOf(36), className.lastIndexOf(43));
            boolean isAnonymousInnerClass = lastDollar > 0 && lastDollar < className.length() - 1 && Character.isDigit(className.charAt(className.length() - 1));
            boolean allUpperCase = fieldName.equals(fieldName.toUpperCase());
            if (this.superReadFields.contains(f.getFieldName())) continue;
            if (!fieldName.startsWith("this$") && !fieldName.startsWith("this+")) {
                if (this.constantFields.contains(f)) {
                    this.bugReporter.reportBug(new BugInstance("SS_SHOULD_BE_STATIC", 2).addClass(className).addField(f));
                    continue;
                }
                if (!this.writtenFields.contains(f) && !this.superWrittenFields.contains(f.getFieldName())) {
                    this.bugReporter.reportBug(new BugInstance("UUF_UNUSED_FIELD", 2).addClass(className).addField(f));
                    continue;
                }
                this.bugReporter.reportBug(new BugInstance("URF_UNREAD_FIELD", 2).addClass(className).addField(f));
                continue;
            }
            if (this.innerClassCannotBeStatic.contains(className)) continue;
            boolean bl = easyChange = !this.needsOuterObjectInConstructor.contains(className);
            if (!easyChange && isAnonymousInnerClass) continue;
            int priority = 3;
            if (easyChange && !isAnonymousInnerClass) {
                priority = 2;
            }
            this.bugReporter.reportBug(new BugInstance("SIC_INNER_SHOULD_BE_STATIC", priority).addClass(className));
        }
    }
}

