/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.Token;
import edu.umd.cs.findbugs.Tokenizer;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.SourceFile;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Utility;
import org.apache.bcel.classfile.Visitor;

public class DroppedException
extends PreorderVisitor
implements Detector,
Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("de.debug");
    private static final boolean LOOK_IN_SOURCE_TO_FIND_COMMENTED_CATCH_BLOCKS = Boolean.getBoolean("de.comment");
    Set<String> reported = new HashSet<String>();
    Set<String> causes = new HashSet<String>();
    Set<String> checkedCauses = new HashSet<String>();
    private BugReporter bugReporter;
    private static final int START = 0;
    private static final int CATCH = 1;
    private static final int OPEN_PAREN = 2;
    private static final int CLOSE_PAREN = 3;
    private static final int OPEN_BRACE = 4;
    private static final int NUM_CONTEXT_LINES = 3;
    private static final int MAX_LINES = 7;

    public DroppedException(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        if (DEBUG) {
            System.out.println("Dropped Exception debugging turned on");
        }
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    public void report() {
    }

    boolean isChecked(String c) {
        if (!this.causes.add(c)) {
            return this.checkedCauses.contains(c);
        }
        try {
            if (Hierarchy.isSubtype((String)c, (String)"java.lang.Exception") && !Hierarchy.isSubtype((String)c, (String)"java.lang.RuntimeException")) {
                this.checkedCauses.add(c);
            }
            return true;
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
            return false;
        }
    }

    private int getUnsignedShort(byte[] a, int i) {
        return this.asUnsignedByte(a[i]) << 8 | this.asUnsignedByte(a[i + 1]);
    }

    public void visit(Code obj) {
        CodeException[] exp = obj.getExceptionTable();
        LineNumberTable lineNumbers = obj.getLineNumberTable();
        if (exp == null) {
            return;
        }
        byte[] code = obj.getCode();
        for (int i = 0; i < exp.length; ++i) {
            String key;
            SourceLineAnnotation srcLine;
            boolean startsWithASTORE03;
            String c;
            int opcode;
            int handled = exp[i].getHandlerPC();
            int start = exp[i].getStartPC();
            int end = exp[i].getEndPC();
            int cause = exp[i].getCatchType();
            boolean exitInTryBlock = false;
            if (DEBUG) {
                System.out.println("start = " + start + ", end = " + end + ", handled = " + handled);
            }
            for (int j = start; j <= end; j += 1 + NO_OF_OPERANDS[opcode]) {
                opcode = this.asUnsignedByte(code[j]);
                if (opcode >= 172 && opcode <= 177 || opcode >= 153 && opcode <= 167 && (opcode != 167 || j < end)) {
                    exitInTryBlock = true;
                    if (!DEBUG) break;
                    System.out.println("\texit: " + opcode + " in " + this.getFullyQualifiedMethodName());
                    break;
                }
                if (NO_OF_OPERANDS[opcode] >= 0) continue;
                exitInTryBlock = true;
                break;
            }
            if (exitInTryBlock) {
                if (!DEBUG) continue;
                System.out.println("Exit in try block");
                continue;
            }
            if (handled < 5) continue;
            if (cause == 0) {
                c = "Throwable";
            } else {
                c = Utility.compactClassName((String)this.getConstantPool().getConstantString(cause, (byte)7), (boolean)false);
                if (!this.isChecked(c)) continue;
            }
            int jumpAtEnd = 0;
            if (this.asUnsignedByte(code[end]) == 167 && (jumpAtEnd = this.getUnsignedShort(code, end + 1)) < handled) {
                jumpAtEnd = 0;
            }
            int opcode2 = this.asUnsignedByte(code[handled]);
            int afterHandler = 0;
            if (DEBUG) {
                System.out.println("DE:\topcode is " + opcode2 + ", " + this.asUnsignedByte(code[handled + 1]));
            }
            boolean drops = false;
            boolean bl = startsWithASTORE03 = opcode2 >= 75 && opcode2 <= 78;
            if (startsWithASTORE03 && this.asUnsignedByte(code[handled + 1]) == 177) {
                if (DEBUG) {
                    System.out.println("Drop 1");
                }
                drops = true;
                afterHandler = handled + 1;
            }
            if (handled + 2 < code.length && opcode2 == 58 && this.asUnsignedByte(code[handled + 2]) == 177) {
                drops = true;
                afterHandler = handled + 2;
                if (DEBUG) {
                    System.out.println("Drop 2");
                }
            }
            if (handled + 3 < code.length && !exitInTryBlock) {
                int offsetAfter;
                int offsetBefore;
                if (DEBUG) {
                    System.out.println("DE: checking for jumps");
                }
                if (startsWithASTORE03 && this.asUnsignedByte(code[handled - 3]) == 167) {
                    offsetBefore = this.getUnsignedShort(code, handled - 2);
                    if (DEBUG) {
                        System.out.println("offset before = " + offsetBefore);
                    }
                    if (offsetBefore == 4) {
                        drops = true;
                        afterHandler = handled + 1;
                        if (DEBUG) {
                            System.out.println("Drop 3");
                        }
                    }
                }
                if (opcode2 == 58 && this.asUnsignedByte(code[handled - 3]) == 167 && (offsetBefore = this.getUnsignedShort(code, handled - 2)) == 5) {
                    drops = true;
                    afterHandler = handled + 2;
                    if (DEBUG) {
                        System.out.println("Drop 4");
                    }
                }
                if (startsWithASTORE03 && this.asUnsignedByte(code[handled + 1]) == 167 && this.asUnsignedByte(code[handled - 3]) == 167) {
                    offsetBefore = this.getUnsignedShort(code, handled - 2);
                    offsetAfter = this.getUnsignedShort(code, handled + 2);
                    if (offsetAfter > 0 && offsetAfter + 4 == offsetBefore) {
                        drops = true;
                        afterHandler = handled + 4;
                        if (DEBUG) {
                            System.out.println("Drop 5");
                        }
                    }
                }
                if (opcode2 == 58 && this.asUnsignedByte(code[handled + 2]) == 167 && this.asUnsignedByte(code[handled - 3]) == 167) {
                    offsetBefore = this.getUnsignedShort(code, handled - 2);
                    offsetAfter = this.getUnsignedShort(code, handled + 3);
                    if (offsetAfter > 0 && offsetAfter + 5 == offsetBefore) {
                        drops = true;
                        afterHandler = handled + 5;
                        if (DEBUG) {
                            System.out.println("Drop 6");
                        }
                    }
                }
            }
            boolean multiLineHandler = false;
            if (DEBUG) {
                System.out.println("afterHandler = " + afterHandler + ", handled = " + handled);
            }
            if (afterHandler > handled && lineNumbers != null) {
                int startHandlerLinenumber = lineNumbers.getSourceLine(handled);
                int endHandlerLinenumber = this.getNextExecutableLineNumber(lineNumbers, afterHandler) - 1;
                if (DEBUG) {
                    System.out.println("Handler in lines " + startHandlerLinenumber + "-" + endHandlerLinenumber);
                }
                if (endHandlerLinenumber > startHandlerLinenumber) {
                    multiLineHandler = true;
                    if (DEBUG) {
                        System.out.println("Multiline handler");
                    }
                }
            }
            if (end - start < 5 || !drops || c.equals("java.lang.InterruptedException") || c.equals("java.lang.CloneNotSupportedException")) continue;
            int priority = 2;
            if (exitInTryBlock) {
                ++priority;
            }
            if ((srcLine = SourceLineAnnotation.fromVisitedInstruction((PreorderVisitor)this, (int)handled)) != null && LOOK_IN_SOURCE_TO_FIND_COMMENTED_CATCH_BLOCKS) {
                if (this.catchBlockHasComment(srcLine)) {
                    return;
                }
                ++priority;
            } else if (lineNumbers == null || multiLineHandler) {
                priority += 2;
            }
            if (c.equals("java.lang.Error") || c.equals("java.lang.Exception") || c.equals("java.lang.Throwable") || c.equals("java.lang.RuntimeException")) {
                --priority;
                if (end - start > 30) {
                    --priority;
                }
            }
            if (DEBUG) {
                System.out.println("Priority is " + priority);
            }
            if (priority > 3) {
                return;
            }
            if (priority < 1) {
                priority = 1;
            }
            if (DEBUG) {
                System.out.println("reporting warning");
            }
            if (!this.reported.add(key = (exitInTryBlock ? "mightDrop," : "mightIgnore,") + this.getFullyQualifiedMethodName() + "," + c)) continue;
            BugInstance bugInstance = new BugInstance(exitInTryBlock ? "DE_MIGHT_DROP" : "DE_MIGHT_IGNORE", priority).addClassAndMethod((PreorderVisitor)this);
            bugInstance.addSourceLine(srcLine);
            bugInstance.addClass(c).describe("CLASS_EXCEPTION");
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private int getNextExecutableLineNumber(LineNumberTable linenumbers, int PC) {
        int i;
        LineNumber[] entries = linenumbers.getLineNumberTable();
        int beforePC = 0;
        for (i = 0; i < entries.length && entries[i].getStartPC() < PC; ++i) {
            int line = entries[i].getLineNumber();
            if (line <= beforePC) continue;
            beforePC = line;
        }
        int secondChoice = entries[i].getLineNumber();
        while (i < entries.length) {
            int line = entries[i].getLineNumber();
            if (line > beforePC) {
                return line;
            }
            ++i;
        }
        return secondChoice;
    }

    private boolean catchBlockHasComment(SourceLineAnnotation srcLine) {
        block27: {
            if (!LOOK_IN_SOURCE_TO_FIND_COMMENTED_CATCH_BLOCKS) {
                return false;
            }
            AnalysisContext analysisContext = AnalysisContext.instance();
            SourceFinder sourceFinder = analysisContext.getSourceFinder();
            try {
                Token token;
                int kind;
                int offset;
                SourceFile sourceFile = sourceFinder.findSourceFile(srcLine.getPackageName(), srcLine.getSourceFile());
                int startLine = srcLine.getStartLine();
                int scanStartLine = startLine - 3;
                if (scanStartLine < 1) {
                    scanStartLine = 1;
                }
                if ((offset = sourceFile.getLineOffset(scanStartLine - 1)) < 0) {
                    return false;
                }
                Tokenizer tokenizer = new Tokenizer((Reader)new InputStreamReader(sourceFile.getInputStreamFromOffset(offset)));
                ArrayList<Token> tokenList = new ArrayList<Token>(40);
                int eolOfCatchBlockStart = -1;
                int line = scanStartLine;
                while (line < scanStartLine + 7 && (kind = (token = tokenizer.next()).getKind()) != -1) {
                    if (kind == -2) {
                        if (line == startLine) {
                            eolOfCatchBlockStart = tokenList.size();
                        }
                        ++line;
                    }
                    tokenList.add(token);
                }
                if (eolOfCatchBlockStart < 0) {
                    return false;
                }
                ListIterator iter = tokenList.listIterator(eolOfCatchBlockStart);
                boolean foundCatch = false;
                while (iter.hasPrevious()) {
                    Token token2 = (Token)iter.previous();
                    if (token2.getKind() != 0 || !token2.getLexeme().equals("catch")) continue;
                    foundCatch = true;
                    break;
                }
                if (!foundCatch) {
                    return false;
                }
                boolean done = false;
                int numLines = 0;
                int state = 0;
                int level = 0;
                while (iter.hasNext()) {
                    Token token3 = (Token)iter.next();
                    int type = token3.getKind();
                    String value = token3.getLexeme();
                    block1 : switch (type) {
                        case -2: {
                            if (DEBUG) {
                                System.out.println("Saw token: [EOL]");
                            }
                            if (++numLines < 7) break;
                            done = true;
                            break;
                        }
                        default: {
                            if (DEBUG) {
                                System.out.println("Got token: " + value);
                            }
                            switch (state) {
                                case 0: {
                                    if (!value.equals("catch")) break block1;
                                    state = 1;
                                    break block1;
                                }
                                case 1: {
                                    if (!value.equals("(")) break block1;
                                    state = 2;
                                    break block1;
                                }
                                case 2: {
                                    if (value.equals(")")) {
                                        if (level == 0) {
                                            state = 3;
                                            break block1;
                                        }
                                        --level;
                                        break block1;
                                    }
                                    if (!value.equals("(")) break block1;
                                    ++level;
                                    break block1;
                                }
                                case 3: {
                                    if (!value.equals("{")) break block1;
                                    state = 4;
                                    break block1;
                                }
                                case 4: {
                                    boolean closeBrace = value.equals("}");
                                    if (DEBUG && !closeBrace) {
                                        System.out.println("Found a comment in catch block: " + value);
                                    }
                                    return !closeBrace;
                                }
                            }
                        }
                    }
                    if (!done) continue;
                    break;
                }
            }
            catch (IOException e) {
                if (!DEBUG) break block27;
                e.printStackTrace();
            }
        }
        return false;
    }
}

