/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.detect.MutableStaticFields;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindReturnRef
extends BytecodeScanningDetector
implements Constants2 {
    boolean check = false;
    boolean thisOnTOS = false;
    boolean fieldOnTOS = false;
    boolean publicClass = false;
    boolean staticMethod = false;
    boolean dangerousToStoreIntoField = false;
    String nameOnStack;
    String classNameOnStack;
    String sigOnStack;
    int parameterCount;
    int[] timesRead = new int[256];
    boolean fieldIsStatic;
    private BugReporter bugReporter;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FindReturnRef(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.publicClass = obj.isPublic();
        super.visit(obj);
    }

    public void visit(Method obj) {
        boolean bl = this.check = this.publicClass && (obj.getAccessFlags() & 1) != 0;
        if (!this.check) {
            return;
        }
        this.dangerousToStoreIntoField = false;
        this.staticMethod = (obj.getAccessFlags() & 8) != 0;
        this.parameterCount = obj.getArgumentTypes().length;
        if (!this.staticMethod) {
            ++this.parameterCount;
        }
        for (int i = 0; i < this.parameterCount; ++i) {
            this.timesRead[i] = 0;
        }
        this.thisOnTOS = false;
        this.fieldOnTOS = false;
        super.visit(obj);
        this.thisOnTOS = false;
        this.fieldOnTOS = false;
    }

    public void visit(Code obj) {
        if (this.check) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        int reg;
        block24: {
            if (!$assertionsDisabled && !this.check) {
                throw new AssertionError();
            }
            if (this.staticMethod && this.dangerousToStoreIntoField && seen == 179 && MutableStaticFields.mutableSignature(this.getSigConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance("EI_EXPOSE_REP2", 1).addClassAndMethod((PreorderVisitor)this).addField(this.getClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand(), true).addSourceLine((DismantleBytecode)this));
            }
            if (!this.staticMethod && this.dangerousToStoreIntoField && seen == 181 && MutableStaticFields.mutableSignature(this.getSigConstantOperand())) {
                this.bugReporter.reportBug(new BugInstance("EI_EXPOSE_REP2", 2).addClassAndMethod((PreorderVisitor)this).addField(this.getClassConstantOperand(), this.getNameConstantOperand(), this.getSigConstantOperand(), true).addSourceLine((DismantleBytecode)this));
            }
            this.dangerousToStoreIntoField = false;
            reg = -1;
            switch (seen) {
                case 42: {
                    reg = 0;
                    break;
                }
                case 43: {
                    reg = 1;
                    break;
                }
                case 44: {
                    reg = 2;
                    break;
                }
                case 45: {
                    reg = 3;
                    break;
                }
                case 25: {
                    reg = this.getRegisterOperand();
                    break;
                }
                default: {
                    break block24;
                }
            }
            if (reg < this.parameterCount) {
                int n = reg;
                this.timesRead[n] = this.timesRead[n] + 1;
            }
        }
        if (this.thisOnTOS && !this.staticMethod) {
            switch (seen) {
                case 25: 
                case 43: 
                case 44: 
                case 45: {
                    if (reg >= this.parameterCount) break;
                    this.dangerousToStoreIntoField = true;
                }
            }
        } else if (this.staticMethod) {
            switch (seen) {
                case 25: 
                case 42: 
                case 43: 
                case 44: 
                case 45: {
                    if (reg >= this.parameterCount) break;
                    this.dangerousToStoreIntoField = true;
                }
            }
        }
        if (seen == 42 && !this.staticMethod) {
            this.thisOnTOS = true;
            this.fieldOnTOS = false;
            return;
        }
        if (this.thisOnTOS && seen == 180 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.getNameConstantOperand();
            this.classNameOnStack = this.getDottedClassConstantOperand();
            this.sigOnStack = this.getSigConstantOperand();
            this.fieldIsStatic = false;
            return;
        }
        if (seen == 178 && this.getClassConstantOperand().equals(this.getClassName())) {
            this.fieldOnTOS = true;
            this.thisOnTOS = false;
            this.nameOnStack = this.getNameConstantOperand();
            this.classNameOnStack = this.getDottedClassConstantOperand();
            this.sigOnStack = this.getSigConstantOperand();
            this.fieldIsStatic = true;
            return;
        }
        this.thisOnTOS = false;
        if (this.check && this.fieldOnTOS && seen == 176 && this.nameOnStack.indexOf("EMPTY") == -1 && MutableStaticFields.mutableSignature(this.sigOnStack)) {
            this.bugReporter.reportBug(new BugInstance(this.staticMethod ? "MS_EXPOSE_REP" : "EI_EXPOSE_REP", 2).addClassAndMethod((PreorderVisitor)this).addField(this.classNameOnStack, this.nameOnStack, this.sigOnStack, this.fieldIsStatic).addSourceLine((DismantleBytecode)this));
        }
        this.fieldOnTOS = false;
        this.thisOnTOS = false;
    }

    static {
        $assertionsDisabled = !FindReturnRef.class.desiredAssertionStatus();
    }
}

