/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.ba.ResourceValueFrameModelingVisitor;
import edu.umd.cs.findbugs.detect.FindOpenStream;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEscape;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamFrameModelingVisitor;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamResourceTracker
implements ResourceTracker<Stream> {
    private StreamFactory[] streamFactoryList;
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private Map<Location, Stream> locationToResourceMap;
    private BitSet streamConstructionSet;
    private BitSet uninterestingStreamEscapeSet;
    private TreeSet<StreamEscape> streamEscapeSet;

    public StreamResourceTracker(StreamFactory[] streamFactoryList, RepositoryLookupFailureCallback lookupFailureCallback) {
        this.streamFactoryList = streamFactoryList;
        this.lookupFailureCallback = lookupFailureCallback;
        this.streamConstructionSet = new BitSet();
        this.uninterestingStreamEscapeSet = new BitSet();
        this.streamEscapeSet = new TreeSet();
    }

    public void setLocationToStreamMap(Map<Location, Stream> locationToResourceMap) {
        this.locationToResourceMap = locationToResourceMap;
    }

    public void addStreamEscape(InstructionHandle source, InstructionHandle target) {
        StreamEscape streamEscape = new StreamEscape(source, target);
        this.streamEscapeSet.add(streamEscape);
        if (FindOpenStream.DEBUG) {
            System.out.println(new StringBuffer().append("Adding potential stream escape ").append(streamEscape).toString());
        }
    }

    public void markTransitiveUninterestingStreamEscapes() {
        Iterator<StreamEscape> i = this.streamEscapeSet.iterator();
        while (i.hasNext()) {
            StreamEscape streamEscape = i.next();
            if (this.isStreamConstruction(streamEscape.target)) continue;
            if (FindOpenStream.DEBUG) {
                System.out.println(new StringBuffer().append("Eliminating false stream escape ").append(streamEscape).toString());
            }
            i.remove();
        }
        BitSet orig = new BitSet();
        do {
            orig.clear();
            orig.or(this.uninterestingStreamEscapeSet);
            for (StreamEscape streamEscape : this.streamEscapeSet) {
                if (!this.isUninterestingStreamEscape(streamEscape.source)) continue;
                if (FindOpenStream.DEBUG) {
                    System.out.println(new StringBuffer().append("Propagating stream escape ").append(streamEscape).toString());
                }
                this.uninterestingStreamEscapeSet.set(streamEscape.target.getPosition());
            }
        } while (!orig.equals(this.uninterestingStreamEscapeSet));
    }

    public boolean isUninterestingStreamEscape(InstructionHandle handle) {
        return this.uninterestingStreamEscapeSet.get(handle.getPosition());
    }

    public void addStreamConstruction(InstructionHandle streamConstruction, boolean isUninteresting) {
        if (FindOpenStream.DEBUG) {
            System.out.println(new StringBuffer().append("Stream construction at ").append(streamConstruction.getPosition()).toString());
        }
        this.streamConstructionSet.set(streamConstruction.getPosition());
        if (isUninteresting) {
            this.uninterestingStreamEscapeSet.set(streamConstruction.getPosition());
        }
    }

    private boolean isStreamConstruction(InstructionHandle handle) {
        return this.streamConstructionSet.get(handle.getPosition());
    }

    public Stream isResourceCreation(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg) {
        if (this.locationToResourceMap != null) {
            return this.locationToResourceMap.get(new Location(handle, basicBlock));
        }
        Instruction ins = handle.getInstruction();
        if (!(ins instanceof TypedInstruction)) {
            return null;
        }
        Type type = ((TypedInstruction)ins).getType(cpg);
        if (!(type instanceof ObjectType)) {
            return null;
        }
        Location location = new Location(handle, basicBlock);
        for (int i = 0; i < this.streamFactoryList.length; ++i) {
            Stream stream = this.streamFactoryList[i].createStream(location, (ObjectType)type, cpg, this.lookupFailureCallback);
            if (stream == null) continue;
            return stream;
        }
        return null;
    }

    public boolean isResourceOpen(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamOpen(basicBlock, handle, cpg, frame);
    }

    public boolean isResourceClose(BasicBlock basicBlock, InstructionHandle handle, ConstantPoolGen cpg, Stream resource, ResourceValueFrame frame) {
        return resource.isStreamClose(basicBlock, handle, cpg, frame, this.lookupFailureCallback);
    }

    public ResourceValueFrameModelingVisitor createVisitor(Stream resource, ConstantPoolGen cpg) {
        return new StreamFrameModelingVisitor(cpg, this, resource);
    }

    public boolean ignoreImplicitExceptions(Stream resource) {
        return resource.ignoreImplicitExceptions();
    }

    public /* synthetic */ boolean ignoreImplicitExceptions(Object x0) {
        return this.ignoreImplicitExceptions((Stream)((Object)x0));
    }

    public /* synthetic */ ResourceValueFrameModelingVisitor createVisitor(Object x0, ConstantPoolGen x1) {
        return this.createVisitor((Stream)((Object)x0), x1);
    }

    public /* synthetic */ boolean isResourceClose(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2, Object x3, ResourceValueFrame x4) throws DataflowAnalysisException {
        return this.isResourceClose(x0, x1, x2, (Stream)((Object)x3), x4);
    }

    public /* synthetic */ Object isResourceCreation(BasicBlock x0, InstructionHandle x1, ConstantPoolGen x2) throws DataflowAnalysisException {
        return this.isResourceCreation(x0, x1, x2);
    }
}

