/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.LoadInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.StoreInstruction;

public class FindLocalSelfAssignment
implements Detector {
    private BugReporter bugReporter;
    private AnalysisContext analysisContext;

    public FindLocalSelfAssignment(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void setAnalysisContext(AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
    }

    public void visitClassContext(ClassContext classContext) {
        try {
            JavaClass javaClass = classContext.getJavaClass();
            Method[] methodList = javaClass.getMethods();
            for (int i = 0; i < methodList.length; ++i) {
                Method method = methodList[i];
                if (classContext.getMethodGen(method) == null) continue;
                CFG cfg = classContext.getCFG(method);
                Iterator j = cfg.blockIterator();
                while (j.hasNext()) {
                    BasicBlock basicBlock = (BasicBlock)j.next();
                    this.analyzeBasicBlock(classContext, method, basicBlock);
                }
            }
        }
        catch (CFGBuilderException e) {
            throw new AnalysisException("FindLocalSelfAssignment caught exception: " + (Object)((Object)e), (Throwable)e);
        }
    }

    private void analyzeBasicBlock(ClassContext classContext, Method method, BasicBlock basicBlock) {
        int lastLoaded = -1;
        BasicBlock.InstructionIterator i = basicBlock.instructionIterator();
        while (i.hasNext()) {
            InstructionHandle handle = (InstructionHandle)i.next();
            Instruction ins = handle.getInstruction();
            int loaded = -1;
            int stored = -1;
            if (ins instanceof LoadInstruction) {
                LoadInstruction load = (LoadInstruction)ins;
                loaded = load.getIndex();
            } else if (ins instanceof StoreInstruction) {
                StoreInstruction store = (StoreInstruction)ins;
                stored = store.getIndex();
            }
            if (stored >= 0 && stored == lastLoaded) {
                JavaClass javaClass = classContext.getJavaClass();
                MethodGen methodGen = classContext.getMethodGen(method);
                String sourceFile = javaClass.getSourceFileName();
                this.bugReporter.reportBug(new BugInstance("SA_LOCAL_SELF_ASSIGNMENT", 2).addClass(javaClass).addMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, handle));
            }
            lastLoaded = loaded >= 0 ? loaded : -1;
        }
    }

    public void report() {
    }
}

