/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;

public class FindMaskedFields
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    private int numParms;
    private Set<Field> maskedFields = new HashSet<Field>();
    private Map<String, Field> classFields = new HashMap<String, Field>();
    private boolean staticMethod;

    public FindMaskedFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        String fieldName;
        if (obj.isInterface()) {
            return;
        }
        this.classFields.clear();
        Field[] fields = obj.getFields();
        for (int f = 0; f < fields.length; ++f) {
            fieldName = fields[f].getName();
            this.classFields.put(fieldName, fields[f]);
        }
        try {
            JavaClass[] superClasses = Repository.getSuperClasses((JavaClass)obj);
            for (int c = 0; c < superClasses.length; ++c) {
                fields = superClasses[c].getFields();
                for (int f = 0; f < fields.length; ++f) {
                    Field fld = fields[f];
                    if (fld.isStatic() || this.maskedFields.contains(fld) || !fld.isPublic() && !fld.isProtected() || (fieldName = fld.getName()).length() == 1 || fieldName.equals("serialVersionUID") || !this.classFields.containsKey(fieldName)) continue;
                    this.maskedFields.add(fld);
                    Field maskingField = this.classFields.get(fieldName);
                    FieldAnnotation fa = new FieldAnnotation(this.getDottedClassName(), maskingField.getName(), maskingField.getSignature(), maskingField.isStatic());
                    int priority = 2;
                    if (maskingField.isStatic() || maskingField.isFinal()) {
                        ++priority;
                    } else if (fld.getSignature().charAt(0) == 'L' && !fld.getSignature().startsWith("Ljava/lang/") || fld.getSignature().charAt(0) == '[') {
                        --priority;
                    }
                    if (fld.getAccessFlags() != maskingField.getAccessFlags()) {
                        ++priority;
                    }
                    if (!fld.getSignature().equals(maskingField.getSignature())) {
                        ++priority;
                    }
                    FieldAnnotation maskedFieldAnnotation = FieldAnnotation.fromBCELField((String)superClasses[c].getClassName(), (Field)fld);
                    this.bugReporter.reportBug(new BugInstance("MF_CLASS_MASKS_FIELD", priority).addClass((PreorderVisitor)this).addField(maskedFieldAnnotation).describe("FIELD_MASKED").addField(fa).describe("FIELD_MASKING"));
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.numParms = obj.getArgumentTypes().length;
        if (!obj.isStatic()) {
            ++this.numParms;
        }
        this.staticMethod = obj.isStatic();
    }

    public void visit(LocalVariableTable obj) {
        super.visit(obj);
    }
}

