/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ResourceCollection;
import edu.umd.cs.findbugs.ResourceTrackingDetector;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ResourceTracker;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysis;
import edu.umd.cs.findbugs.ba.ResourceValueAnalysisTestDriver;
import edu.umd.cs.findbugs.ba.ResourceValueFrame;
import edu.umd.cs.findbugs.detect.IOStreamFactory;
import edu.umd.cs.findbugs.detect.InstanceFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.MethodReturnValueStreamFactory;
import edu.umd.cs.findbugs.detect.StaticFieldLoadStreamFactory;
import edu.umd.cs.findbugs.detect.Stream;
import edu.umd.cs.findbugs.detect.StreamEquivalenceClass;
import edu.umd.cs.findbugs.detect.StreamFactory;
import edu.umd.cs.findbugs.detect.StreamResourceTracker;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindOpenStream
extends ResourceTrackingDetector<Stream, StreamResourceTracker> {
    static final boolean DEBUG = Boolean.getBoolean("fos.debug");
    static final boolean IGNORE_WRAPPED_UNINTERESTING_STREAMS = !Boolean.getBoolean("fos.allowWUS");
    static final ObjectType[] streamBaseList = new ObjectType[]{new ObjectType("java.io.InputStream"), new ObjectType("java.io.OutputStream"), new ObjectType("java.io.Reader"), new ObjectType("java.io.Writer"), new ObjectType("java.sql.Connection"), new ObjectType("java.sql.Statement"), new ObjectType("java.sql.ResultSet")};
    static final StreamFactory[] streamFactoryList;
    private List<PotentialOpenStream> potentialOpenStreamList = new LinkedList<PotentialOpenStream>();
    static /* synthetic */ Class class$edu$umd$cs$findbugs$detect$FindOpenStream;

    public FindOpenStream(BugReporter bugReporter) {
        super(bugReporter);
    }

    public boolean prescreen(ClassContext classContext, Method method) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet.get(187) || bytecodeSet.get(185) || bytecodeSet.get(183) || bytecodeSet.get(184) || bytecodeSet.get(182);
    }

    public StreamResourceTracker getResourceTracker(ClassContext classContext, Method method) {
        return new StreamResourceTracker(streamFactoryList, (RepositoryLookupFailureCallback)this.bugReporter);
    }

    public static boolean isMainMethod(Method method) {
        return method.isStatic() && method.getName().equals("main") && method.getSignature().equals("([Ljava/lang/String;)V");
    }

    public void analyzeMethod(ClassContext classContext, Method method, StreamResourceTracker resourceTracker, ResourceCollection<Stream> resourceCollection) throws CFGBuilderException, DataflowAnalysisException {
        if (FindOpenStream.isMainMethod(method)) {
            return;
        }
        this.potentialOpenStreamList.clear();
        JavaClass javaClass = classContext.getJavaClass();
        MethodGen methodGen = classContext.getMethodGen(method);
        CFG cfg = classContext.getCFG(method);
        try {
            Type[] parameterTypeList = Type.getArgumentTypes((String)methodGen.getSignature());
            Location firstLocation = new Location(cfg.getEntry().getFirstInstruction(), cfg.getEntry());
            int local = methodGen.isStatic() ? 0 : 1;
            block5: for (int i = 0; i < parameterTypeList.length; ++i) {
                Type type = parameterTypeList[i];
                if (type instanceof ObjectType) {
                    ObjectType objectType = (ObjectType)type;
                    for (int j = 0; j < streamBaseList.length; ++j) {
                        ObjectType streamBase = streamBaseList[j];
                        if (!Hierarchy.isSubtype((ReferenceType)objectType, (ReferenceType)streamBase)) continue;
                        Stream paramStream = new Stream(firstLocation, objectType.getClassName(), streamBase.getClassName());
                        paramStream.setIsOpenOnCreation(true);
                        paramStream.setOpenLocation(firstLocation);
                        paramStream.setInstanceParam(local);
                        resourceCollection.addPreexistingResource((Object)paramStream);
                        break;
                    }
                }
                switch (type.getType()) {
                    case 7: 
                    case 11: {
                        local += 2;
                        continue block5;
                    }
                    default: {
                        ++local;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.bugReporter.reportMissingClass(e);
        }
        resourceTracker.setResourceCollection(resourceCollection);
        super.analyzeMethod(classContext, method, (ResourceTracker)resourceTracker, resourceCollection);
        resourceTracker.markTransitiveUninterestingStreamEscapes();
        Iterator<PotentialOpenStream> i = resourceCollection.resourceIterator();
        while (i.hasNext()) {
            Stream stream = (Stream)i.next();
            StreamEquivalenceClass equivalenceClass = resourceTracker.getStreamEquivalenceClass(stream);
            if (!stream.isClosed()) continue;
            equivalenceClass.setClosed();
        }
        for (PotentialOpenStream pos : this.potentialOpenStreamList) {
            Location openLocation;
            Stream stream = pos.stream;
            if (stream.isClosed() || stream.isUninteresting() || (openLocation = stream.getOpenLocation()) == null || IGNORE_WRAPPED_UNINTERESTING_STREAMS && resourceTracker.isUninterestingStreamEscape(stream)) continue;
            String sourceFile = javaClass.getSourceFileName();
            this.bugReporter.reportBug(new BugInstance(pos.bugType, pos.priority).addClassAndMethod(methodGen, sourceFile).addSourceLine(methodGen, sourceFile, stream.getLocation().getHandle()));
        }
    }

    public void inspectResult(JavaClass javaClass, MethodGen methodGen, CFG cfg, Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>> dataflow, Stream stream) {
        ResourceValueFrame exitFrame = (ResourceValueFrame)dataflow.getResultFact(cfg.getExit());
        int exitStatus = exitFrame.getStatus();
        if (exitStatus == 1 || exitStatus == 2) {
            String bugType = stream.getBugType();
            int priority = 2;
            if (exitStatus == 2) {
                bugType = new StringBuffer().append(bugType).append("_EXCEPTION_PATH").toString();
                priority = 3;
            }
            this.potentialOpenStreamList.add(new PotentialOpenStream(bugType, priority, stream));
        } else if (exitStatus == 3) {
            stream.setClosed();
        }
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 3) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$detect$FindOpenStream == null ? (class$edu$umd$cs$findbugs$detect$FindOpenStream = FindOpenStream.class$("edu.umd.cs.findbugs.detect.FindOpenStream")) : class$edu$umd$cs$findbugs$detect$FindOpenStream).getName()).append(" <class file> <method name> <bytecode offset>").toString());
            System.exit(1);
        }
        String classFile = argv[0];
        String methodName = argv[1];
        int offset = Integer.parseInt(argv[2]);
        ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker> driver = new ResourceValueAnalysisTestDriver<Stream, StreamResourceTracker>(){

            public StreamResourceTracker createResourceTracker(ClassContext classContext, Method method) {
                return new StreamResourceTracker(streamFactoryList, classContext.getLookupFailureCallback());
            }

            public /* synthetic */ ResourceTracker createResourceTracker(ClassContext x0, Method x1) throws CFGBuilderException, DataflowAnalysisException {
                return this.createResourceTracker(x0, x1);
            }
        };
        driver.execute(classFile, methodName, offset);
    }

    public /* synthetic */ void analyzeMethod(ClassContext x0, Method x1, ResourceTracker x2, ResourceCollection x3) throws CFGBuilderException, DataflowAnalysisException {
        this.analyzeMethod(x0, x1, (StreamResourceTracker)x2, (ResourceCollection<Stream>)x3);
    }

    public /* synthetic */ void inspectResult(JavaClass x0, MethodGen x1, CFG x2, Dataflow x3, Object x4) {
        this.inspectResult(x0, x1, x2, (Dataflow<ResourceValueFrame, ResourceValueAnalysis<Stream>>)x3, (Stream)x4);
    }

    public /* synthetic */ ResourceTracker getResourceTracker(ClassContext x0, Method x1) throws DataflowAnalysisException, CFGBuilderException {
        return this.getResourceTracker(x0, x1);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        ArrayList<StreamFactory> streamFactoryCollection = new ArrayList<StreamFactory>();
        streamFactoryCollection.add(new IOStreamFactory("java.io.InputStream", new String[]{"java.io.ByteArrayInputStream", "java.io.ObjectInputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.OutputStream", new String[]{"java.io.ByteArrayOutputStream", "java.io.ObjectOutputStream"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Reader", new String[]{"java.io.StringReader", "java.io.CharArrayReader"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new IOStreamFactory("java.io.Writer", new String[]{"java.io.StringWriter", "java.io.CharArrayWriter"}, "OS_OPEN_STREAM"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getInputStream", "()Ljava/io/InputStream;"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.net.Socket", "getOutputStream", "()Ljava/io/OutputStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.InputStream", "java.lang.System", "in", "Ljava/io/InputStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "out", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new StaticFieldLoadStreamFactory("java.io.OutputStream", "java.lang.System", "err", "Ljava/io/PrintStream;"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.InputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Reader"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.OutputStream"));
        streamFactoryCollection.add(new InstanceFieldLoadStreamFactory("java.io.Writer"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;II)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "prepareCall", "(Ljava/lang/String;III)Ljava/sql/CallableStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/util/Properties;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.DriverManager", "getConnection", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ljava/sql/Connection;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "()Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(II)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(III)Ljava/sql/Statement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;II)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;III)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[I)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryCollection.add(new MethodReturnValueStreamFactory("java.sql.Connection", "createStatement", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/sql/PreparedStatement;", "ODR_OPEN_DATABASE_RESOURCE"));
        streamFactoryList = streamFactoryCollection.toArray(new StreamFactory[streamFactoryCollection.size()]);
    }

    private static class PotentialOpenStream {
        public final String bugType;
        public final int priority;
        public final Stream stream;

        public PotentialOpenStream(String bugType, int priority, Stream stream) {
            this.bugType = bugType;
            this.priority = priority;
            this.stream = stream;
        }
    }
}

