/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Method;

public class FindSpinLoop
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("findspinloop.debug");
    int stage = 0;
    int start;
    private BugReporter bugReporter;
    private FieldAnnotation lastFieldSeen;

    public FindSpinLoop(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("Saw " + this.getFullyQualifiedMethodName());
        }
        this.stage = 0;
    }

    public void sawOpcode(int seen) {
        switch (seen) {
            case 42: {
                if (DEBUG) {
                    System.out.println("   ALOAD_0 at PC " + this.getPC());
                }
                this.start = this.getPC();
                this.stage = 1;
                break;
            }
            case 180: {
                if (DEBUG) {
                    System.out.println("   getfield in stage " + this.stage);
                }
                this.lastFieldSeen = FieldAnnotation.fromReferencedField((DismantleBytecode)this);
                if (this.stage == 1) {
                    this.stage = 2;
                    break;
                }
                this.stage = 0;
                break;
            }
            case 153: 
            case 154: 
            case 167: 
            case 198: 
            case 199: {
                if (DEBUG) {
                    System.out.println("   conditional branch in stage " + this.stage + " to " + this.getBranchTarget());
                }
                if (this.stage == 2 && this.getBranchTarget() == this.start) {
                    this.bugReporter.reportBug(new BugInstance("SP_SPIN_ON_FIELD", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((PreorderVisitor)this, this.start).addReferencedField(this.lastFieldSeen));
                    this.stage = 0;
                    break;
                }
                if (this.getBranchTarget() >= this.getPC()) break;
                this.stage = 0;
                break;
            }
            default: {
                this.stage = 0;
            }
        }
    }
}

