/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InefficientToArray
extends BytecodeScanningDetector
implements Constants2 {
    private static final boolean DEBUG = Boolean.getBoolean("ita.debug");
    static final int SEEN_NOTHING = 0;
    static final int SEEN_ICONST_0 = 1;
    static final int SEEN_ANEWARRAY = 2;
    private static JavaClass collectionClass;
    private BugReporter bugReporter;
    private int state = 0;

    public InefficientToArray(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        if (DEBUG) {
            System.out.println("------------------- Analyzing " + obj.getName() + " ----------------");
        }
        this.state = 0;
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        if (collectionClass == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("State: " + this.state + "  Opcode: " + OPCODE_NAMES[seen]);
        }
        switch (this.state) {
            case 0: {
                if (seen != 3) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 189) {
                    this.state = 2;
                    break;
                }
                this.state = 0;
                break;
            }
            case 2: {
                if (seen == 182 && this.getNameConstantOperand().equals("toArray") && this.getSigConstantOperand().equals("([Ljava/lang/Object;)[Ljava/lang/Object;")) {
                    try {
                        String clsName = this.getClassConstantOperand();
                        JavaClass cls = Repository.lookupClass((String)clsName);
                        if (cls.implementationOf(collectionClass)) {
                            this.bugReporter.reportBug(new BugInstance("ITA_INEFFICIENT_TO_ARRAY", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                        }
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.bugReporter.reportMissingClass(cnfe);
                    }
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }

    static {
        try {
            collectionClass = Repository.lookupClass((String)"java.util.Collection");
        }
        catch (ClassNotFoundException cnfe) {
            collectionClass = null;
        }
    }
}

