/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.visitclass.Constants2;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InheritanceUnsafeGetResource
extends BytecodeScanningDetector
implements Constants2 {
    private BugReporter bugReporter;
    private final boolean active = true;
    private boolean classIsFinal;
    private boolean methodIsVisibleToOtherPackages;
    private boolean classIsVisibleToOtherPackages;
    private boolean methodIsFinal;
    private boolean methodIsStatic;
    int state = 0;
    int sawGetClass;
    boolean reportedForThisClass;

    public InheritanceUnsafeGetResource(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
        this.classIsFinal = obj.isFinal();
        this.reportedForThisClass = false;
        this.classIsVisibleToOtherPackages = obj.isPublic() || obj.isProtected();
    }

    public void visit(Method obj) {
        this.methodIsFinal = obj.isFinal();
        this.methodIsStatic = obj.isStatic();
        this.methodIsVisibleToOtherPackages = obj.isPublic() || obj.isProtected();
        this.state = 0;
    }

    public void sawOpcode(int seen) {
        if (this.reportedForThisClass) {
            return;
        }
        switch (seen) {
            case 42: {
                this.state = 1;
                break;
            }
            case 182: {
                if (this.getClassConstantOperand().equals("java/lang/Class") && (this.getNameConstantOperand().equals("getResource") || this.getNameConstantOperand().equals("getResourceAsStream")) && this.sawGetClass + 10 >= this.getPC()) {
                    this.bugReporter.reportBug(new BugInstance("UI_INHERITANCE_UNSAFE_GETRESOURCE", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((DismantleBytecode)this));
                    this.reportedForThisClass = true;
                } else if (this.state == 1 && !this.methodIsStatic && !this.classIsFinal && this.classIsVisibleToOtherPackages && this.getNameConstantOperand().equals("getClass") && this.getSigConstantOperand().equals("()Ljava/lang/Class;")) {
                    this.sawGetClass = this.getPC();
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }
}

