/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.gui.AnalysisRun;
import edu.umd.cs.findbugs.gui.ConsoleLogger;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;

public class RunAnalysisDialog
extends JDialog {
    private final AnalysisRun analysisRun;
    private Thread analysisThread;
    private boolean completed;
    private JLabel bottomVerticalFiller;
    private JButton cancelButton;
    private JLabel countLabel;
    private JLabel countValueLabel;
    private JLabel findBugsLabel;
    private JSeparator jSeparator1;
    private JProgressBar progressBar;
    private JLabel progressLabel;
    private JLabel stageLabel;
    private JLabel stageNameLabel;
    private JLabel topVerticalFiller;

    public RunAnalysisDialog(Frame parent, AnalysisRun analysisRun_) {
        super(parent, true);
        this.initComponents();
        this.analysisRun = analysisRun_;
        this.completed = false;
        final RunAnalysisProgress progress = new RunAnalysisProgress();
        final ConsoleLogger logger = ((FindBugsFrame)parent).getLogger();
        this.analysisThread = new Thread(){

            @Override
            public void run() {
                try {
                    RunAnalysisDialog.this.analysisRun.execute(progress);
                    RunAnalysisDialog.this.setCompleted(true);
                }
                catch (IOException e) {
                    logger.logMessage(2, e.getMessage());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        RunAnalysisDialog.access$900(4.access$800(this.this$1), new WindowEvent(4.access$800(this.this$1), 201));
                    }
                });
            }

            static /* synthetic */ RunAnalysisDialog access$800(4 x0) {
                return x0.RunAnalysisDialog.this;
            }
        };
    }

    public synchronized void setCompleted(boolean completed) {
        this.completed = completed;
    }

    public synchronized boolean isCompleted() {
        return this.completed;
    }

    private void initComponents() {
        this.findBugsLabel = new JLabel();
        this.countLabel = new JLabel();
        this.progressLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.cancelButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.stageLabel = new JLabel();
        this.stageNameLabel = new JLabel();
        this.topVerticalFiller = new JLabel();
        this.bottomVerticalFiller = new JLabel();
        this.countValueLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                RunAnalysisDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                RunAnalysisDialog.this.formWindowOpened(evt);
            }
        });
        this.findBugsLabel.setBackground(new Color(0, 0, 204));
        this.findBugsLabel.setFont(new Font("Dialog", 1, 24));
        this.findBugsLabel.setForeground(new Color(255, 255, 255));
        this.findBugsLabel.setText("Find Bugs!");
        this.findBugsLabel.setOpaque(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        this.getContentPane().add((Component)this.findBugsLabel, gridBagConstraints);
        this.countLabel.setFont(new Font("Dialog", 0, 12));
        this.countLabel.setText("Count:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.countLabel, gridBagConstraints);
        this.progressLabel.setFont(new Font("Dialog", 0, 12));
        this.progressLabel.setText("Progress:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.progressLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.getContentPane().add((Component)this.progressBar, gridBagConstraints);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                RunAnalysisDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.stageLabel.setFont(new Font("Dialog", 0, 12));
        this.stageLabel.setText("Stage:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.getContentPane().add((Component)this.stageLabel, gridBagConstraints);
        this.stageNameLabel.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.stageNameLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.topVerticalFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.bottomVerticalFiller, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.getContentPane().add((Component)this.countValueLabel, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.analysisThread.interrupt();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.analysisThread.start();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    static /* synthetic */ JLabel access$100(RunAnalysisDialog x0) {
        return x0.stageNameLabel;
    }

    static /* synthetic */ JLabel access$300(RunAnalysisDialog x0) {
        return x0.countValueLabel;
    }

    static /* synthetic */ JProgressBar access$400(RunAnalysisDialog x0) {
        return x0.progressBar;
    }

    private class RunAnalysisProgress
    implements FindBugsProgress {
        private int goal;
        private int count;

        private RunAnalysisProgress() {
        }

        private synchronized int getGoal() {
            return this.goal;
        }

        private synchronized int getCount() {
            return this.count;
        }

        public void reportNumberOfArchives(int numArchives) {
            this.beginStage("Scanning archives", numArchives);
        }

        public void finishArchive() {
            this.step();
        }

        public void startAnalysis(int numClasses) {
            this.beginStage("Analyzing classes", numClasses);
        }

        public void finishClass() {
            this.step();
        }

        public void finishPerClassAnalysis() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ RunAnalysisProgress this$1;
                {
                    this.this$1 = runAnalysisProgress;
                }

                public void run() {
                    RunAnalysisDialog.access$100(RunAnalysisProgress.access$000(this.this$1)).setText("Finishing analysis");
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void beginStage(String stageName, int goal) {
            RunAnalysisProgress runAnalysisProgress = this;
            synchronized (runAnalysisProgress) {
                this.count = 0;
                this.goal = goal;
            }
            SwingUtilities.invokeLater(new Runnable(){
                private final /* synthetic */ String val$stageName;
                private final /* synthetic */ RunAnalysisProgress this$1;
                {
                    this.this$1 = runAnalysisProgress;
                    this.val$stageName = string;
                }

                public void run() {
                    int goal = RunAnalysisProgress.access$200(this.this$1);
                    RunAnalysisDialog.access$100(RunAnalysisProgress.access$000(this.this$1)).setText(this.val$stageName);
                    RunAnalysisDialog.access$300(RunAnalysisProgress.access$000(this.this$1)).setText(new StringBuffer().append("0/").append(goal).toString());
                    RunAnalysisDialog.access$400(RunAnalysisProgress.access$000(this.this$1)).setMaximum(goal);
                    RunAnalysisDialog.access$400(RunAnalysisProgress.access$000(this.this$1)).setValue(0);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void step() {
            RunAnalysisProgress runAnalysisProgress = this;
            synchronized (runAnalysisProgress) {
                ++this.count;
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ RunAnalysisProgress this$1;
                {
                    this.this$1 = runAnalysisProgress;
                }

                public void run() {
                    int count = RunAnalysisProgress.access$500(this.this$1);
                    int goal = RunAnalysisProgress.access$200(this.this$1);
                    RunAnalysisDialog.access$300(RunAnalysisProgress.access$000(this.this$1)).setText(count + "/" + goal);
                    RunAnalysisDialog.access$400(RunAnalysisProgress.access$000(this.this$1)).setValue(count);
                }
            });
        }

        static /* synthetic */ RunAnalysisDialog access$000(RunAnalysisProgress x0) {
            return x0.RunAnalysisDialog.this;
        }

        static /* synthetic */ int access$200(RunAnalysisProgress x0) {
            return x0.getGoal();
        }

        static /* synthetic */ int access$500(RunAnalysisProgress x0) {
            return x0.getCount();
        }
    }
}

