/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;

public class AboutDialog
extends JDialog {
    private FindBugsFrame parent;
    private JEditorPane aboutEditorPane;
    private JScrollPane aboutScrollPane;
    private JTabbedPane aboutTabPane;
    private JEditorPane acknowldgementsEditorPane;
    private JScrollPane acknowledgmentsScrollPane;
    private JSeparator jSeparator1;
    private JEditorPane licenseEditorPane;
    private JScrollPane licenseScrollPane;
    private JButton okButton;

    public AboutDialog(FindBugsFrame parent, boolean modal) {
        super((Frame)parent, modal);
        this.parent = parent;
        this.initComponents();
        try {
            this.processPage(this.aboutEditorPane, "edu/umd/cs/findbugs/gui/help/About.html");
            this.licenseEditorPane.setPage(this.getClass().getClassLoader().getResource("edu/umd/cs/findbugs/gui/help/License.html"));
            this.acknowldgementsEditorPane.setPage(this.getClass().getClassLoader().getResource("edu/umd/cs/findbugs/gui/help/Acknowledgements.html"));
        }
        catch (IOException e) {
            parent.getLogger().logMessage(2, e.toString());
        }
        this.setTitle("About FindBugs 0.7.2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPage(JEditorPane pane, String fileName) throws IOException {
        InputStream in = null;
        try {
            String line;
            StringBuffer buf = new StringBuffer();
            in = this.getClass().getClassLoader().getResourceAsStream(fileName);
            if (in == null) {
                throw new IOException("Couldn't load " + fileName);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            Pattern pattern = Pattern.compile("@VERSION@");
            while ((line = reader.readLine()) != null) {
                line = pattern.matcher(line).replaceAll("0.7.2");
                buf.append(line);
                buf.append('\n');
            }
            String text = buf.toString();
            pane.setContentType("text/html");
            pane.setText(text);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {}
        }
    }

    private void initComponents() {
        this.aboutTabPane = new JTabbedPane();
        this.aboutScrollPane = new JScrollPane();
        this.aboutEditorPane = new JEditorPane();
        this.licenseScrollPane = new JScrollPane();
        this.licenseEditorPane = new JEditorPane();
        this.acknowledgmentsScrollPane = new JScrollPane();
        this.acknowldgementsEditorPane = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.okButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AboutDialog.this.closeDialog(evt);
            }
        });
        this.aboutEditorPane.setEditable(false);
        this.aboutScrollPane.setViewportView(this.aboutEditorPane);
        this.aboutTabPane.addTab("About", this.aboutScrollPane);
        this.licenseEditorPane.setEditable(false);
        this.licenseScrollPane.setViewportView(this.licenseEditorPane);
        this.aboutTabPane.addTab("License", this.licenseScrollPane);
        this.acknowldgementsEditorPane.setEditable(false);
        this.acknowledgmentsScrollPane.setViewportView(this.acknowldgementsEditorPane);
        this.aboutTabPane.addTab("Acknowledgments", this.acknowledgmentsScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.aboutTabPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AboutDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.closeDialog();
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }
}

