/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.gui.AnalysisErrorDialog;
import edu.umd.cs.findbugs.gui.ConsoleLogger;
import edu.umd.cs.findbugs.gui.FindBugsFrame;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.tree.DefaultTreeModel;
import org.apache.bcel.classfile.JavaClass;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalysisRun {
    private Project project;
    private FindBugsFrame frame;
    private String summary;
    private ConsoleLogger logger;
    private FindBugs findBugs;
    private Reporter reporter;
    private HashMap<String, DefaultTreeModel> treeModelMap;
    private AnalysisErrorDialog errorDialog;
    private static final String MISSING_SUMMARY_MESSAGE = "<html><head><title>Could not format summary</title></head><body><h1>Could not format summary</h1><p> Please report this failure to <a href=\"findbugs-discuss@cs.umd.edu\">findbugs-discuss@cs.umd.edu</a>.</body></html>";
    private static final boolean CREATE_SUMMARY = !Boolean.getBoolean("findbugs.gui.noSummary");

    public AnalysisRun(Project project, FindBugsFrame frame) {
        this.project = project;
        this.frame = frame;
        this.logger = frame.getLogger();
        this.reporter = new Reporter();
        this.reporter.setPriorityThreshold(3);
        this.findBugs = new FindBugs((BugReporter)this.reporter, project);
        this.treeModelMap = new HashMap();
    }

    public void execute(FindBugsProgress progressCallback) throws IOException, InterruptedException {
        this.findBugs.setProgressCallback(progressCallback);
        this.findBugs.execute();
        this.createSummary(this.reporter.getProjectStats());
    }

    private void createSummary(ProjectStats stats) throws IOException {
        StringWriter html = new StringWriter();
        try {
            stats.transformSummaryToHTML((Writer)html);
            this.summary = html.toString();
        }
        catch (Exception e) {
            this.logger.logMessage(1, new StringBuffer().append("Failed to transform summary: ").append(e.toString()).toString());
            this.summary = MISSING_SUMMARY_MESSAGE;
        }
    }

    public void loadBugsFromFile(File file) throws IOException, DocumentException {
        this.reporter.bugCollection.readXML(file, this.project);
        this.summary = this.reporter.bugCollection.getSummaryHTML();
    }

    public void saveBugsToFile(File file) throws IOException {
        this.reporter.bugCollection.writeXML(file, this.project);
    }

    public void reportAnalysisErrors() {
        if (this.errorDialog != null) {
            this.errorDialog.setSize(750, 520);
            this.errorDialog.setLocationRelativeTo(null);
            this.errorDialog.show();
        }
    }

    public Collection<BugInstance> getBugInstances() {
        return this.reporter.bugCollection.getCollection();
    }

    public void setTreeModel(String groupByOrder, DefaultTreeModel treeModel) {
        this.treeModelMap.put(groupByOrder, treeModel);
    }

    public DefaultTreeModel getTreeModel(String groupByOrder) {
        return this.treeModelMap.get(groupByOrder);
    }

    public String getSummary() {
        return this.summary;
    }

    private class Reporter
    extends AbstractBugReporter {
        private SortedBugCollection bugCollection = new SortedBugCollection();

        private Reporter() {
        }

        public void observeClass(JavaClass javaClass) {
        }

        public void reportMissingClass(ClassNotFoundException ex) {
            super.reportMissingClass(ex);
            String message = Reporter.getMissingClassName((ClassNotFoundException)ex);
            this.bugCollection.addMissingClass(message);
        }

        public void logError(String message) {
            AnalysisRun.this.frame.getLogger().logMessage(1, message);
            super.logError(message);
            this.bugCollection.addError(message);
        }

        public void finish() {
        }

        public void doReportBug(BugInstance bugInstance) {
            if (this.bugCollection.add(bugInstance)) {
                this.notifyObservers(bugInstance);
            }
        }

        public void beginReport() {
            AnalysisRun.this.errorDialog = new AnalysisErrorDialog((Frame)AnalysisRun.this.frame, true);
        }

        public void reportLine(String msg) {
            AnalysisRun.this.errorDialog.addLine(msg);
        }

        public void endReport() {
            AnalysisRun.this.errorDialog.finish();
        }
    }
}

