/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class ConfigureDetectorsDialog
extends JDialog {
    private static final int SPEED_COLUMN = 1;
    private static final int ENABLED_COLUMN = 2;
    private JButton cancelButton;
    private JEditorPane detectorDescription;
    private JScrollPane detectorDescriptionScrollPane;
    private JTable detectorTable;
    private JScrollPane detectorTableScrollPane;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JLabel spacer;
    private ArrayList<DetectorFactory> factoryList = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ConfigureDetectorsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.detectorTableScrollPane = new JScrollPane();
        this.detectorTable = new JTable();
        this.detectorDescriptionScrollPane = new JScrollPane();
        this.detectorDescription = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.spacer = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Configure Detectors");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConfigureDetectorsDialog.this.closeDialog(evt);
            }
        });
        this.detectorTableScrollPane.setBorder(new BevelBorder(1));
        this.detectorTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Bug Detector", "Speed", "Enabled"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigureDetectorsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConfigureDetectorsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigureDetectorsDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean};
                this.canEdit = new boolean[]{false, false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.populateTable();
        this.detectorTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.detectorTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.detectorTable.setSelectionMode(0);
        this.detectorTableScrollPane.setViewportView(this.detectorTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.getContentPane().add((Component)this.detectorTableScrollPane, gridBagConstraints);
        this.detectorDescriptionScrollPane.setBorder(new BevelBorder(1));
        this.detectorDescriptionScrollPane.setPreferredSize(new Dimension(110, 120));
        this.detectorDescriptionScrollPane.setViewportView(this.detectorDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.detectorDescriptionScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 6);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.spacer, gridBagConstraints);
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int num = this.factoryList.size();
        for (int i = 0; i < num; ++i) {
            DetectorFactory factory = this.factoryList.get(i);
            Boolean enabled = (Boolean)this.detectorTable.getValueAt(i, 2);
            factory.setEnabled(enabled.booleanValue());
        }
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void postInitComponents() {
        ListSelectionModel rowSM = this.detectorTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    ConfigureDetectorsDialog.this.viewDetectorDetails((DetectorFactory)ConfigureDetectorsDialog.this.factoryList.get(selectedRow));
                }
            }
        });
    }

    private void viewDetectorDetails(DetectorFactory factory) {
        String detailHTML = factory.getDetailHTML();
        if (detailHTML == null) {
            this.detectorDescription.setText("");
        } else {
            this.detectorDescription.setContentType("text/html");
            this.detectorDescription.setText(detailHTML);
        }
    }

    private void populateTable() {
        Iterator i = DetectorFactoryCollection.instance().factoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            DefaultTableModel model = (DefaultTableModel)this.detectorTable.getModel();
            model.addRow(new Object[]{factory.getFullName(), factory.getSpeed(), factory.isEnabled()});
            this.factoryList.add(factory);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ConfigureDetectorsDialog((Frame)new JFrame(), true).show();
    }
}

