/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.gui.AboutDialog;
import edu.umd.cs.findbugs.gui.AnalysisErrorDialog;
import edu.umd.cs.findbugs.gui.AnalysisRun;
import edu.umd.cs.findbugs.gui.BugInstanceGroup;
import edu.umd.cs.findbugs.gui.ConfigureDetectorsDialog;
import edu.umd.cs.findbugs.gui.ConsoleLogger;
import edu.umd.cs.findbugs.gui.Grouper;
import edu.umd.cs.findbugs.gui.RunAnalysisDialog;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindBugsFrame
extends JFrame {
    private static final Color HIGH_PRIORITY_COLOR = new Color(0xFF0000);
    private static final Color NORMAL_PRIORITY_COLOR = new Color(0x9F0000);
    private static final Color LOW_PRIORITY_COLOR = Color.BLACK;
    private static final BugCellRenderer bugCellRenderer = new BugCellRenderer();
    private static final Comparator<BugInstance> bugInstanceClassComparator = new BugInstanceClassComparator();
    private static final Comparator<BugInstance> bugInstancePackageComparator = new BugInstancePackageComparator();
    private static final Comparator<BugInstance> bugInstanceTypeComparator = new BugInstanceTypeComparator();
    private static final Comparator<BugInstance> bugInstanceByClassComparator = new BugInstanceByClassComparator();
    private static final Comparator<BugInstance> bugInstanceByPackageComparator = new BugInstanceByPackageComparator();
    private static final Comparator<BugInstance> bugInstanceByTypeComparator = new BugInstanceByTypeComparator();
    private static final FileFilter projectFileFilter = new ProjectFileFilter();
    private static final FileFilter auxClasspathEntryFileFilter = new AuxClasspathEntryFileFilter();
    private static final FileFilter xmlFileFilter = new XMLFileFilter();
    private static final HashSet<String> archiveExtensionSet = new HashSet();
    private static final FileFilter archiveAndDirectoryFilter;
    private static final String DEFAULT_PROJECT_NAME = "<<unnamed project>>";
    private static final String GROUP_BY_CLASS = "By class";
    private static final String GROUP_BY_PACKAGE = "By package";
    private static final String GROUP_BY_BUG_TYPE = "By bug type";
    private static final String[] GROUP_BY_ORDER_LIST;
    private static final int DIVIDER_FUDGE = 3;
    private static final boolean BUG_COUNT;
    private static final int SELECTION_VOFFSET = 2;
    private JMenuItem aboutItem;
    private JButton addClasspathEntryButton;
    private JButton addJarButton;
    private JButton addSourceDirButton;
    private JTextArea annotationTextArea;
    private JScrollPane annotationTextAreaScrollPane;
    private JButton browseClasspathEntryButton;
    private JButton browseJarButton;
    private JButton browseSrcDirButton;
    private JEditorPane bugDescriptionEditorPane;
    private JScrollPane bugDescriptionScrollPane;
    private JTabbedPane bugDetailsTabbedPane;
    private JEditorPane bugSummaryEditorPane;
    private JSplitPane bugTreeBugDetailsSplitter;
    private JPanel bugTreePanel;
    private JTree byBugTypeBugTree;
    private JScrollPane byBugTypeScrollPane;
    private JTree byClassBugTree;
    private JScrollPane byClassScrollPane;
    private JTree byPackageBugTree;
    private JScrollPane byPackageScrollPane;
    private JScrollPane bySummary;
    private JLabel classpathEntryLabel;
    private JList classpathEntryList;
    private JLabel classpathEntryListLabel;
    private JScrollPane classpathEntryListScrollPane;
    private JTextField classpathEntryTextField;
    private JMenuItem closeProjectItem;
    private JMenuItem configureDetectorsItem;
    private JTextArea consoleMessageArea;
    private JScrollPane consoleScrollPane;
    private JSplitPane consoleSplitter;
    private JLabel editProjectLabel;
    private JPanel editProjectPanel;
    private JPanel emptyPanel;
    private JMenuItem exitItem;
    private JMenu fileMenu;
    private JButton findBugsButton;
    private JCheckBoxMenuItem fullDescriptionsItem;
    private JTabbedPane groupByTabbedPane;
    private JMenu helpMenu;
    private JRadioButtonMenuItem highPriorityButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JLabel jarFileLabel;
    private JList jarFileList;
    private JLabel jarFileListLabel;
    private JScrollPane jarFileListScrollPane;
    private JTextField jarNameTextField;
    private JMenuItem loadBugsItem;
    private JLabel logoLabel;
    private JRadioButtonMenuItem lowPriorityButton;
    private JRadioButtonMenuItem mediumPriorityButton;
    private JMenuItem newProjectItem;
    private JMenuItem openProjectItem;
    private JMenuItem reloadProjectItem;
    private JButton removeClasspathEntryButton;
    private JButton removeJarButton;
    private JButton removeSrcDirButton;
    private JPanel reportPanel;
    private JMenuItem saveBugsItem;
    private JMenuItem saveProjectAsItem;
    private JMenuItem saveProjectItem;
    private JMenu settingsMenu;
    private JLabel sourceDirLabel;
    private JList sourceDirList;
    private JLabel sourceDirListLabel;
    private JScrollPane sourceDirListScrollPane;
    private JTextArea sourceTextArea;
    private JScrollPane sourceTextAreaScrollPane;
    private JTextField srcDirTextField;
    private JMenuBar theMenuBar;
    private JLabel urlLabel;
    private JCheckBoxMenuItem viewBugDetailsItem;
    private JCheckBoxMenuItem viewConsoleItem;
    private JMenu viewMenu;
    private JPanel viewPanel;
    private ConsoleLogger logger;
    private CardLayout viewPanelLayout;
    private String currentView;
    private File currentDirectory;
    private Project currentProject;
    private JTree[] bugTreeList;
    private AnalysisRun currentAnalysisRun;
    private SourceFinder sourceFinder = new SourceFinder();
    private BugInstance currentBugInstance;
    private SourceLineAnnotation currentSourceLineAnnotation;
    private String currentBugDetailsKey;
    private int priorityThreshold;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$BugInstance;

    public FindBugsFrame() {
        String dirProp = System.getProperty("user.dir");
        if (dirProp != null) {
            this.currentDirectory = new File(dirProp);
        }
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.consoleSplitter = new JSplitPane();
        this.viewPanel = new JPanel();
        this.emptyPanel = new JPanel();
        this.reportPanel = new JPanel();
        this.editProjectPanel = new JPanel();
        this.jarFileLabel = new JLabel();
        this.jarNameTextField = new JTextField();
        this.addJarButton = new JButton();
        this.jarFileListLabel = new JLabel();
        this.sourceDirLabel = new JLabel();
        this.srcDirTextField = new JTextField();
        this.addSourceDirButton = new JButton();
        this.sourceDirListLabel = new JLabel();
        this.removeJarButton = new JButton();
        this.removeSrcDirButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.browseJarButton = new JButton();
        this.browseSrcDirButton = new JButton();
        this.editProjectLabel = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.findBugsButton = new JButton();
        this.jSeparator4 = new JSeparator();
        this.jarFileListScrollPane = new JScrollPane();
        this.jarFileList = new JList();
        this.sourceDirListScrollPane = new JScrollPane();
        this.sourceDirList = new JList();
        this.classpathEntryLabel = new JLabel();
        this.classpathEntryListLabel = new JLabel();
        this.classpathEntryTextField = new JTextField();
        this.browseClasspathEntryButton = new JButton();
        this.addClasspathEntryButton = new JButton();
        this.removeClasspathEntryButton = new JButton();
        this.classpathEntryListScrollPane = new JScrollPane();
        this.classpathEntryList = new JList();
        this.jSeparator5 = new JSeparator();
        this.bugTreePanel = new JPanel();
        this.bugTreeBugDetailsSplitter = new JSplitPane();
        this.groupByTabbedPane = new JTabbedPane();
        this.byClassScrollPane = new JScrollPane();
        this.byClassBugTree = new JTree();
        this.byPackageScrollPane = new JScrollPane();
        this.byPackageBugTree = new JTree();
        this.byBugTypeScrollPane = new JScrollPane();
        this.byBugTypeBugTree = new JTree();
        this.bySummary = new JScrollPane();
        this.bugSummaryEditorPane = new JEditorPane();
        this.bugDetailsTabbedPane = new JTabbedPane();
        this.bugDescriptionScrollPane = new JScrollPane();
        this.bugDescriptionEditorPane = new JEditorPane();
        this.sourceTextAreaScrollPane = new JScrollPane();
        this.sourceTextArea = new JTextArea();
        this.annotationTextAreaScrollPane = new JScrollPane();
        this.annotationTextArea = new JTextArea();
        this.consoleScrollPane = new JScrollPane();
        this.consoleMessageArea = new JTextArea();
        this.urlLabel = new JLabel();
        this.logoLabel = new JLabel();
        this.theMenuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newProjectItem = new JMenuItem();
        this.openProjectItem = new JMenuItem();
        this.saveProjectItem = new JMenuItem();
        this.saveProjectAsItem = new JMenuItem();
        this.reloadProjectItem = new JMenuItem();
        this.closeProjectItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.loadBugsItem = new JMenuItem();
        this.saveBugsItem = new JMenuItem();
        this.jSeparator6 = new JSeparator();
        this.exitItem = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewConsoleItem = new JCheckBoxMenuItem();
        this.viewBugDetailsItem = new JCheckBoxMenuItem();
        this.fullDescriptionsItem = new JCheckBoxMenuItem();
        this.jSeparator7 = new JSeparator();
        this.lowPriorityButton = new JRadioButtonMenuItem();
        this.mediumPriorityButton = new JRadioButtonMenuItem();
        this.highPriorityButton = new JRadioButtonMenuItem();
        this.settingsMenu = new JMenu();
        this.configureDetectorsItem = new JMenuItem();
        this.helpMenu = new JMenu();
        this.aboutItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FindBugsFrame.this.exitForm(evt);
            }
        });
        this.consoleSplitter.setOrientation(0);
        this.consoleSplitter.setResizeWeight(1.0);
        this.consoleSplitter.setOneTouchExpandable(true);
        this.consoleSplitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FindBugsFrame.this.consoleSplitterPropertyChange(evt);
            }
        });
        this.viewPanel.setLayout(new CardLayout());
        this.viewPanel.add((Component)this.emptyPanel, "EmptyPanel");
        this.viewPanel.add((Component)this.reportPanel, "ReportPanel");
        this.editProjectPanel.setLayout(new GridBagLayout());
        this.jarFileLabel.setFont(new Font("Dialog", 0, 12));
        this.jarFileLabel.setText("Archive or directory:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileLabel, gridBagConstraints);
        this.jarNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.jarNameTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.jarNameTextField, gridBagConstraints);
        this.addJarButton.setFont(new Font("Dialog", 0, 12));
        this.addJarButton.setText("Add");
        this.addJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.addJarButton, gridBagConstraints);
        this.jarFileListLabel.setFont(new Font("Dialog", 0, 12));
        this.jarFileListLabel.setText("Archives/directories:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileListLabel, gridBagConstraints);
        this.sourceDirLabel.setFont(new Font("Dialog", 0, 12));
        this.sourceDirLabel.setText("Source directory:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirLabel, gridBagConstraints);
        this.srcDirTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.srcDirTextFieldActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.srcDirTextField, gridBagConstraints);
        this.addSourceDirButton.setFont(new Font("Dialog", 0, 12));
        this.addSourceDirButton.setText("Add");
        this.addSourceDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addSourceDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.addSourceDirButton, gridBagConstraints);
        this.sourceDirListLabel.setFont(new Font("Dialog", 0, 12));
        this.sourceDirListLabel.setText("Source directories:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirListLabel, gridBagConstraints);
        this.removeJarButton.setFont(new Font("Dialog", 0, 12));
        this.removeJarButton.setText("Remove");
        this.removeJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.removeJarButton, gridBagConstraints);
        this.removeSrcDirButton.setFont(new Font("Dialog", 0, 12));
        this.removeSrcDirButton.setText("Remove");
        this.removeSrcDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeSrcDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.removeSrcDirButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator1, gridBagConstraints);
        this.browseJarButton.setFont(new Font("Dialog", 0, 12));
        this.browseJarButton.setText("Browse");
        this.browseJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseJarButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.browseJarButton, gridBagConstraints);
        this.browseSrcDirButton.setFont(new Font("Dialog", 0, 12));
        this.browseSrcDirButton.setText("Browse");
        this.browseSrcDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseSrcDirButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.browseSrcDirButton, gridBagConstraints);
        this.editProjectLabel.setBackground(new Color(0, 0, 204));
        this.editProjectLabel.setFont(new Font("Dialog", 1, 24));
        this.editProjectLabel.setForeground(new Color(255, 255, 255));
        this.editProjectLabel.setText("Project");
        this.editProjectLabel.setOpaque(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        this.editProjectPanel.add((Component)this.editProjectLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator2, gridBagConstraints);
        this.findBugsButton.setMnemonic('B');
        this.findBugsButton.setText("Find Bugs!");
        this.findBugsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.findBugsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.findBugsButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.editProjectPanel.add((Component)this.jSeparator4, gridBagConstraints);
        this.jarFileListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.jarFileList.setBorder(new BevelBorder(1));
        this.jarFileList.setFont(new Font("Dialog", 0, 12));
        this.jarFileList.setSelectionMode(0);
        this.jarFileListScrollPane.setViewportView(this.jarFileList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.jarFileListScrollPane, gridBagConstraints);
        this.sourceDirListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.sourceDirList.setBorder(new BevelBorder(1));
        this.sourceDirList.setFont(new Font("Dialog", 0, 12));
        this.sourceDirList.setSelectionMode(0);
        this.sourceDirListScrollPane.setViewportView(this.sourceDirList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.sourceDirListScrollPane, gridBagConstraints);
        this.classpathEntryLabel.setFont(new Font("Dialog", 0, 12));
        this.classpathEntryLabel.setText("Classpath entry:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryLabel, gridBagConstraints);
        this.classpathEntryListLabel.setFont(new Font("Dialog", 0, 12));
        this.classpathEntryListLabel.setText("Classpath entries:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryListLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.classpathEntryTextField, gridBagConstraints);
        this.browseClasspathEntryButton.setFont(new Font("Dialog", 0, 12));
        this.browseClasspathEntryButton.setText("Browse");
        this.browseClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.browseClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        this.editProjectPanel.add((Component)this.browseClasspathEntryButton, gridBagConstraints);
        this.addClasspathEntryButton.setFont(new Font("Dialog", 0, 12));
        this.addClasspathEntryButton.setText("Add");
        this.addClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.addClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.addClasspathEntryButton, gridBagConstraints);
        this.removeClasspathEntryButton.setFont(new Font("Dialog", 0, 12));
        this.removeClasspathEntryButton.setText("Remove");
        this.removeClasspathEntryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.removeClasspathEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.editProjectPanel.add((Component)this.removeClasspathEntryButton, gridBagConstraints);
        this.classpathEntryListScrollPane.setPreferredSize(new Dimension(259, 1));
        this.classpathEntryList.setBorder(new BevelBorder(1));
        this.classpathEntryList.setFont(new Font("Dialog", 0, 12));
        this.classpathEntryListScrollPane.setViewportView(this.classpathEntryList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 3);
        this.editProjectPanel.add((Component)this.classpathEntryListScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.editProjectPanel.add((Component)this.jSeparator5, gridBagConstraints);
        this.viewPanel.add((Component)this.editProjectPanel, "EditProjectPanel");
        this.bugTreePanel.setLayout(new GridBagLayout());
        this.bugTreeBugDetailsSplitter.setOrientation(0);
        this.bugTreeBugDetailsSplitter.setResizeWeight(1.0);
        this.bugTreeBugDetailsSplitter.setOneTouchExpandable(true);
        this.bugTreeBugDetailsSplitter.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                FindBugsFrame.this.bugTreeBugDetailsSplitterPropertyChange(evt);
            }
        });
        this.byClassScrollPane.setViewportView(this.byClassBugTree);
        this.groupByTabbedPane.addTab("By Class", this.byClassScrollPane);
        this.byPackageScrollPane.setViewportView(this.byPackageBugTree);
        this.groupByTabbedPane.addTab("By Package", this.byPackageScrollPane);
        this.byBugTypeScrollPane.setViewportView(this.byBugTypeBugTree);
        this.groupByTabbedPane.addTab("By Bug Type", this.byBugTypeScrollPane);
        this.bySummary.setViewportView(this.bugSummaryEditorPane);
        this.groupByTabbedPane.addTab("Summary", this.bySummary);
        this.bugTreeBugDetailsSplitter.setTopComponent(this.groupByTabbedPane);
        this.bugDescriptionEditorPane.setEditable(false);
        this.bugDescriptionScrollPane.setViewportView(this.bugDescriptionEditorPane);
        this.bugDetailsTabbedPane.addTab("Details", this.bugDescriptionScrollPane);
        this.sourceTextAreaScrollPane.setMinimumSize(new Dimension(22, 180));
        this.sourceTextAreaScrollPane.setPreferredSize(new Dimension(0, 100));
        this.sourceTextArea.setEditable(false);
        this.sourceTextArea.setFont(new Font("Lucida Sans Typewriter", 0, 12));
        this.sourceTextArea.setEnabled(false);
        this.sourceTextAreaScrollPane.setViewportView(this.sourceTextArea);
        this.bugDetailsTabbedPane.addTab("Source code", this.sourceTextAreaScrollPane);
        this.annotationTextAreaScrollPane.setViewportView(this.annotationTextArea);
        this.bugDetailsTabbedPane.addTab("Annotations", this.annotationTextAreaScrollPane);
        this.bugTreeBugDetailsSplitter.setBottomComponent(this.bugDetailsTabbedPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.bugTreePanel.add((Component)this.bugTreeBugDetailsSplitter, gridBagConstraints);
        this.viewPanel.add((Component)this.bugTreePanel, "BugTree");
        this.consoleSplitter.setTopComponent(this.viewPanel);
        this.consoleScrollPane.setMinimumSize(new Dimension(22, 100));
        this.consoleScrollPane.setPreferredSize(new Dimension(0, 100));
        this.consoleMessageArea.setBackground(new Color(204, 204, 204));
        this.consoleMessageArea.setEditable(false);
        this.consoleMessageArea.setFont(new Font("Lucida Sans Typewriter", 0, 12));
        this.consoleMessageArea.setMinimumSize(new Dimension(0, 0));
        this.consoleMessageArea.setAutoscrolls(false);
        this.consoleScrollPane.setViewportView(this.consoleMessageArea);
        this.consoleSplitter.setBottomComponent(this.consoleScrollPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.consoleSplitter, gridBagConstraints);
        this.urlLabel.setFont(new Font("Dialog", 0, 12));
        this.urlLabel.setText("FindBugs - http://findbugs.sourceforge.net/");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.getContentPane().add((Component)this.urlLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 0, 2, 2);
        this.getContentPane().add((Component)this.logoLabel, gridBagConstraints);
        this.theMenuBar.setFont(new Font("Dialog", 0, 12));
        this.fileMenu.setMnemonic('F');
        this.fileMenu.setText("File");
        this.fileMenu.setFont(new Font("Dialog", 0, 12));
        this.fileMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                FindBugsFrame.this.fileMenuMenuSelected(evt);
            }
        });
        this.newProjectItem.setFont(new Font("Dialog", 0, 12));
        this.newProjectItem.setMnemonic('N');
        this.newProjectItem.setText("New Project");
        this.newProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.newProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.newProjectItem);
        this.openProjectItem.setFont(new Font("Dialog", 0, 12));
        this.openProjectItem.setMnemonic('O');
        this.openProjectItem.setText("Open Project");
        this.openProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.openProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openProjectItem);
        this.saveProjectItem.setFont(new Font("Dialog", 0, 12));
        this.saveProjectItem.setMnemonic('S');
        this.saveProjectItem.setText("Save Project");
        this.saveProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectItem);
        this.saveProjectAsItem.setFont(new Font("Dialog", 0, 12));
        this.saveProjectAsItem.setMnemonic('A');
        this.saveProjectAsItem.setText("Save Project As");
        this.saveProjectAsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveProjectAsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveProjectAsItem);
        this.reloadProjectItem.setFont(new Font("Dialog", 0, 12));
        this.reloadProjectItem.setMnemonic('R');
        this.reloadProjectItem.setText("Reload Project");
        this.reloadProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.reloadProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.reloadProjectItem);
        this.closeProjectItem.setFont(new Font("Dialog", 0, 12));
        this.closeProjectItem.setMnemonic('C');
        this.closeProjectItem.setText("Close Project");
        this.closeProjectItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.closeProjectItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeProjectItem);
        this.fileMenu.add(this.jSeparator3);
        this.loadBugsItem.setFont(new Font("Dialog", 0, 12));
        this.loadBugsItem.setMnemonic('L');
        this.loadBugsItem.setText("Load Bugs");
        this.loadBugsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.loadBugsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.loadBugsItem);
        this.saveBugsItem.setFont(new Font("Dialog", 0, 12));
        this.saveBugsItem.setMnemonic('B');
        this.saveBugsItem.setText("Save Bugs");
        this.saveBugsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.saveBugsItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveBugsItem);
        this.fileMenu.add(this.jSeparator6);
        this.exitItem.setFont(new Font("Dialog", 0, 12));
        this.exitItem.setMnemonic('X');
        this.exitItem.setText("Exit");
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.exitItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitItem);
        this.theMenuBar.add(this.fileMenu);
        this.viewMenu.setMnemonic('V');
        this.viewMenu.setText("View");
        this.viewMenu.setFont(new Font("Dialog", 0, 12));
        this.viewMenu.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                FindBugsFrame.this.viewMenuMenuSelected(evt);
            }
        });
        this.viewConsoleItem.setFont(new Font("Dialog", 0, 12));
        this.viewConsoleItem.setMnemonic('C');
        this.viewConsoleItem.setText("Console");
        this.viewConsoleItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.viewConsoleItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewConsoleItem);
        this.viewBugDetailsItem.setFont(new Font("Dialog", 0, 12));
        this.viewBugDetailsItem.setMnemonic('D');
        this.viewBugDetailsItem.setSelected(true);
        this.viewBugDetailsItem.setText("Bug Details");
        this.viewBugDetailsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.viewBugDetailsItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewBugDetailsItem);
        this.fullDescriptionsItem.setFont(new Font("Dialog", 0, 12));
        this.fullDescriptionsItem.setMnemonic('F');
        this.fullDescriptionsItem.setSelected(true);
        this.fullDescriptionsItem.setText("Full Descriptions");
        this.fullDescriptionsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.fullDescriptionsItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.fullDescriptionsItem);
        this.viewMenu.add(this.jSeparator7);
        this.lowPriorityButton.setFont(new Font("Dialog", 0, 12));
        this.lowPriorityButton.setMnemonic('L');
        this.lowPriorityButton.setText("Low priority");
        this.lowPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.lowPriorityButtonActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.lowPriorityButton);
        this.mediumPriorityButton.setFont(new Font("Dialog", 0, 12));
        this.mediumPriorityButton.setMnemonic('M');
        this.mediumPriorityButton.setSelected(true);
        this.mediumPriorityButton.setText("Medium priority");
        this.mediumPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.mediumPriorityButtonActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.mediumPriorityButton);
        this.highPriorityButton.setFont(new Font("Dialog", 0, 12));
        this.highPriorityButton.setMnemonic('H');
        this.highPriorityButton.setText("High priority");
        this.highPriorityButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.highPriorityButtonActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.highPriorityButton);
        this.theMenuBar.add(this.viewMenu);
        this.settingsMenu.setMnemonic('S');
        this.settingsMenu.setText("Settings");
        this.settingsMenu.setFont(new Font("Dialog", 0, 12));
        this.configureDetectorsItem.setFont(new Font("Dialog", 0, 12));
        this.configureDetectorsItem.setMnemonic('C');
        this.configureDetectorsItem.setText("Configure Detectors...");
        this.configureDetectorsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.configureDetectorsItemActionPerformed(evt);
            }
        });
        this.settingsMenu.add(this.configureDetectorsItem);
        this.theMenuBar.add(this.settingsMenu);
        this.helpMenu.setMnemonic('H');
        this.helpMenu.setText("Help");
        this.helpMenu.setFont(new Font("Dialog", 0, 12));
        this.aboutItem.setFont(new Font("Dialog", 0, 12));
        this.aboutItem.setMnemonic('A');
        this.aboutItem.setText("About");
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FindBugsFrame.this.aboutItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.theMenuBar.add(this.helpMenu);
        this.setJMenuBar(this.theMenuBar);
        this.pack();
    }

    private void highPriorityButtonActionPerformed(ActionEvent evt) {
        this.mediumPriorityButton.setSelected(false);
        this.lowPriorityButton.setSelected(false);
        this.setPriorityThreshold(1);
    }

    private void mediumPriorityButtonActionPerformed(ActionEvent evt) {
        this.highPriorityButton.setSelected(false);
        this.lowPriorityButton.setSelected(false);
        this.setPriorityThreshold(2);
    }

    private void lowPriorityButtonActionPerformed(ActionEvent evt) {
        this.highPriorityButton.setSelected(false);
        this.mediumPriorityButton.setSelected(false);
        this.setPriorityThreshold(3);
    }

    private void saveBugsItemActionPerformed(ActionEvent evt) {
        try {
            if (this.currentAnalysisRun == null) {
                this.logger.logMessage(2, "No bugs are loaded!");
                return;
            }
            JFileChooser chooser = this.createFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(xmlFileFilter);
            int result = this.chooseFile(chooser, "Save bugs");
            if (result != 1) {
                if (this.currentBugInstance != null) {
                    this.synchBugAnnotation(this.currentBugInstance);
                }
                File selectedFile = chooser.getSelectedFile();
                this.currentAnalysisRun.saveBugsToFile(selectedFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logMessage(2, new StringBuffer().append("Could not save bugs: ").append(e.toString()).toString());
        }
    }

    private void loadBugsItemActionPerformed(ActionEvent evt) {
        try {
            JFileChooser chooser = this.createFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setFileFilter(xmlFileFilter);
            int result = this.chooseFile(chooser, "Load bugs");
            if (result != 1) {
                File selectedFile = chooser.getSelectedFile();
                Project project = new Project();
                AnalysisRun analysisRun = new AnalysisRun(project, this);
                analysisRun.loadBugsFromFile(selectedFile);
                this.setProject(project);
                this.synchAnalysisRun(analysisRun);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.logMessage(2, new StringBuffer().append("Could not load bugs: ").append(e.toString()).toString());
        }
    }

    private void configureDetectorsItemActionPerformed(ActionEvent evt) {
        ConfigureDetectorsDialog dialog = new ConfigureDetectorsDialog((Frame)this, true);
        dialog.setSize(700, 520);
        dialog.setLocationRelativeTo(null);
        dialog.show();
    }

    private void reloadProjectItemActionPerformed(ActionEvent evt) {
        Project current = this.getCurrentProject();
        if (current == null) {
            return;
        }
        try {
            String filename = current.getFileName();
            File file = new File(filename);
            Project project = new Project(file.getPath());
            FileInputStream in = new FileInputStream(file);
            project.read((InputStream)in);
            this.setProject(null);
            this.setProject(project);
            this.findBugsButtonActionPerformed(evt);
        }
        catch (IOException e) {
            this.logger.logMessage(2, new StringBuffer().append("Could not reload project: ").append(e.getMessage()).toString());
        }
    }

    private void saveProjectAsItemActionPerformed(ActionEvent evt) {
        this.saveProject(this.getCurrentProject(), "Save project as", true);
    }

    private void viewMenuMenuSelected(MenuEvent evt) {
        boolean hasProject = this.getCurrentProject() != null;
        this.viewBugDetailsItem.setEnabled(hasProject);
        this.fullDescriptionsItem.setEnabled(hasProject);
    }

    private void fileMenuMenuSelected(MenuEvent evt) {
        boolean hasProject = this.getCurrentProject() != null;
        this.saveProjectItem.setEnabled(hasProject);
        this.saveProjectAsItem.setEnabled(hasProject);
        this.reloadProjectItem.setEnabled(hasProject);
        this.closeProjectItem.setEnabled(hasProject);
    }

    private void closeProjectItemActionPerformed(ActionEvent evt) {
        if (this.closeProjectHook(this.getCurrentProject(), "Close project")) {
            this.setProject(null);
        }
    }

    private void removeClasspathEntryButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.classpathEntryList.getSelectedIndex();
        if (selIndex >= 0) {
            Project project = this.getCurrentProject();
            project.removeAuxClasspathEntry(selIndex);
            DefaultListModel listModel = (DefaultListModel)this.classpathEntryList.getModel();
            listModel.removeElementAt(selIndex);
        }
    }

    private void addClasspathEntryButtonActionPerformed(ActionEvent evt) {
        this.addClasspathEntryToList();
    }

    private void browseClasspathEntryButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileSelectionMode(2);
        chooser.setFileFilter(auxClasspathEntryFileFilter);
        chooser.setMultiSelectionEnabled(true);
        int result = this.chooseFile(chooser, "Add entry");
        if (result != 1) {
            File[] selectedFileList = chooser.getSelectedFiles();
            for (int i = 0; i < selectedFileList.length; ++i) {
                String entry = selectedFileList[i].getPath();
                this.addClasspathEntryToProject(entry);
            }
        }
    }

    private void fullDescriptionsItemActionPerformed(ActionEvent evt) {
        for (int j = 0; j < this.bugTreeList.length; ++j) {
            JTree bugTree = this.bugTreeList[j];
            DefaultTreeModel bugTreeModel = (DefaultTreeModel)bugTree.getModel();
            int numRows = bugTree.getRowCount();
            for (int i = 0; i < numRows; ++i) {
                DefaultMutableTreeNode node;
                TreePath path = bugTree.getPathForRow(i);
                if (path == null || !((node = (DefaultMutableTreeNode)path.getLastPathComponent()) instanceof BugTreeNode)) continue;
                bugTreeModel.valueForPathChanged(path, node.getUserObject());
            }
        }
    }

    private void viewBugDetailsItemActionPerformed(ActionEvent evt) {
        String view = this.getView();
        if (view.equals("BugTree")) {
            this.checkBugDetailsVisibility();
        }
    }

    private void bugTreeBugDetailsSplitterPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("dividerLocation")) {
            boolean isMaximized = this.isSplitterMaximized(this.bugTreeBugDetailsSplitter, evt);
            this.viewBugDetailsItem.setSelected(!isMaximized);
            if (!isMaximized) {
                this.synchBugInstance();
            }
        }
    }

    private void openProjectItemActionPerformed(ActionEvent evt) {
        if (!this.closeProjectHook(this.getCurrentProject(), "Open Project")) {
            return;
        }
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(projectFileFilter);
        int result = this.chooseFileToOpen(chooser);
        if (result == 1) {
            return;
        }
        try {
            File file = chooser.getSelectedFile();
            Project project = new Project(file.getPath());
            FileInputStream in = new FileInputStream(file);
            project.read((InputStream)in);
            this.setProject(project);
        }
        catch (IOException e) {
            this.logger.logMessage(2, new StringBuffer().append("Could not open project: ").append(e.getMessage()).toString());
        }
    }

    private void saveProjectItemActionPerformed(ActionEvent evt) {
        this.saveProject(this.getCurrentProject(), "Save project");
    }

    private void aboutItemActionPerformed(ActionEvent evt) {
        AboutDialog dialog = new AboutDialog(this, true);
        dialog.setSize(500, 354);
        dialog.setLocationRelativeTo(null);
        dialog.show();
    }

    private void consoleSplitterPropertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("dividerLocation")) {
            boolean isMaximized = this.isSplitterMaximized(this.consoleSplitter, evt);
            this.viewConsoleItem.setSelected(!isMaximized);
        }
    }

    private void viewConsoleItemActionPerformed(ActionEvent evt) {
        if (this.viewConsoleItem.isSelected()) {
            this.consoleSplitter.resetToPreferredSizes();
        } else {
            this.consoleSplitter.setDividerLocation(1.0);
        }
    }

    private void findBugsButtonActionPerformed(ActionEvent evt) {
        Project project = this.getCurrentProject();
        if (project.getNumJarFiles() == 0) {
            this.logger.logMessage(2, new StringBuffer().append("Project ").append(project).append(" has no Jar files selected").toString());
            return;
        }
        this.bugDescriptionEditorPane.setText("");
        this.sourceTextArea.setText("");
        AnalysisRun analysisRun = new AnalysisRun(project, this);
        this.logger.logMessage(0, new StringBuffer().append("Beginning analysis of ").append(project).toString());
        RunAnalysisDialog dialog = new RunAnalysisDialog((Frame)this, analysisRun);
        dialog.setSize(400, 300);
        dialog.setLocationRelativeTo(null);
        dialog.show();
        if (dialog.isCompleted()) {
            this.logger.logMessage(0, new StringBuffer().append("Analysis ").append(project).append(" completed").toString());
            analysisRun.reportAnalysisErrors();
            this.synchAnalysisRun(analysisRun);
        } else if (dialog.exceptionOccurred()) {
            Exception e = dialog.getException();
            AnalysisErrorDialog err = new AnalysisErrorDialog((Frame)this, true);
            err.addLine(new StringBuffer().append("Fatal analysis exception: ").append(e.toString()).toString());
            StackTraceElement[] callList = e.getStackTrace();
            for (int i = 0; i < callList.length; ++i) {
                err.addLine(new StringBuffer().append("\t").append(callList[i]).toString());
            }
            err.finish();
            err.setSize(650, 500);
            err.show();
        } else {
            this.logger.logMessage(0, new StringBuffer().append("Analysis of ").append(project).append(" cancelled by user").toString());
        }
    }

    private void browseSrcDirButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(archiveAndDirectoryFilter);
        chooser.setFileSelectionMode(2);
        int rc = this.chooseFile(chooser, "Add source directory or archive");
        if (rc == 0) {
            this.srcDirTextField.setText(chooser.getSelectedFile().getPath());
            this.addSourceDirToList();
        }
    }

    private void srcDirTextFieldActionPerformed(ActionEvent evt) {
        this.addSourceDirToList();
    }

    private void jarNameTextFieldActionPerformed(ActionEvent evt) {
        this.addJarToList();
    }

    private void browseJarButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = this.createFileChooser();
        chooser.setFileFilter(archiveAndDirectoryFilter);
        chooser.setMultiSelectionEnabled(true);
        chooser.setFileSelectionMode(2);
        int rc = this.chooseFile(chooser, "Add archive or directory");
        if (rc == 0) {
            File[] selectedFileList = chooser.getSelectedFiles();
            for (int i = 0; i < selectedFileList.length; ++i) {
                String entry = selectedFileList[i].getPath();
                this.addJarToProject(entry);
            }
        }
    }

    private void newProjectItemActionPerformed(ActionEvent evt) {
        Project project = new Project(DEFAULT_PROJECT_NAME);
        this.setProject(project);
    }

    private void exitItemActionPerformed(ActionEvent evt) {
        this.exitFindBugs();
    }

    private void removeSrcDirButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.sourceDirList.getSelectedIndex();
        if (selIndex >= 0) {
            Project project = this.getCurrentProject();
            project.removeSourceDir(selIndex);
            DefaultListModel listModel = (DefaultListModel)this.sourceDirList.getModel();
            listModel.removeElementAt(selIndex);
        }
    }

    private void removeJarButtonActionPerformed(ActionEvent evt) {
        int selIndex = this.jarFileList.getSelectedIndex();
        if (selIndex >= 0) {
            Project project = this.getCurrentProject();
            project.removeJarFile(selIndex);
            DefaultListModel listModel = (DefaultListModel)this.jarFileList.getModel();
            listModel.removeElementAt(selIndex);
        }
    }

    private void addSourceDirButtonActionPerformed(ActionEvent evt) {
        this.addSourceDirToList();
    }

    private void addJarButtonActionPerformed(ActionEvent evt) {
        this.addJarToList();
    }

    private void exitForm(WindowEvent evt) {
        this.exitFindBugs();
    }

    private void bugTreeSelectionChanged(TreeSelectionEvent e) {
        BugInstance selected = this.getCurrentBugInstance();
        if (selected != null) {
            this.synchBugInstance();
        }
    }

    private void postInitComponents() {
        this.logger = new ConsoleLogger(this);
        this.viewPanelLayout = (CardLayout)this.viewPanel.getLayout();
        this.consoleSplitter.setDividerLocation(1.0);
        this.bugTreeList = new JTree[]{this.byClassBugTree, this.byPackageBugTree, this.byBugTypeBugTree};
        for (int i = 0; i < this.bugTreeList.length; ++i) {
            JTree bugTree = this.bugTreeList[i];
            bugTree.getSelectionModel().setSelectionMode(1);
            bugTree.setCellRenderer(bugCellRenderer);
            bugTree.setRootVisible(false);
            bugTree.setShowsRootHandles(true);
            bugTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    FindBugsFrame.this.bugTreeSelectionChanged(e);
                }
            });
        }
        this.jarFileList.setModel(new DefaultListModel());
        this.sourceDirList.setModel(new DefaultListModel());
        this.classpathEntryList.setModel(new DefaultListModel());
        final DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(this.sourceTextArea.getSelectionColor()){

            public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
                try {
                    Shape extent = view.modelToView(offs0, Position.Bias.Forward, offs1, Position.Bias.Backward, bounds);
                    Rectangle rect = extent.getBounds();
                    rect.x = 0;
                    rect.width = bounds.getBounds().width;
                    g.setColor(this.getColor());
                    g.fillRect(rect.x, rect.y, rect.width, rect.height);
                    return rect;
                }
                catch (BadLocationException e) {
                    return null;
                }
            }
        };
        DefaultHighlighter sourceHighlighter = new DefaultHighlighter(){

            @Override
            public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter p) throws BadLocationException {
                return super.addHighlight(p0, p1, painter);
            }
        };
        this.sourceTextArea.setHighlighter(sourceHighlighter);
        this.updateTitle(this.getCurrentProject());
        this.priorityThreshold = 2;
        ClassLoader classLoader = this.getClass().getClassLoader();
        ImageIcon logoIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/logo_umd.png"));
        this.logoLabel.setIcon(logoIcon);
    }

    private static Object getTreeSelectionOf(JTree tree, Class c) {
        TreePath selPath = tree.getSelectionPath();
        if (selPath == null) {
            return null;
        }
        Object[] nodeList = selPath.getPath();
        for (int i = nodeList.length - 1; i >= 0; --i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodeList[i];
            Object nodeInfo = node.getUserObject();
            if (nodeInfo == null || nodeInfo.getClass() != c) continue;
            return nodeInfo;
        }
        return null;
    }

    private Project getCurrentProject() {
        return this.currentProject;
    }

    private AnalysisRun getCurrentAnalysisRun() {
        return this.currentAnalysisRun;
    }

    private BugInstance getCurrentBugInstance() {
        JTree bugTree = this.getCurrentBugTree();
        if (bugTree != null) {
            return (BugInstance)FindBugsFrame.getTreeSelectionOf(bugTree, class$edu$umd$cs$findbugs$BugInstance == null ? (class$edu$umd$cs$findbugs$BugInstance = FindBugsFrame.class$("edu.umd.cs.findbugs.BugInstance")) : class$edu$umd$cs$findbugs$BugInstance);
        }
        return null;
    }

    private boolean isSplitterMaximized(JSplitPane splitter, PropertyChangeEvent evt) {
        Integer location = (Integer)evt.getNewValue();
        Container parent = splitter.getParent();
        int height = splitter.getHeight();
        int hopefullyMaxDivider = height - (splitter.getDividerSize() + 3);
        boolean isMaximized = location >= hopefullyMaxDivider;
        return isMaximized;
    }

    private void checkBugDetailsVisibility() {
        if (this.viewBugDetailsItem.isSelected()) {
            this.bugTreeBugDetailsSplitter.resetToPreferredSizes();
        } else {
            this.bugTreeBugDetailsSplitter.setDividerLocation(1.0);
        }
    }

    private JTree getCurrentBugTree() {
        JScrollPane selected = (JScrollPane)this.groupByTabbedPane.getSelectedComponent();
        Component view = selected.getViewport().getView();
        if (view instanceof JTree) {
            return (JTree)view;
        }
        return null;
    }

    private void setPriorityThreshold(int threshold) {
        if (threshold != this.priorityThreshold) {
            this.priorityThreshold = threshold;
            if (this.currentAnalysisRun != null) {
                this.synchAnalysisRun(this.currentAnalysisRun);
            }
        }
    }

    private void setProject(Project project) {
        this.currentProject = project;
        if (project != null) {
            this.synchProject(project);
            this.setView("EditProjectPanel");
        } else {
            this.setView("EmptyPanel");
        }
        this.updateTitle(project);
    }

    private void updateTitle(Project project) {
        if (project == null) {
            this.setTitle("FindBugs - no project");
        } else {
            this.setTitle(new StringBuffer().append("FindBugs - ").append(project.toString()).toString());
        }
    }

    private boolean saveProject(Project project, String dialogTitle) {
        return this.saveProject(project, dialogTitle, false);
    }

    private boolean saveProject(Project project, String dialogTitle, boolean chooseFilename) {
        try {
            File file;
            if (project == null) {
                return true;
            }
            String fileName = project.getFileName();
            if (!fileName.startsWith("<") && !chooseFilename) {
                file = new File(fileName);
            } else {
                JFileChooser chooser = this.createFileChooser();
                chooser.setFileFilter(projectFileFilter);
                int result = this.chooseFile(chooser, dialogTitle);
                if (result == 1) {
                    return false;
                }
                file = chooser.getSelectedFile();
                fileName = Project.transformFilename((String)file.getPath());
                file = new File(fileName);
            }
            FileOutputStream out = new FileOutputStream(file);
            project.write((OutputStream)out);
            this.logger.logMessage(0, "Project saved");
            project.setFileName(file.getPath());
            this.updateTitle(project);
            return true;
        }
        catch (IOException e) {
            this.logger.logMessage(2, new StringBuffer().append("Could not save project: ").append(e.toString()).toString());
            JOptionPane.showMessageDialog(this, new StringBuffer().append("Error saving project: ").append(e.toString()).toString(), "Error", 0);
            return false;
        }
    }

    private boolean closeProjectHook(Project project, String savePromptTitle) {
        if (project == null || !project.isModified()) {
            return true;
        }
        int option = JOptionPane.showConfirmDialog(this, "Save project?", savePromptTitle, 1, 3);
        if (option == 2) {
            return false;
        }
        if (option == 0) {
            boolean result = this.saveProject(project, "Save project");
            if (result) {
                JOptionPane.showMessageDialog(this, "Project saved");
            }
            return result;
        }
        return true;
    }

    private void synchProject(Project project) {
        this.jarNameTextField.setText("");
        this.srcDirTextField.setText("");
        this.classpathEntryTextField.setText("");
        DefaultListModel jarListModel = (DefaultListModel)this.jarFileList.getModel();
        jarListModel.clear();
        for (int i = 0; i < project.getNumJarFiles(); ++i) {
            jarListModel.addElement(project.getJarFile(i));
        }
        DefaultListModel srcDirListModel = (DefaultListModel)this.sourceDirList.getModel();
        srcDirListModel.clear();
        for (int i = 0; i < project.getNumSourceDirs(); ++i) {
            srcDirListModel.addElement(project.getSourceDir(i));
        }
        DefaultListModel classpathEntryListModel = (DefaultListModel)this.classpathEntryList.getModel();
        classpathEntryListModel.clear();
        for (int i = 0; i < project.getNumAuxClasspathEntries(); ++i) {
            classpathEntryListModel.addElement(project.getAuxClasspathEntry(i));
        }
    }

    private void synchAnalysisRun(AnalysisRun analysisRun) {
        for (int i = 0; i < GROUP_BY_ORDER_LIST.length; ++i) {
            DefaultMutableTreeNode bugRootNode = new DefaultMutableTreeNode();
            DefaultTreeModel bugTreeModel = new DefaultTreeModel(bugRootNode);
            String groupByOrder = GROUP_BY_ORDER_LIST[i];
            analysisRun.setTreeModel(groupByOrder, bugTreeModel);
            this.populateAnalysisRunTreeModel(analysisRun, groupByOrder);
            if (i >= this.bugTreeList.length) continue;
            this.bugTreeList[i].setModel(bugTreeModel);
        }
        this.currentAnalysisRun = analysisRun;
        this.setSummary(analysisRun.getSummary());
        this.setView("BugTree");
    }

    private void setSummary(String summaryXML) {
        this.bugSummaryEditorPane.setContentType("text/html");
        this.bugSummaryEditorPane.setText(summaryXML);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindBugsFrame.this.bySummary.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    private void populateAnalysisRunTreeModel(AnalysisRun analysisRun, final String groupBy) {
        Cursor orig = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        final DefaultTreeModel bugTreeModel = analysisRun.getTreeModel(groupBy);
        final DefaultMutableTreeNode bugRootNode = (DefaultMutableTreeNode)bugTreeModel.getRoot();
        bugRootNode.removeAllChildren();
        TreeSet<BugInstance> sortedCollection = new TreeSet<BugInstance>(this.getBugInstanceComparator(groupBy));
        for (BugInstance bugInstance : analysisRun.getBugInstances()) {
            if (bugInstance.getPriority() > this.priorityThreshold) continue;
            sortedCollection.add(bugInstance);
        }
        Grouper.Callback<BugInstance> callback = new Grouper.Callback<BugInstance>(){
            private BugInstanceGroup currentGroup;
            private DefaultMutableTreeNode currentGroupNode;

            @Override
            public void startGroup(BugInstance member) {
                String groupName;
                if (groupBy == FindBugsFrame.GROUP_BY_CLASS) {
                    groupName = member.getPrimaryClass().getClassName();
                } else if (groupBy == FindBugsFrame.GROUP_BY_PACKAGE) {
                    groupName = member.getPrimaryClass().getPackageName();
                    if (groupName.equals("")) {
                        groupName = "Unnamed package";
                    }
                } else if (groupBy == FindBugsFrame.GROUP_BY_BUG_TYPE) {
                    String desc = member.toString();
                    String shortBugType = desc.substring(0, desc.indexOf(58));
                    String bugTypeDescription = I18N.instance().getBugTypeDescription(shortBugType);
                    groupName = new StringBuffer().append(shortBugType).append(": ").append(bugTypeDescription).toString();
                } else {
                    throw new IllegalStateException(new StringBuffer().append("Unknown sort order: ").append(groupBy).toString());
                }
                this.currentGroup = new BugInstanceGroup(groupBy, groupName);
                this.currentGroupNode = new DefaultMutableTreeNode(this.currentGroup);
                bugTreeModel.insertNodeInto(this.currentGroupNode, bugRootNode, bugRootNode.getChildCount());
                this.insertIntoGroup(member);
            }

            @Override
            public void addToGroup(BugInstance member) {
                this.insertIntoGroup(member);
            }

            private void insertIntoGroup(BugInstance member) {
                int count = this.currentGroup.getMemberCount();
                this.currentGroup.incrementMemberCount();
                BugTreeNode bugNode = new BugTreeNode(member);
                if (BUG_COUNT) {
                    bugNode.setCount(count);
                }
                bugTreeModel.insertNodeInto(bugNode, this.currentGroupNode, this.currentGroupNode.getChildCount());
                Iterator j = member.annotationIterator();
                while (j.hasNext()) {
                    BugAnnotation annotation = (BugAnnotation)j.next();
                    DefaultMutableTreeNode annotationNode = new DefaultMutableTreeNode(annotation);
                    bugTreeModel.insertNodeInto(annotationNode, bugNode, bugNode.getChildCount());
                }
            }

            @Override
            public /* synthetic */ void addToGroup(Object x0) {
                this.addToGroup((BugInstance)x0);
            }

            @Override
            public /* synthetic */ void startGroup(Object x0) {
                this.startGroup((BugInstance)x0);
            }
        };
        Grouper<BugInstance> grouper = new Grouper<BugInstance>(callback);
        Comparator<BugInstance> groupComparator = this.getGroupComparator(groupBy);
        grouper.group(sortedCollection, groupComparator);
        bugTreeModel.nodeStructureChanged(bugRootNode);
        this.setCursor(orig);
    }

    private Comparator<BugInstance> getBugInstanceComparator(String sortOrder) {
        if (sortOrder.equals(GROUP_BY_CLASS)) {
            return bugInstanceByClassComparator;
        }
        if (sortOrder.equals(GROUP_BY_PACKAGE)) {
            return bugInstanceByPackageComparator;
        }
        if (sortOrder.equals(GROUP_BY_BUG_TYPE)) {
            return bugInstanceByTypeComparator;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Bad sort order: ").append(sortOrder).toString());
    }

    private Comparator<BugInstance> getGroupComparator(String groupBy) {
        if (groupBy.equals(GROUP_BY_CLASS)) {
            return bugInstanceClassComparator;
        }
        if (groupBy.equals(GROUP_BY_PACKAGE)) {
            return bugInstancePackageComparator;
        }
        if (groupBy.equals(GROUP_BY_BUG_TYPE)) {
            return bugInstanceTypeComparator;
        }
        throw new IllegalArgumentException(new StringBuffer().append("Bad sort order: ").append(groupBy).toString());
    }

    private void setView(String viewName) {
        this.viewPanelLayout.show(this.viewPanel, viewName);
        if (viewName.equals("BugTree")) {
            this.checkBugDetailsVisibility();
        }
        this.currentView = viewName;
    }

    private String getView() {
        return this.currentView;
    }

    private void addJarToList() {
        String jarFile = this.jarNameTextField.getText();
        if (!jarFile.equals("")) {
            this.addJarToProject(jarFile);
            this.jarNameTextField.setText("");
        }
    }

    private void addJarToProject(String jarFile) {
        Project project = this.getCurrentProject();
        if (project.addJar(jarFile)) {
            DefaultListModel listModel = (DefaultListModel)this.jarFileList.getModel();
            listModel.addElement(jarFile);
        }
    }

    private void addSourceDirToList() {
        String sourceDir = this.srcDirTextField.getText();
        if (!sourceDir.equals("")) {
            Project project = this.getCurrentProject();
            if (project.addSourceDir(sourceDir)) {
                DefaultListModel listModel = (DefaultListModel)this.sourceDirList.getModel();
                listModel.addElement(sourceDir);
            }
            this.srcDirTextField.setText("");
        }
    }

    private void addClasspathEntryToList() {
        String classpathEntry = this.classpathEntryTextField.getText();
        if (!classpathEntry.equals("")) {
            this.addClasspathEntryToProject(classpathEntry);
            this.classpathEntryTextField.setText("");
        }
    }

    private void addClasspathEntryToProject(String classpathEntry) {
        Project project = this.getCurrentProject();
        if (project.addAuxClasspathEntry(classpathEntry)) {
            DefaultListModel listModel = (DefaultListModel)this.classpathEntryList.getModel();
            listModel.addElement(classpathEntry);
        }
    }

    private void synchBugInstance() {
        BugInstance selected = this.getCurrentBugInstance();
        if (selected == null) {
            return;
        }
        if (!this.viewBugDetailsItem.isSelected()) {
            return;
        }
        JTree bugTree = this.getCurrentBugTree();
        if (bugTree == null) {
            return;
        }
        SourceLineAnnotation srcLine = null;
        TreePath selPath = bugTree.getSelectionPath();
        if (selPath != null) {
            Object leaf = ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getUserObject();
            srcLine = leaf instanceof SourceLineAnnotation ? (SourceLineAnnotation)leaf : selected.getPrimarySourceLineAnnotation();
        }
        if (srcLine == null || srcLine != this.currentSourceLineAnnotation) {
            Project project = this.getCurrentProject();
            AnalysisRun analysisRun = this.getCurrentAnalysisRun();
            if (project == null) {
                throw new IllegalStateException("null project!");
            }
            if (analysisRun == null) {
                throw new IllegalStateException("null analysis run!");
            }
            try {
                boolean success = this.viewSource(project, analysisRun, srcLine);
                this.sourceTextArea.setEnabled(success);
                if (!success) {
                    this.sourceTextArea.setText("No source line information for this bug");
                }
            }
            catch (IOException e) {
                this.sourceTextArea.setText(new StringBuffer().append("Could not find source: ").append(e.getMessage()).toString());
                this.logger.logMessage(1, e.getMessage());
            }
            this.currentSourceLineAnnotation = srcLine;
        }
        this.showBugInfo(selected);
        this.synchBugAnnotation(selected);
        this.currentBugInstance = selected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean viewSource(Project project, AnalysisRun analysisRun, final SourceLineAnnotation srcLine) throws IOException {
        this.sourceTextArea.setText("");
        if (srcLine == null) {
            return false;
        }
        this.sourceFinder.setSourceBaseList(project.getSourceDirList());
        String sourceFile = srcLine.getSourceFile();
        if (sourceFile == null || sourceFile.equals("<Unknown>")) {
            this.logger.logMessage(1, new StringBuffer().append("No source file for class ").append(srcLine.getClassName()).toString());
            return false;
        }
        InputStream in = this.sourceFinder.openSource(srcLine.getPackageName(), sourceFile);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                this.sourceTextArea.append(new StringBuffer().append(line).append("\n").toString());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (srcLine.isUnknown()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    FindBugsFrame.this.sourceTextAreaScrollPane.getViewport().setViewPosition(new Point(0, 0));
                }
            });
            return true;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    int startLine = srcLine.getStartLine() - 1;
                    int endLine = srcLine.getEndLine();
                    JViewport viewport = FindBugsFrame.this.sourceTextAreaScrollPane.getViewport();
                    Rectangle viewportRect = viewport.getViewRect();
                    int height = FindBugsFrame.this.sourceTextArea.getHeight();
                    int topRow = FindBugsFrame.this.sourceTextArea.getLineOfOffset(FindBugsFrame.this.sourceTextArea.viewToModel(viewportRect.getLocation()));
                    int bottomRow = FindBugsFrame.this.sourceTextArea.getLineOfOffset(FindBugsFrame.this.sourceTextArea.viewToModel(new Point(viewportRect.x, viewportRect.y + viewportRect.height - 1)));
                    int numRowsVisible = bottomRow - topRow;
                    int viewLine = Math.max(startLine - (numRowsVisible > 0 ? numRowsVisible / 2 : 0), 0);
                    int viewBegin = FindBugsFrame.this.sourceTextArea.getLineStartOffset(viewLine);
                    Rectangle viewRect = FindBugsFrame.this.sourceTextArea.modelToView(viewBegin);
                    viewport.setViewPosition(new Point(viewRect.x, viewRect.y));
                    int selBegin = FindBugsFrame.this.sourceTextArea.getLineStartOffset(startLine);
                    int selEnd = FindBugsFrame.this.sourceTextArea.getLineStartOffset(endLine);
                    FindBugsFrame.this.sourceTextArea.select(selBegin, selEnd);
                    FindBugsFrame.this.sourceTextArea.getCaret().setSelectionVisible(true);
                }
                catch (BadLocationException e) {
                    FindBugsFrame.this.logger.logMessage(2, e.toString());
                }
            }
        });
        return true;
    }

    private void showBugInfo(BugInstance bugInstance) {
        String bugDetailsKey = bugInstance.getType();
        if (bugDetailsKey.equals(this.currentBugDetailsKey)) {
            return;
        }
        String html = I18N.instance().getDetailHTML(bugDetailsKey);
        this.bugDescriptionEditorPane.setContentType("text/html");
        this.bugDescriptionEditorPane.setText(html);
        this.currentBugDetailsKey = bugDetailsKey;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FindBugsFrame.this.bugDescriptionScrollPane.getViewport().setViewPosition(new Point(0, 0));
            }
        });
    }

    private void synchBugAnnotation(BugInstance selected) {
        if (this.currentBugInstance != null) {
            String text = this.annotationTextArea.getText();
            this.currentBugInstance.setAnnotationText(text);
        }
        this.annotationTextArea.setText(selected.getAnnotationText());
    }

    private void exitFindBugs() {
        System.exit(0);
    }

    private JFileChooser createFileChooser() {
        return new JFileChooser(this.currentDirectory);
    }

    private int chooseFile(JFileChooser dialog, String dialogTitle) {
        int outcome = dialog.showDialog(this, dialogTitle);
        return this.updateCurrentDirectoryFromDialog(dialog, outcome);
    }

    private int chooseFileToOpen(JFileChooser dialog) {
        int outcome = dialog.showOpenDialog(this);
        return this.updateCurrentDirectoryFromDialog(dialog, outcome);
    }

    private int updateCurrentDirectoryFromDialog(JFileChooser dialog, int outcome) {
        if (outcome != 1) {
            File selectedFile = dialog.getSelectedFile();
            this.currentDirectory = selectedFile.getParentFile();
        }
        return outcome;
    }

    public ConsoleLogger getLogger() {
        return this.logger;
    }

    public void error(String message) {
        JOptionPane.showMessageDialog(this, message, "Error", 0);
    }

    public void writeToConsole(String message) {
        this.consoleMessageArea.append(message);
        this.consoleMessageArea.append("\n");
    }

    public static void main(String[] args) {
        Project project = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-debug")) {
                System.out.println("Setting findbugs.debug=true");
                System.setProperty("findbugs.debug", "true");
                continue;
            }
            if (arg.startsWith("-look:")) {
                arg = arg.substring(6);
                String theme = null;
                if (arg.equals("plastic")) {
                    theme = "com.jgoodies.plaf.plastic.PlasticXPLookAndFeel";
                } else if (arg.equals("gtk")) {
                    theme = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
                } else if (arg.equals("native")) {
                    theme = UIManager.getSystemLookAndFeelClassName();
                } else {
                    System.err.println(new StringBuffer().append("Style '").append(arg).append("' not supported").toString());
                }
                if (theme == null) continue;
                try {
                    UIManager.setLookAndFeel(theme);
                }
                catch (Exception e) {
                    System.err.println(new StringBuffer().append("Couldn't load ").append(arg).append(" look and feel: ").append(e.toString()).toString());
                }
                continue;
            }
            if (!arg.equals("-project")) continue;
            if (++i == args.length) {
                throw new IllegalArgumentException(new StringBuffer().append(arg).append(" option requires argument").toString());
            }
            String projectFile = new File(args[i]).getAbsolutePath();
            try {
                project = new Project(projectFile);
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(projectFile));
                project.read((InputStream)in);
                ((InputStream)in).close();
                continue;
            }
            catch (IOException e) {
                System.err.println(new StringBuffer().append("Couldn't load project: ").append(e.getMessage()).toString());
            }
        }
        DetectorFactoryCollection.instance();
        FindBugsFrame frame = new FindBugsFrame();
        if (project != null) {
            frame.setProject(project);
        }
        frame.setSize(800, 600);
        frame.show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        archiveExtensionSet.add(".jar");
        archiveExtensionSet.add(".zip");
        archiveExtensionSet.add(".ear");
        archiveExtensionSet.add(".war");
        archiveAndDirectoryFilter = new ArchiveAndDirectoryFilter();
        GROUP_BY_ORDER_LIST = new String[]{GROUP_BY_CLASS, GROUP_BY_PACKAGE, GROUP_BY_BUG_TYPE};
        BUG_COUNT = Boolean.getBoolean("findbugs.gui.bugCount");
    }

    private static class ArchiveAndDirectoryFilter
    extends FileFilter {
        private ArchiveAndDirectoryFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String fileName = file.getName();
            int dot = fileName.lastIndexOf(46);
            if (dot < 0) {
                return false;
            }
            String extension = fileName.substring(dot);
            return archiveExtensionSet.contains(extension);
        }

        public String getDescription() {
            return "Java archives (*.jar,*.zip,*.ear,*.war)";
        }
    }

    private static class XMLFileFilter
    extends FileFilter {
        private XMLFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".xml");
        }

        public String getDescription() {
            return "XML saved bug files";
        }
    }

    private static class AuxClasspathEntryFileFilter
    extends FileFilter {
        private AuxClasspathEntryFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".jar");
        }

        public String getDescription() {
            return "Jar files and directories";
        }
    }

    private static class ProjectFileFilter
    extends FileFilter {
        private ProjectFileFilter() {
        }

        public boolean accept(File file) {
            return file.isDirectory() || file.getName().endsWith(".fb");
        }

        public String getDescription() {
            return "FindBugs projects (*.fb)";
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByTypeComparator
    implements Comparator<BugInstance> {
        private BugInstanceByTypeComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstanceTypeComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo((Object)b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByPackageComparator
    implements Comparator<BugInstance> {
        private BugInstanceByPackageComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstancePackageComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo((Object)b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceByClassComparator
    implements Comparator<BugInstance> {
        private BugInstanceByClassComparator() {
        }

        @Override
        public int compare(BugInstance a, BugInstance b) {
            int cmp = bugInstanceClassComparator.compare(a, b);
            if (cmp != 0) {
                return cmp;
            }
            return a.compareTo((Object)b);
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceTypeComparator
    implements Comparator<BugInstance> {
        private BugInstanceTypeComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            String lhsString = lhs.toString();
            String rhsString = rhs.toString();
            return lhsString.substring(0, lhsString.indexOf(58)).compareTo(rhsString.substring(0, rhsString.indexOf(58)));
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstancePackageComparator
    implements Comparator<BugInstance> {
        private BugInstancePackageComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            return lhs.getPrimaryClass().getPackageName().compareTo(rhs.getPrimaryClass().getPackageName());
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BugInstanceClassComparator
    implements Comparator<BugInstance> {
        private BugInstanceClassComparator() {
        }

        @Override
        public int compare(BugInstance lhs, BugInstance rhs) {
            return lhs.getPrimaryClass().compareTo((BugAnnotation)rhs.getPrimaryClass());
        }

        @Override
        public /* synthetic */ int compare(Object x0, Object x1) {
            return this.compare((BugInstance)x0, (BugInstance)x1);
        }
    }

    private class BugTreeNode
    extends DefaultMutableTreeNode {
        private int count;

        public BugTreeNode(BugInstance bugInstance) {
            super(bugInstance);
            this.count = -1;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public String toString() {
            try {
                BugInstance bugInstance = (BugInstance)this.getUserObject();
                StringBuffer result = new StringBuffer();
                if (this.count >= 0) {
                    result.append(this.count);
                    result.append(": ");
                }
                if (bugInstance.isExperimental()) {
                    result.append("EXP: ");
                }
                result.append(FindBugsFrame.this.fullDescriptionsItem.isSelected() ? bugInstance.getMessage() : bugInstance.toString());
                return result.toString();
            }
            catch (Exception e) {
                return "Error formatting message for bug: " + e.toString();
            }
        }
    }

    private static class BugCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon bugGroupIcon;
        private ImageIcon packageIcon;
        private ImageIcon bugIcon;
        private ImageIcon classIcon;
        private ImageIcon methodIcon;
        private ImageIcon fieldIcon;
        private ImageIcon sourceFileIcon;
        private Object value;

        public BugCellRenderer() {
            ClassLoader classLoader = this.getClass().getClassLoader();
            this.bugGroupIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug.png"));
            this.packageIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/package.png"));
            this.bugIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/bug2.png"));
            this.classIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/class.png"));
            this.methodIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/method.png"));
            this.fieldIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/field.png"));
            this.sourceFileIcon = new ImageIcon(classLoader.getResource("edu/umd/cs/findbugs/gui/sourcefile.png"));
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object obj;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            this.value = obj = node.getUserObject();
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (obj instanceof BugInstance) {
                this.setIcon(this.bugIcon);
            } else if (obj instanceof ClassAnnotation) {
                this.setIcon(this.classIcon);
            } else if (obj instanceof MethodAnnotation) {
                this.setIcon(this.methodIcon);
            } else if (obj instanceof FieldAnnotation) {
                this.setIcon(this.fieldIcon);
            } else if (obj instanceof SourceLineAnnotation) {
                this.setIcon(this.sourceFileIcon);
            } else if (obj instanceof BugInstanceGroup) {
                BugInstanceGroup groupNode = (BugInstanceGroup)obj;
                String groupType = groupNode.getGroupType();
                if (groupType == FindBugsFrame.GROUP_BY_CLASS) {
                    this.setIcon(this.classIcon);
                } else if (groupType == FindBugsFrame.GROUP_BY_PACKAGE) {
                    this.setIcon(this.packageIcon);
                } else if (groupType == FindBugsFrame.GROUP_BY_BUG_TYPE) {
                    this.setIcon(this.bugGroupIcon);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public Color getTextNonSelectionColor() {
            return this.getCellTextColor();
        }

        private Color getCellTextColor() {
            Color color = Color.BLACK;
            if (this.value instanceof BugInstance) {
                BugInstance bugInstance = (BugInstance)this.value;
                switch (bugInstance.getPriority()) {
                    case 3: {
                        color = LOW_PRIORITY_COLOR;
                        break;
                    }
                    case 2: {
                        color = NORMAL_PRIORITY_COLOR;
                        break;
                    }
                    case 1: {
                        color = HIGH_PRIORITY_COLOR;
                    }
                }
            }
            return color;
        }
    }
}

