/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.gui.L10N;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.border.BevelBorder;

public class AnalysisErrorDialog
extends JDialog {
    private StringBuffer buf = new StringBuffer();
    private JMenuBar analysisMenuBar;
    private JMenuItem copyMenuItem;
    private JMenu editMenu;
    private JLabel errorLabel;
    private JScrollPane errorMessageScrollPane;
    private JTextPane errorMessageTextArea;
    private JSeparator jSeparator1;
    private JLabel leftSpacer;
    private JButton okButton;
    private JLabel rightSpacer;
    private JMenuItem selectAllMenuItem;

    public AnalysisErrorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    private void initComponents() {
        this.errorLabel = new JLabel();
        this.errorMessageScrollPane = new JScrollPane();
        this.errorMessageTextArea = new JTextPane();
        this.jSeparator1 = new JSeparator();
        this.leftSpacer = new JLabel();
        this.rightSpacer = new JLabel();
        this.okButton = new JButton();
        this.analysisMenuBar = new JMenuBar();
        this.editMenu = new JMenu();
        this.selectAllMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Analysis Errors");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                AnalysisErrorDialog.this.closeDialog(evt);
            }
        });
        this.errorLabel.setFont(new Font("Dialog", 0, 12));
        this.errorLabel.setText("Errors occured during the analysis:");
        this.errorLabel.setText(L10N.getLocalString("dlg.analysiserror_lbl", "Errors occurred during analysis:"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 3, 0);
        this.getContentPane().add((Component)this.errorLabel, gridBagConstraints);
        this.errorMessageTextArea.setBorder(new BevelBorder(1));
        this.errorMessageTextArea.setEditable(false);
        this.errorMessageScrollPane.setViewportView(this.errorMessageTextArea);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 4, 6);
        this.getContentPane().add((Component)this.errorMessageScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.leftSpacer, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.weightx = 0.5;
        this.getContentPane().add((Component)this.rightSpacer, gridBagConstraints);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setText(L10N.getLocalString("dlg.ok_btn", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisErrorDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.analysisMenuBar.setFont(new Font("Dialog", 0, 12));
        this.editMenu.setText("Edit");
        this.editMenu.setFont(new Font("Dialog", 0, 12));
        this.editMenu.setText(L10N.getLocalString("menu.edit_menu", "Edit"));
        this.editMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisErrorDialog.this.editMenuActionPerformed(evt);
            }
        });
        this.selectAllMenuItem.setFont(new Font("Dialog", 0, 12));
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.setText(L10N.getLocalString("menu.selectall_item", "Select All"));
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisErrorDialog.this.selectAllItemActionListener(evt);
            }
        });
        this.editMenu.add(this.selectAllMenuItem);
        this.copyMenuItem.setFont(new Font("Dialog", 0, 12));
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setText(L10N.getLocalString("menu.copy_item", "Copy"));
        this.copyMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                AnalysisErrorDialog.this.copyMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.copyMenuItem);
        this.analysisMenuBar.add(this.editMenu);
        this.setJMenuBar(this.analysisMenuBar);
        this.pack();
    }

    private void copyMenuItemActionPerformed(ActionEvent evt) {
        this.errorMessageTextArea.copy();
    }

    private void selectAllItemActionListener(ActionEvent evt) {
        this.errorMessageTextArea.selectAll();
    }

    private void editMenuActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    public void addLine(String line) {
        this.buf.append(line);
        this.buf.append('\n');
    }

    public void finish() {
        this.errorMessageTextArea.setText(this.buf.toString());
    }

    public static void main(String[] args) {
        new AnalysisErrorDialog((Frame)new JFrame(), true).setVisible(true);
    }
}

