/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.gui.DefaultSortedTableModel;
import edu.umd.cs.findbugs.gui.L10N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.BevelBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class ConfigureDetectorsDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final int SPEED_COLUMN = 1;
    private static final int ENABLED_COLUMN = 2;
    private JButton cancelButton;
    private JEditorPane detectorDescription;
    private JScrollPane detectorDescriptionScrollPane;
    private JTable detectorTable;
    private JScrollPane detectorTableScrollPane;
    private JSeparator jSeparator1;
    private JButton okButton;
    private JButton restoreDefaultsButton;
    private JLabel spacer;
    private ArrayList<DetectorFactory> factoryList = new ArrayList();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public ConfigureDetectorsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.postInitComponents();
    }

    private void initComponents() {
        this.detectorTableScrollPane = new JScrollPane();
        this.detectorTable = new JTable();
        this.detectorDescriptionScrollPane = new JScrollPane();
        this.detectorDescription = new JEditorPane();
        this.jSeparator1 = new JSeparator();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.spacer = new JLabel();
        this.restoreDefaultsButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Configure Detectors");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ConfigureDetectorsDialog.this.closeDialog(evt);
            }

            public void windowOpened(WindowEvent evt) {
                ConfigureDetectorsDialog.this.formWindowOpened(evt);
            }
        });
        this.detectorTableScrollPane.setBorder(new BevelBorder(1));
        this.detectorTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Bug Detector", "Speed", "Enabled"}){
            private static final long serialVersionUID = 1L;
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ConfigureDetectorsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = ConfigureDetectorsDialog.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConfigureDetectorsDialog.class$("java.lang.Boolean")) : class$java$lang$Boolean};
                this.canEdit = new boolean[]{false, false, true};
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.populateTable();
        this.detectorTable.getColumnModel().getColumn(2).setMaxWidth(60);
        this.detectorTable.getColumnModel().getColumn(1).setMaxWidth(60);
        this.detectorTable.setSelectionMode(0);
        DefaultTableModel m = (DefaultTableModel)this.detectorTable.getModel();
        m.setColumnIdentifiers(new String[]{L10N.getLocalString("dlg.bugdetector_lbl", "Bug Detector"), L10N.getLocalString("dlg.speed_lbl", "Speed"), L10N.getLocalString("dlg.enabled_lbl", "Enabled")});
        DefaultSortedTableModel sortedModel = new DefaultSortedTableModel(m, this.detectorTable.getTableHeader());
        this.detectorTable.setModel(sortedModel);
        this.detectorTableScrollPane.setViewportView(this.detectorTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.insets = new Insets(6, 6, 2, 6);
        this.getContentPane().add((Component)this.detectorTableScrollPane, gridBagConstraints);
        this.detectorDescriptionScrollPane.setBorder(new BevelBorder(1));
        this.detectorDescriptionScrollPane.setPreferredSize(new Dimension(110, 120));
        this.detectorDescriptionScrollPane.setViewportView(this.detectorDescription);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 0.3;
        gridBagConstraints.insets = new Insets(2, 6, 2, 6);
        this.getContentPane().add((Component)this.detectorDescriptionScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.okButton.setMnemonic('O');
        this.okButton.setText("OK");
        this.okButton.setText(L10N.getLocalString("dlg.ok_btn", "OK"));
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsDialog.this.okButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 4, 2);
        this.getContentPane().add((Component)this.okButton, gridBagConstraints);
        this.cancelButton.setMnemonic('C');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setText(L10N.getLocalString("dlg.cancel_btn", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 2, 4, 6);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.spacer, gridBagConstraints);
        this.restoreDefaultsButton.setText("Restore Defaults");
        this.restoreDefaultsButton.setHorizontalAlignment(2);
        this.restoreDefaultsButton.setText(L10N.getLocalString("dlg.restoredefaults_btn", "Restore Defaults"));
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ConfigureDetectorsDialog.this.restoreDefaultsButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 6, 4, 0);
        this.getContentPane().add((Component)this.restoreDefaultsButton, gridBagConstraints);
        this.pack();
    }

    private void formWindowOpened(WindowEvent evt) {
        this.setTitle(L10N.getLocalString("dlg.configuredetectors_ttl", "Configure Detectors"));
    }

    private void restoreDefaultsButtonActionPerformed(ActionEvent evt) {
        Iterator i = DetectorFactoryCollection.instance().factoryIterator();
        DefaultSortedTableModel sorter = (DefaultSortedTableModel)this.detectorTable.getModel();
        TableModel model = sorter.getBaseTableModel();
        int row = 0;
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            if (factory.isHidden()) continue;
            model.setValueAt(factory.isDefaultEnabled() ? Boolean.TRUE : Boolean.FALSE, row++, 2);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.closeDialog();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        int num = this.factoryList.size();
        DefaultSortedTableModel sorter = (DefaultSortedTableModel)this.detectorTable.getModel();
        TableModel model = sorter.getBaseTableModel();
        for (int i = 0; i < num; ++i) {
            DetectorFactory factory = this.factoryList.get(i);
            Boolean enabled = (Boolean)model.getValueAt(i, 2);
            UserPreferences.getUserPreferences().enableDetector(factory, enabled.booleanValue());
        }
        this.closeDialog();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void postInitComponents() {
        ListSelectionModel rowSM = this.detectorTable.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int selectedRow = lsm.getMinSelectionIndex();
                    DefaultSortedTableModel sorter = (DefaultSortedTableModel)ConfigureDetectorsDialog.this.detectorTable.getModel();
                    ConfigureDetectorsDialog.this.viewDetectorDetails((DetectorFactory)ConfigureDetectorsDialog.this.factoryList.get(sorter.getBaseModelIndex(selectedRow)));
                }
            }
        });
    }

    private void viewDetectorDetails(DetectorFactory factory) {
        String detailHTML = factory.getDetailHTML();
        if (detailHTML == null) {
            this.detectorDescription.setText("");
        } else {
            this.detectorDescription.setContentType("text/html");
            this.detectorDescription.setText(detailHTML);
            StringBuffer toolTip = new StringBuffer(100);
            toolTip.append("<html><body><b>");
            toolTip.append(factory.getFullName());
            toolTip.append("</b><br><br><table border='1' width='100%'><tr><th>");
            toolTip.append(L10N.getLocalString("msg.bugpatternsreported_txt", "Bug Patterns Reported"));
            toolTip.append("</th></tr>");
            Collection patterns = factory.getReportedBugPatterns();
            Iterator i$ = patterns.iterator();
            while (i$.hasNext()) {
                BugPattern pattern = (BugPattern)i$.next();
                toolTip.append("<tr><td align='center'>");
                toolTip.append("[");
                toolTip.append(pattern.getAbbrev());
                toolTip.append("] ");
                toolTip.append(pattern.getType());
                toolTip.append("</td></tr>");
            }
            toolTip.append("</body></html>");
            this.detectorDescription.setToolTipText(toolTip.toString());
        }
    }

    private void populateTable() {
        Iterator i = DetectorFactoryCollection.instance().factoryIterator();
        while (i.hasNext()) {
            DetectorFactory factory = (DetectorFactory)i.next();
            if (factory.isHidden()) continue;
            DefaultTableModel model = (DefaultTableModel)this.detectorTable.getModel();
            model.addRow(new Object[]{factory.getShortName(), factory.getSpeed(), UserPreferences.getUserPreferences().isDetectorEnabled(factory) ? Boolean.TRUE : Boolean.FALSE});
            this.factoryList.add(factory);
        }
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] args) {
        new ConfigureDetectorsDialog((Frame)new JFrame(), true).setVisible(true);
    }
}

