/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JTextArea;

public class LineNumberer
extends JComponent {
    public static final int PAD = 10;
    public static final String PROTOTYPE = "00000";
    private JTextArea textArea;
    private FontMetrics fm;
    private int lnWidth;

    public LineNumberer(JTextArea ta) {
        this.setFont(ta.getFont());
        this.textArea = ta;
        this.setForeground(Color.BLUE);
        this.fm = this.getFontMetrics(ta.getFont());
        this.lnWidth = this.fm.stringWidth(PROTOTYPE);
        this.setWidths();
    }

    public void setFont(Font font) {
    }

    private void setWidths() {
        int width = this.fm.stringWidth(PROTOTYPE);
        Dimension d = this.getPreferredSize();
        d.setSize(10 + width, Integer.MAX_VALUE);
        this.setPreferredSize(d);
        this.setSize(d);
    }

    public void paintComponent(Graphics g) {
        int lineHeight = this.fm.getHeight();
        int startOffset = this.textArea.getInsets().top + this.fm.getAscent();
        Rectangle clip = g.getClipBounds();
        g.setColor(this.getBackground());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(this.getForeground());
        int beginLineNumber = clip.y / lineHeight + 1;
        int endLineNumber = beginLineNumber + clip.height / lineHeight;
        int y = clip.y / lineHeight * lineHeight + startOffset;
        for (int i = beginLineNumber; i <= endLineNumber; ++i) {
            String ln = String.valueOf(i);
            int width = this.fm.stringWidth(ln);
            int rowWidth = this.getSize().width;
            g.drawString(ln, rowWidth - width - 10, y);
            y += lineHeight;
        }
    }
}

