/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.geometry.Acceleration2d;
import gay.zharel.hermes.geometry.DualNum;
import gay.zharel.hermes.geometry.DualParameter;
import gay.zharel.hermes.geometry.Matrices;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2d;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.ejml.simple.ConstMatrix;
import org.ejml.simple.SimpleBase;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a<\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001aH\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0000\u001a6\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\t2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0012\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0017\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018H\u0000\u001a$\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0019\"\b\b\u0000\u0010\u0013*\u00020\u0014*\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u001bH\u0000\u001a\u001c\u0010\u001c\u001a\u00020\u0007\"\b\b\u0000\u0010\u0013*\u00020\u0014*\b\u0012\u0004\u0012\u0002H\u00130\u0012H\u0000\u00a8\u0006\u001d"}, d2={"solveDARE", "Lorg/ejml/simple/SimpleMatrix;", "Ad", "Bd", "Q", "R", "maxIter", "", "epsilon", "", "computeLQRGain", "Lkotlin/Pair;", "discretizeSystem", "A", "B", "dt", "taylorTerms", "concat", "Lgay/zharel/hermes/geometry/Twist2dDual;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "Lgay/zharel/hermes/geometry/Twist2d;", "other", "Lgay/zharel/hermes/geometry/Vector2dDual;", "Lgay/zharel/hermes/geometry/Vector2d;", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "Lgay/zharel/hermes/geometry/Acceleration2d;", "size", "core"})
public final class LQRControllerKt {
    @NotNull
    public static final SimpleMatrix solveDARE(@NotNull SimpleMatrix Ad, @NotNull SimpleMatrix Bd, @NotNull SimpleMatrix Q, @NotNull SimpleMatrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        SimpleMatrix A_K = (SimpleMatrix)Ad.copy();
        SimpleBase simpleBase = R.solve((ConstMatrix)Bd.transpose());
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"solve(...)");
        SimpleMatrix G_K = Matrices.times(Bd, (SimpleMatrix)simpleBase);
        SimpleMatrix H_K1 = (SimpleMatrix)Q.copy();
        SimpleMatrix H_K = null;
        int i = 0;
        do {
            SimpleBase simpleBase2 = H_K1.copy();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase2, (String)"copy(...)");
            H_K = (SimpleMatrix)simpleBase2;
            SimpleMatrix W = (SimpleMatrix)SimpleMatrix.identity((int)H_K.getNumRows()).plus((ConstMatrix)Matrices.times(G_K, H_K));
            SimpleMatrix v1 = (SimpleMatrix)W.solve((ConstMatrix)A_K);
            SimpleMatrix v2 = (SimpleMatrix)((SimpleMatrix)W.solve((ConstMatrix)G_K.transpose())).transpose();
            SimpleMatrix simpleMatrix = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix);
            Intrinsics.checkNotNull((Object)v2);
            SimpleMatrix simpleMatrix2 = Matrices.times(simpleMatrix, v2);
            SimpleBase simpleBase3 = A_K.transpose();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase3, (String)"transpose(...)");
            SimpleBase simpleBase4 = G_K.plus((ConstMatrix)Matrices.times(simpleMatrix2, (SimpleMatrix)simpleBase3));
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase4, (String)"plus(...)");
            G_K = (SimpleMatrix)simpleBase4;
            SimpleBase simpleBase5 = v1.transpose();
            Intrinsics.checkNotNullExpressionValue((Object)simpleBase5, (String)"transpose(...)");
            SimpleMatrix simpleMatrix3 = Matrices.times((SimpleMatrix)simpleBase5, H_K);
            SimpleMatrix simpleMatrix4 = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix4);
            H_K1 = (SimpleMatrix)H_K1.plus((ConstMatrix)Matrices.times(simpleMatrix3, simpleMatrix4));
            simpleMatrix4 = A_K;
            Intrinsics.checkNotNull((Object)simpleMatrix4);
            Intrinsics.checkNotNull((Object)v1);
            A_K = Matrices.times(simpleMatrix4, v1);
        } while (((SimpleMatrix)H_K1.minus((ConstMatrix)H_K)).normF() > epsilon * H_K1.normF() && (maxIter < 0 || i++ < maxIter));
        SimpleMatrix simpleMatrix = H_K1;
        Intrinsics.checkNotNull((Object)simpleMatrix);
        return simpleMatrix;
    }

    public static /* synthetic */ SimpleMatrix solveDARE$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, SimpleMatrix simpleMatrix3, SimpleMatrix simpleMatrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.solveDARE(simpleMatrix, simpleMatrix2, simpleMatrix3, simpleMatrix4, n, d);
    }

    @NotNull
    public static final Pair<SimpleMatrix, SimpleMatrix> computeLQRGain(@NotNull SimpleMatrix Ad, @NotNull SimpleMatrix Bd, @NotNull SimpleMatrix Q, @NotNull SimpleMatrix R, int maxIter, double epsilon) {
        Intrinsics.checkNotNullParameter((Object)Ad, (String)"Ad");
        Intrinsics.checkNotNullParameter((Object)Bd, (String)"Bd");
        Intrinsics.checkNotNullParameter((Object)Q, (String)"Q");
        Intrinsics.checkNotNullParameter((Object)R, (String)"R");
        SimpleMatrix X = LQRControllerKt.solveDARE(Ad, Bd, Q, R, maxIter, epsilon);
        SimpleBase simpleBase = Bd.transpose();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"transpose(...)");
        SimpleMatrix btx = Matrices.times((SimpleMatrix)simpleBase, X);
        SimpleMatrix btxb = Matrices.times(btx, Bd);
        SimpleBase simpleBase2 = ((SimpleMatrix)R.plus((ConstMatrix)btxb)).invert();
        Intrinsics.checkNotNullExpressionValue((Object)simpleBase2, (String)"invert(...)");
        SimpleMatrix K = Matrices.times(Matrices.times((SimpleMatrix)simpleBase2, btx), Ad);
        return TuplesKt.to((Object)X, (Object)K);
    }

    public static /* synthetic */ Pair computeLQRGain$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, SimpleMatrix simpleMatrix3, SimpleMatrix simpleMatrix4, int n, double d, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = -1;
        }
        if ((n2 & 0x20) != 0) {
            d = 1.0E-6;
        }
        return LQRControllerKt.computeLQRGain(simpleMatrix, simpleMatrix2, simpleMatrix3, simpleMatrix4, n, d);
    }

    @NotNull
    public static final Pair<SimpleMatrix, SimpleMatrix> discretizeSystem(@NotNull SimpleMatrix A, @NotNull SimpleMatrix B, double dt, int taylorTerms) {
        Intrinsics.checkNotNullParameter((Object)A, (String)"A");
        Intrinsics.checkNotNullParameter((Object)B, (String)"B");
        int n = A.getNumRows();
        SimpleMatrix Ad = SimpleMatrix.identity((int)n);
        SimpleMatrix simpleMatrix = SimpleMatrix.identity((int)n);
        Intrinsics.checkNotNullExpressionValue((Object)simpleMatrix, (String)"identity(...)");
        SimpleMatrix Bd_integral = Matrices.times(simpleMatrix, dt);
        SimpleMatrix APowerDt = Matrices.times(A, dt);
        double dtPower = dt;
        double factorial = 1.0;
        int i = 1;
        if (i <= taylorTerms) {
            while (true) {
                Ad = (SimpleMatrix)Ad.plus((ConstMatrix)Matrices.times(APowerDt, 1.0 / factorial));
                dtPower *= dt;
                factorial *= (double)(i + 1);
                SimpleBase simpleBase = Bd_integral.plus((ConstMatrix)Matrices.times(APowerDt, dt / (double)(i + 1)));
                Intrinsics.checkNotNullExpressionValue((Object)simpleBase, (String)"plus(...)");
                Bd_integral = (SimpleMatrix)simpleBase;
                APowerDt = Matrices.times(APowerDt, Matrices.times(A, dt));
                factorial *= (double)(i + 1);
                if (i == taylorTerms) break;
                ++i;
            }
        }
        SimpleMatrix Bd = Matrices.times(Bd_integral, B);
        return new Pair((Object)Ad, (Object)Bd);
    }

    public static /* synthetic */ Pair discretizeSystem$default(SimpleMatrix simpleMatrix, SimpleMatrix simpleMatrix2, double d, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 10;
        }
        return LQRControllerKt.discretizeSystem(simpleMatrix, simpleMatrix2, d, n);
    }

    @NotNull
    public static final <Param extends DualParameter> Twist2dDual<Param> concat(@NotNull Twist2d $this$concat, @NotNull Twist2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angle, other.angle};
        return new Twist2dDual<Param>(LQRControllerKt.concat($this$concat.line, other.line), new DualNum(dArray));
    }

    @NotNull
    public static final <Param extends DualParameter> Vector2dDual<Param> concat(@NotNull Vector2d $this$concat, @NotNull Vector2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.x, other.x};
        DualNum dualNum = new DualNum(dArray);
        dArray = new double[]{$this$concat.y, other.y};
        return new Vector2dDual(dualNum, new DualNum(dArray));
    }

    @NotNull
    public static final <Param extends DualParameter> PoseVelocity2dDual<Param> concat(@NotNull PoseVelocity2d $this$concat, @NotNull Acceleration2d other) {
        Intrinsics.checkNotNullParameter((Object)$this$concat, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double[] dArray = new double[]{$this$concat.angVel, other.angAcc};
        return new PoseVelocity2dDual<Param>(LQRControllerKt.concat($this$concat.linearVel, other.linearAcc), new DualNum(dArray));
    }

    public static final <Param extends DualParameter> int size(@NotNull Twist2dDual<Param> $this$size) {
        Intrinsics.checkNotNullParameter($this$size, (String)"<this>");
        return $this$size.angle.size();
    }
}

