/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.RobotPosVelController;
import gay.zharel.hermes.geometry.Arclength;
import gay.zharel.hermes.geometry.DualNum;
import gay.zharel.hermes.geometry.Math;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Rotation2d;
import gay.zharel.hermes.geometry.Time;
import gay.zharel.hermes.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J,\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J0\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u000e\u001a\u00020\u000fJ0\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00132\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00140\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0003R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lgay/zharel/hermes/control/RamseteController;", "Lgay/zharel/hermes/control/RobotPosVelController;", "trackWidth", "", "zeta", "bBar", "<init>", "(DDD)V", "b", "compute", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "Lgay/zharel/hermes/geometry/Time;", "targetPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "actualPose", "Lgay/zharel/hermes/geometry/Pose2d;", "actualVelActual", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "s", "Lgay/zharel/hermes/geometry/DualNum;", "Lgay/zharel/hermes/geometry/Arclength;", "computeOld", "sinc", "x", "core"})
public final class RamseteController
implements RobotPosVelController {
    @JvmField
    public final double trackWidth;
    @JvmField
    public final double zeta;
    @JvmField
    public final double bBar;
    @JvmField
    public final double b;

    @JvmOverloads
    public RamseteController(double trackWidth, double zeta, double bBar) {
        this.trackWidth = trackWidth;
        this.zeta = zeta;
        this.bBar = bBar;
        this.b = this.bBar / (this.trackWidth * this.trackWidth);
    }

    public /* synthetic */ RamseteController(double d, double d2, double d3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            d2 = 0.7;
        }
        if ((n & 4) != 0) {
            d3 = 2.0;
        }
        this(d, d2, d3);
    }

    @Override
    @NotNull
    public PoseVelocity2dDual<Time> compute(@NotNull Pose2dDual<Time> targetPose, @NotNull Pose2d actualPose, @NotNull PoseVelocity2d actualVelActual) {
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Intrinsics.checkNotNullParameter((Object)actualVelActual, (String)"actualVelActual");
        double omegaRef = targetPose.heading.velocity().get(0);
        double vRef = targetPose.velocity().value().linearVel.norm() * java.lang.Math.signum(actualVelActual.angVel);
        double k = 2.0 * this.zeta * java.lang.Math.sqrt(omegaRef * omegaRef + this.b * vRef * vRef);
        Pose2d error = targetPose.value().minusExp(actualPose);
        return PoseVelocity2dDual.Companion.constant(new PoseVelocity2d(new Vector2d(vRef * error.heading.real + k * error.position.x, 0.0), omegaRef + k * error.heading.log() + this.b * vRef * this.sinc(error.heading.log()) * error.position.y), 2);
    }

    @NotNull
    public final PoseVelocity2dDual<Time> compute(@NotNull DualNum<Time> s, @NotNull Pose2dDual<Arclength> targetPose, @NotNull Pose2d actualPose) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Rotation2d targetHeading = targetPose.heading.value();
        Rotation2d tangentHeading = targetPose.position.drop(1).value().angleCast();
        double dir = tangentHeading.real * targetHeading.real + tangentHeading.imag * targetHeading.imag;
        double vRef = dir * s.get(1);
        return this.compute(targetPose.reparam(s), actualPose, new PoseVelocity2d(new Vector2d(vRef, 0.0), dir));
    }

    @NotNull
    public final PoseVelocity2dDual<Time> computeOld(@NotNull DualNum<Time> s, @NotNull Pose2dDual<Arclength> targetPose, @NotNull Pose2d actualPose) {
        Intrinsics.checkNotNullParameter(s, (String)"s");
        Intrinsics.checkNotNullParameter(targetPose, (String)"targetPose");
        Intrinsics.checkNotNullParameter((Object)actualPose, (String)"actualPose");
        Rotation2d targetHeading = targetPose.heading.value();
        Rotation2d tangentHeading = targetPose.position.drop(1).value().angleCast();
        double dir = tangentHeading.real * targetHeading.real + tangentHeading.imag * targetHeading.imag;
        double vRef = dir * s.get(1);
        double omegaRef = targetPose.reparam(s).heading.velocity().get(0);
        double k = 2.0 * this.zeta * java.lang.Math.sqrt(omegaRef * omegaRef + this.b * vRef * vRef);
        Pose2d error = targetPose.value().minusExp(actualPose);
        return PoseVelocity2dDual.Companion.constant(new PoseVelocity2d(new Vector2d(vRef * error.heading.real + k * error.position.x, 0.0), omegaRef + k * error.heading.log() + this.b * vRef * this.sinc(error.heading.log()) * error.position.y), 2);
    }

    public final double sinc(double x) {
        double u = x + Math.snz(x);
        return java.lang.Math.sin(u) / u;
    }

    @JvmOverloads
    public RamseteController(double trackWidth, double zeta) {
        this(trackWidth, zeta, 0.0, 4, null);
    }

    @JvmOverloads
    public RamseteController(double trackWidth) {
        this(trackWidth, 0.0, 0.0, 6, null);
    }
}

