/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.RobotKinematics;
import gay.zharel.hermes.control.SwerveModuleIncrements;
import gay.zharel.hermes.control.SwerveModuleState;
import gay.zharel.hermes.control.WheelIncrements;
import gay.zharel.hermes.control.WheelVelocities;
import gay.zharel.hermes.geometry.DualNum;
import gay.zharel.hermes.geometry.DualNumKt;
import gay.zharel.hermes.geometry.DualParameter;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0002\u001b\u001cB\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ$\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\b\b\u0000\u0010\u000b*\u00020\f2\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J&\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0003\"\b\b\u0000\u0010\u000b*\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u0010H\u0016J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u0019\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lgay/zharel/hermes/control/SwerveKinematics;", "Lgay/zharel/hermes/control/RobotKinematics;", "Lgay/zharel/hermes/control/SwerveKinematics$SwerveWheelIncrements;", "Lgay/zharel/hermes/control/SwerveKinematics$SwerveWheelVelocities;", "modules", "", "Lgay/zharel/hermes/geometry/Vector2d;", "<init>", "(Ljava/util/List;)V", "forward", "Lgay/zharel/hermes/geometry/Twist2dDual;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "w", "inverse", "t", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "SwerveWheelIncrements", "SwerveWheelVelocities", "core"})
@SourceDebugExtension(value={"SMAP\nKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/SwerveKinematics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n3550#2,7:298\n1869#2,2:305\n1969#2,14:307\n1878#2,3:321\n1563#2:324\n1634#2,3:325\n*S KotlinDebug\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/SwerveKinematics\n*L\n200#1:298,7\n245#1:305,2\n266#1:307,14\n270#1:321,3\n276#1:324\n276#1:325,3\n*E\n"})
public final class SwerveKinematics
implements RobotKinematics<SwerveWheelIncrements<?>, SwerveWheelVelocities<?>> {
    @JvmField
    @NotNull
    public final List<Vector2d> modules;

    public SwerveKinematics(@NotNull List<Vector2d> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        this.modules = modules;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Param extends DualParameter> Twist2dDual<Param> forward(@NotNull SwerveWheelIncrements<?> w) {
        void $this$zip$iv;
        Intrinsics.checkNotNullParameter(w, (String)"w");
        DualNum sumX = null;
        sumX = DualNum.Companion.constant(0.0, w.deltas.size());
        DualNum sumY = null;
        sumY = DualNum.Companion.constant(0.0, w.deltas.size());
        DualNum sumAngular = null;
        sumAngular = DualNum.Companion.constant(0.0, w.deltas.size());
        Iterable iterable = this.modules;
        Iterable other$iv = w.deltas;
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Unit> list$iv = new ArrayList<Unit>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void module;
            void delta;
            SwerveModuleIncrements swerveModuleIncrements = (SwerveModuleIncrements)second$iv.next();
            Vector2d vector2d = (Vector2d)first$iv.next();
            ArrayList<Unit> arrayList = list$iv;
            boolean bl = false;
            double cosAngle = Math.cos(delta.angle);
            double sinAngle = Math.sin(delta.angle);
            DualNum moduleX = delta.wheelDelta.times(cosAngle);
            DualNum moduleY = delta.wheelDelta.times(sinAngle);
            sumX = sumX.plus(moduleX);
            sumY = sumY.plus(moduleY);
            DualNum angularContribution = moduleY.times(module.x).minus(moduleX.times(module.y));
            sumAngular = sumAngular.plus(angularContribution);
            arrayList.add(Unit.INSTANCE);
        }
        double numModules = this.modules.size();
        DualNum avgX = sumX.div(numModules);
        DualNum avgY = sumY.div(numModules);
        DualNum avgAngular = sumAngular.div(numModules);
        return new Twist2dDual(new Vector2dDual(avgX, avgY), avgAngular);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public <Param extends DualParameter> SwerveWheelVelocities<Param> inverse(@NotNull PoseVelocity2dDual<Param> t) {
        void $this$mapTo$iv$iv;
        Object t2;
        Intrinsics.checkNotNullParameter(t, (String)"t");
        List wheelVels = new ArrayList();
        List steeringAngles = new ArrayList();
        Iterable $this$forEach$iv = this.modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vector2d module = (Vector2d)element$iv;
            boolean bl = false;
            DualNum rotVelX = t.angVel.times(-module.y);
            DualNum rotVelY = t.angVel.times(module.x);
            DualNum totalVelX = t.linearVel.x.plus(rotVelX);
            DualNum totalVelY = t.linearVel.y.plus(rotVelY);
            DualNum wheelVel = totalVelX.times(totalVelX).plus(totalVelY.times(totalVelY)).sqrt();
            wheelVels.add(wheelVel);
            DualNum steeringAngle = DualNumKt.atan2(totalVelY, totalVelX);
            steeringAngles.add(steeringAngle);
        }
        Iterable $this$maxBy$iv = wheelVels;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t2 = maxElem$iv;
        } else {
            DualNum it = (DualNum)maxElem$iv;
            boolean bl = false;
            double maxValue$iv = it.value();
            do {
                Object e$iv = iterator$iv.next();
                DualNum it2 = (DualNum)e$iv;
                $i$a$-maxByOrThrow-SwerveKinematics$inverse$maxWheelVel$1 = false;
                double v$iv = it2.value();
                if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t2 = maxElem$iv;
        }
        DualNum maxWheelVel = (DualNum)t2;
        if (maxWheelVel.value() > 1.0) {
            Iterable $this$forEachIndexed$iv = wheelVels;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void wheelVel;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                DualNum v$iv = (DualNum)item$iv;
                int index = n;
                boolean bl = false;
                wheelVels.set(index, wheelVel.div(maxWheelVel));
            }
        }
        Iterable $this$map$iv = CollectionsKt.zip((Iterable)wheelVels, (Iterable)steeringAngles);
        boolean $i$f$map = false;
        Iterable index$iv = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair index = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new SwerveModuleState((DualNum)it.getFirst(), (DualNum)it.getSecond()));
        }
        List list = (List)destination$iv$iv;
        return new SwerveWheelVelocities(list);
    }

    @NotNull
    public final List<Vector2d> component1() {
        return this.modules;
    }

    @NotNull
    public final SwerveKinematics copy(@NotNull List<Vector2d> modules) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        return new SwerveKinematics(modules);
    }

    public static /* synthetic */ SwerveKinematics copy$default(SwerveKinematics swerveKinematics, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = swerveKinematics.modules;
        }
        return swerveKinematics.copy(list);
    }

    @NotNull
    public String toString() {
        return "SwerveKinematics(modules=" + this.modules + ")";
    }

    public int hashCode() {
        return ((Object)this.modules).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SwerveKinematics)) {
            return false;
        }
        SwerveKinematics swerveKinematics = (SwerveKinematics)other;
        return Intrinsics.areEqual(this.modules, swerveKinematics.modules);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0003J%\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgay/zharel/hermes/control/SwerveKinematics$SwerveWheelIncrements;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "Lgay/zharel/hermes/control/WheelIncrements;", "deltas", "", "Lgay/zharel/hermes/control/SwerveModuleIncrements;", "<init>", "(Ljava/util/List;)V", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class SwerveWheelIncrements<Param extends DualParameter>
    implements WheelIncrements<Param> {
        @JvmField
        @NotNull
        public final List<SwerveModuleIncrements<Param>> deltas;

        public SwerveWheelIncrements(@NotNull List<SwerveModuleIncrements<Param>> deltas) {
            Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
            this.deltas = deltas;
        }

        @NotNull
        public final List<SwerveModuleIncrements<Param>> component1() {
            return this.deltas;
        }

        @NotNull
        public final SwerveWheelIncrements<Param> copy(@NotNull List<SwerveModuleIncrements<Param>> deltas) {
            Intrinsics.checkNotNullParameter(deltas, (String)"deltas");
            return new SwerveWheelIncrements<Param>(deltas);
        }

        public static /* synthetic */ SwerveWheelIncrements copy$default(SwerveWheelIncrements swerveWheelIncrements, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = swerveWheelIncrements.deltas;
            }
            return swerveWheelIncrements.copy(list);
        }

        @NotNull
        public String toString() {
            return "SwerveWheelIncrements(deltas=" + this.deltas + ")";
        }

        public int hashCode() {
            return ((Object)this.deltas).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SwerveWheelIncrements)) {
                return false;
            }
            SwerveWheelIncrements swerveWheelIncrements = (SwerveWheelIncrements)other;
            return Intrinsics.areEqual(this.deltas, swerveWheelIncrements.deltas);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\u0005H\u0016J\u0015\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0003J%\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u001c\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgay/zharel/hermes/control/SwerveKinematics$SwerveWheelVelocities;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "Lgay/zharel/hermes/control/WheelVelocities;", "states", "", "Lgay/zharel/hermes/control/SwerveModuleState;", "<init>", "(Ljava/util/List;)V", "all", "Lgay/zharel/hermes/geometry/DualNum;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    @SourceDebugExtension(value={"SMAP\nKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/SwerveKinematics$SwerveWheelVelocities\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1563#2:298\n1634#2,3:299\n*S KotlinDebug\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/SwerveKinematics$SwerveWheelVelocities\n*L\n237#1:298\n237#1:299,3\n*E\n"})
    public static final class SwerveWheelVelocities<Param extends DualParameter>
    implements WheelVelocities<Param> {
        @JvmField
        @NotNull
        public final List<SwerveModuleState<Param>> states;

        public SwerveWheelVelocities(@NotNull List<SwerveModuleState<Param>> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            this.states = states;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<DualNum<Param>> all() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = this.states;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SwerveModuleState swerveModuleState = (SwerveModuleState)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.velocity);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<SwerveModuleState<Param>> component1() {
            return this.states;
        }

        @NotNull
        public final SwerveWheelVelocities<Param> copy(@NotNull List<SwerveModuleState<Param>> states) {
            Intrinsics.checkNotNullParameter(states, (String)"states");
            return new SwerveWheelVelocities<Param>(states);
        }

        public static /* synthetic */ SwerveWheelVelocities copy$default(SwerveWheelVelocities swerveWheelVelocities, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = swerveWheelVelocities.states;
            }
            return swerveWheelVelocities.copy(list);
        }

        @NotNull
        public String toString() {
            return "SwerveWheelVelocities(states=" + this.states + ")";
        }

        public int hashCode() {
            return ((Object)this.states).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SwerveWheelVelocities)) {
                return false;
            }
            SwerveWheelVelocities swerveWheelVelocities = (SwerveWheelVelocities)other;
            return Intrinsics.areEqual(this.states, swerveWheelVelocities.states);
        }
    }
}

