/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.geometry;

import gay.zharel.hermes.geometry.Acceleration2d;
import gay.zharel.hermes.geometry.DualNum;
import gay.zharel.hermes.geometry.DualParameter;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.Rotation2dDual;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\f0\u000b\"\b\b\u0000\u0010\f*\u00020\rJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lgay/zharel/hermes/geometry/RobotState;", "", "pose", "Lgay/zharel/hermes/geometry/Pose2d;", "vel", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "accel", "Lgay/zharel/hermes/geometry/Acceleration2d;", "<init>", "(Lgay/zharel/hermes/geometry/Pose2d;Lgay/zharel/hermes/geometry/PoseVelocity2d;Lgay/zharel/hermes/geometry/Acceleration2d;)V", "toDualPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "core"})
public final class RobotState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final Pose2d pose;
    @JvmField
    @NotNull
    public final PoseVelocity2d vel;
    @JvmField
    @NotNull
    public final Acceleration2d accel;
    @JvmField
    @NotNull
    public static final RobotState zero = new RobotState(Pose2d.zero, PoseVelocity2d.zero, Acceleration2d.zero);

    public RobotState(@NotNull Pose2d pose, @NotNull PoseVelocity2d vel, @NotNull Acceleration2d accel) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)accel, (String)"accel");
        this.pose = pose;
        this.vel = vel;
        this.accel = accel;
    }

    @NotNull
    public final <Param extends DualParameter> Pose2dDual<Param> toDualPose() {
        double[] dArray = new double[]{this.pose.position.x, this.vel.linearVel.x, this.accel.linearAcc.x};
        DualNum dualNum = new DualNum(dArray);
        dArray = new double[]{this.pose.position.y, this.vel.linearVel.y, this.accel.linearAcc.y};
        DualNum dualNum2 = new DualNum(dArray);
        dArray = new double[]{this.pose.heading.log(), this.vel.angVel, this.accel.angAcc};
        return new Pose2dDual(dualNum, dualNum2, Rotation2dDual.Companion.exp(new DualNum(dArray)));
    }

    @NotNull
    public final Pose2d component1() {
        return this.pose;
    }

    @NotNull
    public final PoseVelocity2d component2() {
        return this.vel;
    }

    @NotNull
    public final Acceleration2d component3() {
        return this.accel;
    }

    @NotNull
    public final RobotState copy(@NotNull Pose2d pose, @NotNull PoseVelocity2d vel, @NotNull Acceleration2d accel) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Intrinsics.checkNotNullParameter((Object)accel, (String)"accel");
        return new RobotState(pose, vel, accel);
    }

    public static /* synthetic */ RobotState copy$default(RobotState robotState, Pose2d pose2d, PoseVelocity2d poseVelocity2d, Acceleration2d acceleration2d, int n, Object object) {
        if ((n & 1) != 0) {
            pose2d = robotState.pose;
        }
        if ((n & 2) != 0) {
            poseVelocity2d = robotState.vel;
        }
        if ((n & 4) != 0) {
            acceleration2d = robotState.accel;
        }
        return robotState.copy(pose2d, poseVelocity2d, acceleration2d);
    }

    @NotNull
    public String toString() {
        return "RobotState(pose=" + this.pose + ", vel=" + this.vel + ", accel=" + this.accel + ")";
    }

    public int hashCode() {
        int result = this.pose.hashCode();
        result = result * 31 + this.vel.hashCode();
        result = result * 31 + this.accel.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof RobotState)) {
            return false;
        }
        RobotState robotState = (RobotState)other;
        if (!Intrinsics.areEqual((Object)this.pose, (Object)robotState.pose)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.vel, (Object)robotState.vel)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.accel, (Object)robotState.accel);
    }

    @JvmStatic
    @NotNull
    public static final <Param extends DualParameter> RobotState fromDualPose(@NotNull Pose2dDual<Param> dualPose) {
        return Companion.fromDualPose(dualPose);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0006\u001a\u00020\u0005\"\b\b\u0000\u0010\u0007*\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00070\nH\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lgay/zharel/hermes/geometry/RobotState$Companion;", "", "<init>", "()V", "zero", "Lgay/zharel/hermes/geometry/RobotState;", "fromDualPose", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "dualPose", "Lgay/zharel/hermes/geometry/Pose2dDual;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final <Param extends DualParameter> RobotState fromDualPose(@NotNull Pose2dDual<Param> dualPose) {
            Intrinsics.checkNotNullParameter(dualPose, (String)"dualPose");
            return new RobotState(dualPose.value(), dualPose.velocity().value(), dualPose.velocity().acceleration());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

