/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.paths;

import gay.zharel.hermes.geometry.DualParameter;
import gay.zharel.hermes.geometry.Math;
import gay.zharel.hermes.geometry.Rotation2d;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.paths.ConstantHeadingPath;
import gay.zharel.hermes.paths.HeadingPosePath;
import gay.zharel.hermes.paths.LinearHeadingPath;
import gay.zharel.hermes.paths.PositionPaths;
import gay.zharel.hermes.paths.SplineHeadingPath;
import gay.zharel.hermes.paths.TangentPath;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\bf\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003J\u001f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u00a6\u0002J\b\u0010\n\u001a\u00020\u0007H&J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0007H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u001b\u00c0\u0006\u0001"}, d2={"Lgay/zharel/hermes/paths/PositionPath;", "Param", "Lgay/zharel/hermes/geometry/DualParameter;", "", "get", "Lgay/zharel/hermes/geometry/Vector2dDual;", "param", "", "n", "", "length", "begin", "end", "project", "query", "Lgay/zharel/hermes/geometry/Vector2d;", "init", "withTangentHeading", "Lgay/zharel/hermes/paths/TangentPath;", "withConstantHeading", "Lgay/zharel/hermes/paths/HeadingPosePath;", "heading", "Lgay/zharel/hermes/geometry/Rotation2d;", "withLinearHeading", "startHeading", "endHeading", "withSplineHeading", "core"})
@SourceDebugExtension(value={"SMAP\nPositionPaths.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PositionPaths.kt\ngay/zharel/hermes/paths/PositionPath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,253:1\n1803#2,3:254\n*S KotlinDebug\n*F\n+ 1 PositionPaths.kt\ngay/zharel/hermes/paths/PositionPath\n*L\n30#1:254,3\n*E\n"})
public interface PositionPath<Param extends DualParameter> {
    @NotNull
    public Vector2dDual<Param> get(double var1, int var3);

    public double length();

    @NotNull
    default public Vector2dDual<Param> begin(int n) {
        return this.get(0.0, n);
    }

    @NotNull
    default public Vector2dDual<Param> end(int n) {
        return this.get(this.length(), n);
    }

    /*
     * WARNING - void declaration
     */
    default public double project(@NotNull Vector2d query, double init) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        Iterable iterable = (Iterable)new IntRange(1, 10);
        double initial$iv = init;
        boolean $i$f$fold = false;
        double accumulator$iv = initial$iv;
        Iterator iterator = $this$fold$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv = ((IntIterator)iterator).nextInt();
            double s = accumulator$iv;
            boolean bl = false;
            Vector2dDual<Param> guess = this.get(s, 3);
            double ds = query.minus(guess.value()).dot(guess.drop(1).value());
            accumulator$iv = Math.clamp(s + ds, 0.0, this.length());
        }
        return accumulator$iv;
    }

    public static /* synthetic */ double project$default(PositionPath positionPath, Vector2d vector2d, double d, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: project");
        }
        if ((n & 2) != 0) {
            d = 0.0;
        }
        return positionPath.project(vector2d, d);
    }

    @NotNull
    default public TangentPath withTangentHeading() {
        return new TangentPath(PositionPaths.access$wrtArclength(this), 0.0);
    }

    @NotNull
    default public HeadingPosePath withConstantHeading(@NotNull Rotation2d heading) {
        Intrinsics.checkNotNullParameter((Object)heading, (String)"heading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new ConstantHeadingPath(heading, it.length()));
    }

    @NotNull
    default public HeadingPosePath withConstantHeading(double heading) {
        return this.withConstantHeading(PositionPaths.toRotation(heading));
    }

    @NotNull
    default public HeadingPosePath withLinearHeading(@NotNull Rotation2d startHeading, @NotNull Rotation2d endHeading) {
        Intrinsics.checkNotNullParameter((Object)startHeading, (String)"startHeading");
        Intrinsics.checkNotNullParameter((Object)endHeading, (String)"endHeading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new LinearHeadingPath(startHeading, endHeading.minus(startHeading), it.length()));
    }

    @NotNull
    default public HeadingPosePath withLinearHeading(double startHeading, double endHeading) {
        return this.withLinearHeading(PositionPaths.toRotation(startHeading), PositionPaths.toRotation(endHeading));
    }

    @NotNull
    default public HeadingPosePath withSplineHeading(@NotNull Rotation2d startHeading, @NotNull Rotation2d endHeading) {
        Intrinsics.checkNotNullParameter((Object)startHeading, (String)"startHeading");
        Intrinsics.checkNotNullParameter((Object)endHeading, (String)"endHeading");
        PositionPath it = PositionPaths.access$wrtArclength(this);
        boolean bl = false;
        return new HeadingPosePath(it, new SplineHeadingPath(PositionPaths.dual(startHeading), PositionPaths.dual(PositionPaths.toRotation(endHeading.minus(startHeading))), it.length()));
    }

    @NotNull
    default public HeadingPosePath withSplineHeading(double startHeading, double endHeading) {
        return this.withSplineHeading(PositionPaths.toRotation(startHeading), PositionPaths.toRotation(endHeading));
    }
}

