/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.paths;

import gay.zharel.hermes.geometry.Arclength;
import gay.zharel.hermes.geometry.Pose2d;
import gay.zharel.hermes.geometry.Pose2dDual;
import gay.zharel.hermes.geometry.Rotation2d;
import gay.zharel.hermes.geometry.Vector2d;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.paths.HeadingPath;
import gay.zharel.hermes.paths.LinearHeadingPath;
import gay.zharel.hermes.paths.PosePath;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0006\u0010\fJ\u001f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lgay/zharel/hermes/paths/TurnPath;", "Lgay/zharel/hermes/paths/PosePath;", "position", "Lgay/zharel/hermes/geometry/Vector2d;", "headingPath", "Lgay/zharel/hermes/paths/HeadingPath;", "<init>", "(Lgay/zharel/hermes/geometry/Vector2d;Lgay/zharel/hermes/paths/HeadingPath;)V", "start", "Lgay/zharel/hermes/geometry/Pose2d;", "endAngle", "Lgay/zharel/hermes/geometry/Rotation2d;", "(Lgay/zharel/hermes/geometry/Pose2d;Lgay/zharel/hermes/geometry/Rotation2d;)V", "get", "Lgay/zharel/hermes/geometry/Pose2dDual;", "Lgay/zharel/hermes/geometry/Arclength;", "s", "", "n", "", "length", "core"})
public final class TurnPath
implements PosePath {
    @JvmField
    @NotNull
    public final Vector2d position;
    @JvmField
    @NotNull
    public final HeadingPath headingPath;

    public TurnPath(@NotNull Vector2d position, @NotNull HeadingPath headingPath) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)headingPath, (String)"headingPath");
        this.position = position;
        this.headingPath = headingPath;
    }

    public TurnPath(@NotNull Pose2d start, @NotNull Rotation2d endAngle) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endAngle, (String)"endAngle");
        this(start.position, new LinearHeadingPath(start.heading, endAngle.log(), start.heading.minus(endAngle)));
    }

    @Override
    @NotNull
    public Pose2dDual<Arclength> get(double s, int n) {
        return new Pose2dDual<Arclength>(Vector2dDual.Companion.constant(this.position, n), this.headingPath.get(s, n));
    }

    @Override
    public double length() {
        return this.headingPath.length();
    }
}

