/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.profiles.DisplacementProfile;
import gay.zharel.hermes.profiles.MergePoint;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\b\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0001\u001a(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0002\u001a \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002\u001a(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001aZ\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u001ab\u0010\u001d\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u00172\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u001e\u001a\u00020\u000fH\u0002\u00a8\u0006\u001f"}, d2={"mergeDisplacementProfiles", "Lgay/zharel/hermes/profiles/DisplacementProfile;", "p1", "p2", "determineNextMergePoint", "Lgay/zharel/hermes/profiles/MergePoint;", "i", "", "j", "interpolateVelocityBackward", "", "endVel", "acceleration", "distance", "shouldCreateTransitionPoint", "", "currentMinIsFromP1", "lastMinWasFromP1", "accel1", "accel2", "addTransitionPoint", "", "disps", "", "vels", "accels", "endDisp", "endVel1", "endVel2", "addSingleMergePoint", "minIsFromP1", "core"})
public final class ProfileMergingKt {
    @NotNull
    public static final DisplacementProfile mergeDisplacementProfiles(@NotNull DisplacementProfile p1, @NotNull DisplacementProfile p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        Object[] objectArray = new Double[]{0.0};
        List disps = CollectionsKt.mutableListOf((Object[])objectArray);
        Object[] objectArray2 = new Double[]{Math.min(((Number)p1.vels.get(0)).doubleValue(), ((Number)p2.vels.get(0)).doubleValue())};
        List vels = CollectionsKt.mutableListOf((Object[])objectArray2);
        List accels = new ArrayList();
        boolean lastMinWasFromP1 = ((Number)p1.vels.get(0)).doubleValue() < ((Number)p2.vels.get(0)).doubleValue();
        int i = 1;
        int j = 1;
        while (i < p1.disps.size() && j < p2.disps.size()) {
            boolean currentMinIsFromP1;
            MergePoint mergePoint = ProfileMergingKt.determineNextMergePoint(p1, p2, i, j);
            double endDisp = mergePoint.component1();
            double endVel1 = mergePoint.component2();
            double endVel2 = mergePoint.component3();
            double accel1 = mergePoint.component4();
            double accel2 = mergePoint.component5();
            if (((Number)p1.disps.get(i)).doubleValue() == ((Number)p2.disps.get(j)).doubleValue()) {
                ++i;
                ++j;
            } else if (((Number)p1.disps.get(i)).doubleValue() < ((Number)p2.disps.get(j)).doubleValue()) {
                ++i;
            } else {
                ++j;
            }
            boolean bl = currentMinIsFromP1 = endVel1 < endVel2;
            if (ProfileMergingKt.shouldCreateTransitionPoint(currentMinIsFromP1, lastMinWasFromP1, accel1, accel2)) {
                ProfileMergingKt.addTransitionPoint(disps, vels, accels, endDisp, endVel1, endVel2, accel1, accel2);
            } else {
                ProfileMergingKt.addSingleMergePoint(disps, vels, accels, endDisp, endVel1, endVel2, accel1, accel2, currentMinIsFromP1);
            }
            lastMinWasFromP1 = currentMinIsFromP1;
        }
        return new DisplacementProfile(disps, vels, accels);
    }

    private static final MergePoint determineNextMergePoint(DisplacementProfile p1, DisplacementProfile p2, int i, int j) {
        Pair pair;
        double endDisp = Math.min(((Number)p1.disps.get(i)).doubleValue(), ((Number)p2.disps.get(j)).doubleValue());
        double accel1 = ((Number)p1.accels.get(i - 1)).doubleValue();
        double accel2 = ((Number)p2.accels.get(j - 1)).doubleValue();
        if (((Number)p1.disps.get(i)).doubleValue() == ((Number)p2.disps.get(j)).doubleValue()) {
            pair = new Pair((Object)p1.vels.get(i), (Object)p2.vels.get(j));
        } else if (((Number)p1.disps.get(i)).doubleValue() < ((Number)p2.disps.get(j)).doubleValue()) {
            double interpolatedVel2 = ProfileMergingKt.interpolateVelocityBackward(((Number)p2.vels.get(j)).doubleValue(), accel2, ((Number)p2.disps.get(j)).doubleValue() - ((Number)p1.disps.get(i)).doubleValue());
            pair = new Pair((Object)p1.vels.get(i), (Object)interpolatedVel2);
        } else {
            double interpolatedVel1 = ProfileMergingKt.interpolateVelocityBackward(((Number)p1.vels.get(i)).doubleValue(), accel1, ((Number)p1.disps.get(i)).doubleValue() - ((Number)p2.disps.get(j)).doubleValue());
            pair = new Pair((Object)interpolatedVel1, (Object)p2.vels.get(j));
        }
        Pair pair2 = pair;
        double endVel1 = ((Number)pair2.component1()).doubleValue();
        double endVel2 = ((Number)pair2.component2()).doubleValue();
        return new MergePoint(endDisp, endVel1, endVel2, accel1, accel2);
    }

    private static final double interpolateVelocityBackward(double endVel, double acceleration, double distance) {
        return Math.sqrt(Math.max(0.0, endVel * endVel - (double)2 * acceleration * distance));
    }

    private static final boolean shouldCreateTransitionPoint(boolean currentMinIsFromP1, boolean lastMinWasFromP1, double accel1, double accel2) {
        return currentMinIsFromP1 != lastMinWasFromP1 && !(accel1 == accel2);
    }

    private static final void addTransitionPoint(List<Double> disps, List<Double> vels, List<Double> accels, double endDisp, double endVel1, double endVel2, double accel1, double accel2) {
        double crossoverDistance = (endVel2 * endVel2 - endVel1 * endVel1) / ((double)2 * (accel2 - accel1));
        double crossoverDisp = endDisp - crossoverDistance;
        double crossoverVel = Math.sqrt(endVel1 * endVel1 - (double)2 * accel1 * crossoverDistance);
        disps.add(crossoverDisp);
        vels.add(crossoverVel);
        accels.add(Math.max(accel1, accel2));
        disps.add(endDisp);
        vels.add(Math.min(endVel1, endVel2));
        accels.add(Math.min(accel1, accel2));
    }

    private static final void addSingleMergePoint(List<Double> disps, List<Double> vels, List<Double> accels, double endDisp, double endVel1, double endVel2, double accel1, double accel2, boolean minIsFromP1) {
        disps.add(endDisp);
        if (minIsFromP1) {
            vels.add(endVel1);
            v0 = accels.add(accel1);
        } else {
            vels.add(endVel2);
            v0 = accels.add(accel2);
        }
    }
}

