/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.control;

import gay.zharel.hermes.control.RobotKinematics;
import gay.zharel.hermes.control.WheelIncrements;
import gay.zharel.hermes.control.WheelVelocities;
import gay.zharel.hermes.geometry.PoseVelocity2dDual;
import gay.zharel.hermes.geometry.Twist2dDual;
import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.DualParameter;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001:\u0002\u001a\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J&\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\n0\u0003\"\b\b\u0000\u0010\n*\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\n0\u000fH\u0016J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lgay/zharel/hermes/control/TankKinematics;", "Lgay/zharel/hermes/control/RobotKinematics;", "Lgay/zharel/hermes/control/TankKinematics$TankWheelIncrements;", "Lgay/zharel/hermes/control/TankKinematics$TankWheelVelocities;", "trackWidth", "", "<init>", "(D)V", "forward", "Lgay/zharel/hermes/geometry/Twist2dDual;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "w", "inverse", "t", "Lgay/zharel/hermes/geometry/PoseVelocity2dDual;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "TankWheelIncrements", "TankWheelVelocities", "core"})
@SourceDebugExtension(value={"SMAP\nKinematics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/TankKinematics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,297:1\n1740#2,3:298\n*S KotlinDebug\n*F\n+ 1 Kinematics.kt\ngay/zharel/hermes/control/TankKinematics\n*L\n146#1:298,3\n*E\n"})
public final class TankKinematics
implements RobotKinematics<TankWheelIncrements<?>, TankWheelVelocities<?>> {
    @JvmField
    public final double trackWidth;

    public TankKinematics(double trackWidth) {
        this.trackWidth = trackWidth;
    }

    @Override
    @NotNull
    public <Param extends DualParameter> Twist2dDual<Param> forward(@NotNull TankWheelIncrements<?> w) {
        Intrinsics.checkNotNullParameter(w, (String)"w");
        return new Twist2dDual(new Vector2dDual(w.left.plus(w.right).times(0.5), DualNum.Companion.constant(0.0, w.left.size())), w.left.unaryMinus().plus(w.right).div(this.trackWidth));
    }

    @Override
    @NotNull
    public <Param extends DualParameter> TankWheelVelocities<Param> inverse(@NotNull PoseVelocity2dDual<Param> t) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(t, (String)"t");
            Iterable $this$all$iv = t.linearVel.y.values();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    double it = ((Number)element$iv).doubleValue();
                    boolean bl2 = false;
                    if (Math.abs(it) < 1.0E-6) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            boolean bl3 = false;
            String string = "Tank drive does not support lateral motion";
            throw new IllegalArgumentException(string.toString());
        }
        return new TankWheelVelocities(t.linearVel.x.minus(t.angVel.times(0.5).times(this.trackWidth)), t.linearVel.x.plus(t.angVel.times(0.5).times(this.trackWidth)));
    }

    public final double component1() {
        return this.trackWidth;
    }

    @NotNull
    public final TankKinematics copy(double trackWidth) {
        return new TankKinematics(trackWidth);
    }

    public static /* synthetic */ TankKinematics copy$default(TankKinematics tankKinematics, double d, int n, Object object) {
        if ((n & 1) != 0) {
            d = tankKinematics.trackWidth;
        }
        return tankKinematics.copy(d);
    }

    @NotNull
    public String toString() {
        return "TankKinematics(trackWidth=" + this.trackWidth + ")";
    }

    public int hashCode() {
        return Double.hashCode(this.trackWidth);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TankKinematics)) {
            return false;
        }
        TankKinematics tankKinematics = (TankKinematics)other;
        return Double.compare(this.trackWidth, tankKinematics.trackWidth) == 0;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J/\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lgay/zharel/hermes/control/TankKinematics$TankWheelIncrements;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/control/WheelIncrements;", "left", "Lgay/zharel/hermes/math/DualNum;", "right", "<init>", "(Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;)V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class TankWheelIncrements<Param extends DualParameter>
    implements WheelIncrements<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> left;
        @JvmField
        @NotNull
        public final DualNum<Param> right;

        public TankWheelIncrements(@NotNull DualNum<Param> left, @NotNull DualNum<Param> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            this.left = left;
            this.right = right;
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.left;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.right;
        }

        @NotNull
        public final TankWheelIncrements<Param> copy(@NotNull DualNum<Param> left, @NotNull DualNum<Param> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            return new TankWheelIncrements<Param>(left, right);
        }

        public static /* synthetic */ TankWheelIncrements copy$default(TankWheelIncrements tankWheelIncrements, DualNum dualNum, DualNum dualNum2, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = tankWheelIncrements.left;
            }
            if ((n & 2) != 0) {
                dualNum2 = tankWheelIncrements.right;
            }
            return tankWheelIncrements.copy(dualNum, dualNum2);
        }

        @NotNull
        public String toString() {
            return "TankWheelIncrements(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TankWheelIncrements)) {
                return false;
            }
            TankWheelIncrements tankWheelIncrements = (TankWheelIncrements)other;
            if (!Intrinsics.areEqual(this.left, tankWheelIncrements.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, tankWheelIncrements.right);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B#\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\nH\u0016J\u000f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J/\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lgay/zharel/hermes/control/TankKinematics$TankWheelVelocities;", "Param", "Lgay/zharel/hermes/math/DualParameter;", "Lgay/zharel/hermes/control/WheelVelocities;", "left", "Lgay/zharel/hermes/math/DualNum;", "right", "<init>", "(Lgay/zharel/hermes/math/DualNum;Lgay/zharel/hermes/math/DualNum;)V", "all", "", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "core"})
    public static final class TankWheelVelocities<Param extends DualParameter>
    implements WheelVelocities<Param> {
        @JvmField
        @NotNull
        public final DualNum<Param> left;
        @JvmField
        @NotNull
        public final DualNum<Param> right;

        public TankWheelVelocities(@NotNull DualNum<Param> left, @NotNull DualNum<Param> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            this.left = left;
            this.right = right;
        }

        @Override
        @NotNull
        public List<DualNum<Param>> all() {
            Object[] objectArray = new DualNum[]{this.left, this.right};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final DualNum<Param> component1() {
            return this.left;
        }

        @NotNull
        public final DualNum<Param> component2() {
            return this.right;
        }

        @NotNull
        public final TankWheelVelocities<Param> copy(@NotNull DualNum<Param> left, @NotNull DualNum<Param> right) {
            Intrinsics.checkNotNullParameter(left, (String)"left");
            Intrinsics.checkNotNullParameter(right, (String)"right");
            return new TankWheelVelocities<Param>(left, right);
        }

        public static /* synthetic */ TankWheelVelocities copy$default(TankWheelVelocities tankWheelVelocities, DualNum dualNum, DualNum dualNum2, int n, Object object) {
            if ((n & 1) != 0) {
                dualNum = tankWheelVelocities.left;
            }
            if ((n & 2) != 0) {
                dualNum2 = tankWheelVelocities.right;
            }
            return tankWheelVelocities.copy(dualNum, dualNum2);
        }

        @NotNull
        public String toString() {
            return "TankWheelVelocities(left=" + this.left + ", right=" + this.right + ")";
        }

        public int hashCode() {
            int result = this.left.hashCode();
            result = result * 31 + this.right.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TankWheelVelocities)) {
                return false;
            }
            TankWheelVelocities tankWheelVelocities = (TankWheelVelocities)other;
            if (!Intrinsics.areEqual(this.left, tankWheelVelocities.left)) {
                return false;
            }
            return Intrinsics.areEqual(this.right, tankWheelVelocities.right);
        }
    }
}

