/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.geometry;

import gay.zharel.hermes.geometry.PoseVelocity2d;
import gay.zharel.hermes.geometry.Rotation2d$;
import gay.zharel.hermes.geometry.Vector2d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B+\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0011\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0086\u0002J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000H\u0086\u0002J\u0006\u0010\u0015\u001a\u00020\u0011J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001J%\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0001\u00a2\u0006\u0002\b)R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lgay/zharel/hermes/geometry/Rotation2d;", "", "real", "", "imag", "<init>", "(DD)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(IDDLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "plus", "x", "minus", "r", "times", "Lgay/zharel/hermes/geometry/Vector2d;", "v", "Lgay/zharel/hermes/geometry/PoseVelocity2d;", "pv", "vec", "inverse", "log", "toDouble", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "Companion", "$serializer", "core"})
public final class Rotation2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    public final double real;
    @JvmField
    public final double imag;
    @JvmField
    @NotNull
    public static final Rotation2d zero = new Rotation2d(0.0, 0.0);

    public Rotation2d(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    @NotNull
    public final Rotation2d plus(double x) {
        return this.times(Companion.exp(x));
    }

    public final double minus(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return r.inverse().times(this).log();
    }

    @NotNull
    public final Vector2d times(@NotNull Vector2d v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new Vector2d(this.real * v.x - this.imag * v.y, this.imag * v.x + this.real * v.y);
    }

    @NotNull
    public final PoseVelocity2d times(@NotNull PoseVelocity2d pv) {
        Intrinsics.checkNotNullParameter((Object)pv, (String)"pv");
        return new PoseVelocity2d(this.times(pv.linearVel), pv.angVel);
    }

    @NotNull
    public final Rotation2d times(@NotNull Rotation2d r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return new Rotation2d(this.real * r.real - this.imag * r.imag, this.real * r.imag + this.imag * r.real);
    }

    @NotNull
    public final Vector2d vec() {
        return new Vector2d(this.real, this.imag);
    }

    @NotNull
    public final Rotation2d inverse() {
        return new Rotation2d(this.real, -this.imag);
    }

    public final double log() {
        return Math.atan2(this.imag, this.real);
    }

    public final double toDouble() {
        return this.log();
    }

    public final double component1() {
        return this.real;
    }

    public final double component2() {
        return this.imag;
    }

    @NotNull
    public final Rotation2d copy(double real, double imag) {
        return new Rotation2d(real, imag);
    }

    public static /* synthetic */ Rotation2d copy$default(Rotation2d rotation2d, double d, double d2, int n, Object object) {
        if ((n & 1) != 0) {
            d = rotation2d.real;
        }
        if ((n & 2) != 0) {
            d2 = rotation2d.imag;
        }
        return rotation2d.copy(d, d2);
    }

    @NotNull
    public String toString() {
        return "Rotation2d(real=" + this.real + ", imag=" + this.imag + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.real);
        result = result * 31 + Double.hashCode(this.imag);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rotation2d)) {
            return false;
        }
        Rotation2d rotation2d = (Rotation2d)other;
        if (Double.compare(this.real, rotation2d.real) != 0) {
            return false;
        }
        return Double.compare(this.imag, rotation2d.imag) == 0;
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(Rotation2d self, CompositeEncoder output, SerialDescriptor serialDesc) {
        output.encodeDoubleElement(serialDesc, 0, self.real);
        output.encodeDoubleElement(serialDesc, 1, self.imag);
    }

    public /* synthetic */ Rotation2d(int seen0, double real, double imag, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.real = real;
        this.imag = imag;
    }

    @JvmStatic
    @NotNull
    public static final Rotation2d exp(double theta) {
        return Companion.exp(theta);
    }

    @JvmStatic
    @NotNull
    public static final Rotation2d fromDouble(double theta) {
        return Companion.fromDouble(theta);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bR\u0010\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lgay/zharel/hermes/geometry/Rotation2d$Companion;", "", "<init>", "()V", "exp", "Lgay/zharel/hermes/geometry/Rotation2d;", "theta", "", "fromDouble", "zero", "serializer", "Lkotlinx/serialization/KSerializer;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final Rotation2d exp(double theta) {
            return new Rotation2d(Math.cos(theta), Math.sin(theta));
        }

        @JvmStatic
        @NotNull
        public final Rotation2d fromDouble(double theta) {
            return this.exp(theta);
        }

        @NotNull
        public final KSerializer<Rotation2d> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

