/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.math;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0005\u001a.\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\u0001\u001a\u001e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a*\u0010\f\u001a\u00020\u00012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0001\u001a6\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u000e\u00a8\u0006\u0013"}, d2={"lerp", "", "x", "fromLo", "fromHi", "toLo", "toHi", "low", "high", "t", "antiLerp", "value", "lerpLookup", "source", "", "target", "query", "lerpLookupMap", "queries", "core"})
@SourceDebugExtension(value={"SMAP\nInterpolation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Interpolation.kt\ngay/zharel/hermes/math/InterpolationKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n1#2:172\n*E\n"})
public final class InterpolationKt {
    public static final double lerp(double x, double fromLo, double fromHi, double toLo, double toHi) {
        return fromLo == fromHi ? 0.0 : toLo + (x - fromLo) * (toHi - toLo) / (fromHi - fromLo);
    }

    public static final double lerp(double low, double high, double t) {
        return low + (high - low) * t;
    }

    public static final double antiLerp(double value, double low, double high) {
        return (value - low) / (high - low);
    }

    public static final double lerpLookup(@NotNull List<Double> source, @NotNull List<Double> target, double query) {
        double d;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        if (!(source.size() == target.size())) {
            boolean $i$a$-require-InterpolationKt$lerpLookup$32 = false;
            String $i$a$-require-InterpolationKt$lerpLookup$32 = "source.size (" + source.size() + ") != target.size (" + target.size() + ")";
            throw new IllegalArgumentException($i$a$-require-InterpolationKt$lerpLookup$32.toString());
        }
        if (!(!((Collection)source).isEmpty())) {
            boolean $i$a$-require-InterpolationKt$lerpLookup$42 = false;
            String $i$a$-require-InterpolationKt$lerpLookup$42 = "source is empty";
            throw new IllegalArgumentException($i$a$-require-InterpolationKt$lerpLookup$42.toString());
        }
        int index = CollectionsKt.binarySearch$default(source, (Comparable)Double.valueOf(query), (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            d = ((Number)target.get(index)).doubleValue();
        } else {
            int insIndex = -(index + 1);
            if (insIndex <= 0) {
                d = ((Number)CollectionsKt.first(target)).doubleValue();
            } else if (insIndex >= source.size()) {
                d = ((Number)CollectionsKt.last(target)).doubleValue();
            } else {
                double sLo = ((Number)source.get(insIndex - 1)).doubleValue();
                double sHi = ((Number)source.get(insIndex)).doubleValue();
                double tLo = ((Number)target.get(insIndex - 1)).doubleValue();
                double tHi = ((Number)target.get(insIndex)).doubleValue();
                d = InterpolationKt.lerp(query, sLo, sHi, tLo, tHi);
            }
        }
        return d;
    }

    @NotNull
    public static final List<Double> lerpLookupMap(@NotNull List<Double> source, @NotNull List<Double> target, @NotNull List<Double> queries) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        if (!(source.size() == target.size())) {
            boolean $i$a$-require-InterpolationKt$lerpLookupMap$32 = false;
            String $i$a$-require-InterpolationKt$lerpLookupMap$32 = "source.size (" + source.size() + ") != target.size (" + target.size() + ")";
            throw new IllegalArgumentException($i$a$-require-InterpolationKt$lerpLookupMap$32.toString());
        }
        if (!(!((Collection)source).isEmpty())) {
            boolean $i$a$-require-InterpolationKt$lerpLookupMap$42 = false;
            String $i$a$-require-InterpolationKt$lerpLookupMap$42 = "source is empty";
            throw new IllegalArgumentException($i$a$-require-InterpolationKt$lerpLookupMap$42.toString());
        }
        List result = new ArrayList();
        int i = 0;
        Iterator<Double> iterator = queries.iterator();
        while (iterator.hasNext()) {
            double query = ((Number)iterator.next()).doubleValue();
            if (query < ((Number)source.get(0)).doubleValue()) {
                result.add(target.get(0));
                continue;
            }
            while (i + 1 < source.size() && ((Number)source.get(i + 1)).doubleValue() < query) {
                ++i;
            }
            if (i + 1 == source.size()) {
                result.add(CollectionsKt.last(target));
                continue;
            }
            double sLo = ((Number)source.get(i)).doubleValue();
            double sHi = ((Number)source.get(i + 1)).doubleValue();
            double tLo = ((Number)target.get(i)).doubleValue();
            double tHi = ((Number)target.get(i + 1)).doubleValue();
            result.add(InterpolationKt.lerp(query, sLo, sHi, tLo, tHi));
        }
        return result;
    }
}

