/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.math;

import gay.zharel.hermes.math.Matrix;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.ejml.data.DMatrixRMaj;
import org.ejml.interfaces.decomposition.CholeskyDecomposition;
import org.ejml.simple.SimpleMatrix;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c2\u0003J\t\u0010\u0012\u001a\u00020\u0004H\u00c2\u0003J(\u0010\u0013\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c0\u0001\u00a2\u0006\u0002\b\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Lgay/zharel/hermes/math/LLTDecomposition;", "", "chol", "Lorg/ejml/interfaces/decomposition/CholeskyDecomposition;", "Lorg/ejml/data/DMatrixRMaj;", "mat", "<init>", "(Lorg/ejml/interfaces/decomposition/CholeskyDecomposition;Lorg/ejml/data/DMatrixRMaj;)V", "L", "Lgay/zharel/hermes/math/Matrix;", "getL", "()Lgay/zharel/hermes/math/Matrix;", "update", "", "x", "", "downdate", "component1", "component2", "copy", "copy$core", "equals", "", "other", "hashCode", "", "toString", "", "core"})
public final class LLTDecomposition {
    @NotNull
    private final CholeskyDecomposition<DMatrixRMaj> chol;
    @NotNull
    private DMatrixRMaj mat;

    public LLTDecomposition(@NotNull CholeskyDecomposition<DMatrixRMaj> chol, @NotNull DMatrixRMaj mat) {
        Intrinsics.checkNotNullParameter(chol, (String)"chol");
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        this.chol = chol;
        this.mat = mat;
    }

    @NotNull
    public final Matrix getL() {
        return new Matrix(new SimpleMatrix(this.chol.getT(null)));
    }

    public final void update(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        int i = 0;
        int n = this.mat.numRows;
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = 0) <= (n2 = this.mat.numCols)) {
                    do {
                        DMatrixRMaj dMatrixRMaj = this.mat;
                        int n3 = i;
                        int n4 = ++j;
                        dMatrixRMaj.set(n3, n4, dMatrixRMaj.get(n3, n4) + x[i] * x[j]);
                    } while (j != n2);
                }
                if (i == n) break;
                ++i;
            }
        }
        if (!this.chol.decompose((org.ejml.data.Matrix)this.mat)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void downdate(@NotNull double[] x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        int i = 0;
        int n = this.mat.numRows;
        if (i <= n) {
            while (true) {
                int n2;
                int j;
                if ((j = 0) <= (n2 = this.mat.numCols)) {
                    do {
                        DMatrixRMaj dMatrixRMaj = this.mat;
                        int n3 = i;
                        int n4 = ++j;
                        dMatrixRMaj.set(n3, n4, dMatrixRMaj.get(n3, n4) - x[i] * x[j]);
                    } while (j != n2);
                }
                if (i == n) break;
                ++i;
            }
        }
        if (!this.chol.decompose((org.ejml.data.Matrix)this.mat)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final CholeskyDecomposition<DMatrixRMaj> component1() {
        return this.chol;
    }

    private final DMatrixRMaj component2() {
        return this.mat;
    }

    @NotNull
    public final LLTDecomposition copy$core(@NotNull CholeskyDecomposition<DMatrixRMaj> chol, @NotNull DMatrixRMaj mat) {
        Intrinsics.checkNotNullParameter(chol, (String)"chol");
        Intrinsics.checkNotNullParameter((Object)mat, (String)"mat");
        return new LLTDecomposition(chol, mat);
    }

    public static /* synthetic */ LLTDecomposition copy$core$default(LLTDecomposition lLTDecomposition, CholeskyDecomposition choleskyDecomposition, DMatrixRMaj dMatrixRMaj, int n, Object object) {
        if ((n & 1) != 0) {
            choleskyDecomposition = lLTDecomposition.chol;
        }
        if ((n & 2) != 0) {
            dMatrixRMaj = lLTDecomposition.mat;
        }
        return lLTDecomposition.copy$core(choleskyDecomposition, dMatrixRMaj);
    }

    @NotNull
    public String toString() {
        return "LLTDecomposition(chol=" + this.chol + ", mat=" + this.mat + ")";
    }

    public int hashCode() {
        int result = this.chol.hashCode();
        result = result * 31 + this.mat.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LLTDecomposition)) {
            return false;
        }
        LLTDecomposition lLTDecomposition = (LLTDecomposition)other;
        if (!Intrinsics.areEqual(this.chol, lLTDecomposition.chol)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mat, (Object)lLTDecomposition.mat);
    }
}

