/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.paths;

import gay.zharel.hermes.geometry.Vector2dDual;
import gay.zharel.hermes.math.Arclength;
import gay.zharel.hermes.math.DualNum;
import gay.zharel.hermes.math.IntegralScanResult;
import gay.zharel.hermes.math.IntegralScanResult$;
import gay.zharel.hermes.math.InterpolationKt;
import gay.zharel.hermes.math.Math;
import gay.zharel.hermes.paths.ArclengthReparamCurve2d$;
import gay.zharel.hermes.paths.PositionPath;
import java.lang.annotation.Annotation;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.PolymorphicSerializer;
import kotlinx.serialization.SerialName;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable
@SerialName(value="ArclengthReparamPath")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 *2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002)*B\u001b\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001d\b\u0016\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nB;\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\f\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\r\u001a\u00020\t\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0006\u0010\u0010J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\tJ\u001f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\fH\u0096\u0002J\b\u0010\r\u001a\u00020\tH\u0016J\r\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0001H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J!\u0010\u0019\u001a\u00020\u00002\f\b\u0002\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\t\u0010\u001e\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J%\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0001\u00a2\u0006\u0002\b(R\u0014\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lgay/zharel/hermes/paths/ArclengthReparamCurve2d;", "Lgay/zharel/hermes/paths/PositionPath;", "Lgay/zharel/hermes/math/Arclength;", "curve", "samples", "Lgay/zharel/hermes/math/IntegralScanResult;", "<init>", "(Lgay/zharel/hermes/paths/PositionPath;Lgay/zharel/hermes/math/IntegralScanResult;)V", "eps", "", "(Lgay/zharel/hermes/paths/PositionPath;D)V", "seen0", "", "length", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILgay/zharel/hermes/paths/PositionPath;Lgay/zharel/hermes/math/IntegralScanResult;DLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "reparam", "s", "get", "Lgay/zharel/hermes/geometry/Vector2dDual;", "param", "n", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$core", "$serializer", "Companion", "core"})
public final class ArclengthReparamCurve2d
implements PositionPath<Arclength> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final PositionPath<?> curve;
    @JvmField
    @NotNull
    public final IntegralScanResult samples;
    @JvmField
    public final double length;
    @JvmField
    @NotNull
    private static final Lazy<KSerializer<Object>>[] $childSerializers;

    public ArclengthReparamCurve2d(@NotNull PositionPath<?> curve, @NotNull IntegralScanResult samples) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        this.curve = curve;
        this.samples = samples;
        this.length = ((Number)CollectionsKt.last(this.samples.sums)).doubleValue();
    }

    public ArclengthReparamCurve2d(@NotNull PositionPath<?> curve, double eps) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        this(curve, Math.integralScan(0.0, curve.length(), eps, (Function1<? super Double, Double>)((Function1)arg_0 -> ArclengthReparamCurve2d._init_$lambda$0(curve, arg_0))));
    }

    public final double reparam(double s) {
        return InterpolationKt.lerpLookup(this.samples.sums, this.samples.values, s);
    }

    @Override
    @NotNull
    public Vector2dDual<Arclength> get(double param, int n) {
        double t = this.reparam(param);
        Vector2dDual<?> point = this.curve.get(t, n);
        double[] tValues = new double[n];
        tValues[0] = t;
        if (n <= 1) {
            return point.reparam(new DualNum(tValues));
        }
        DualNum<?> tDerivs = point.drop(1).norm().recip();
        tValues[1] = tDerivs.get(0);
        if (n <= 2) {
            return point.reparam(new DualNum(tValues));
        }
        tValues[2] = tDerivs.reparam(new DualNum(tValues)).get(1);
        if (n <= 3) {
            return point.reparam(new DualNum(tValues));
        }
        tValues[3] = tDerivs.reparam(new DualNum(tValues)).get(2);
        return point.reparam(new DualNum(tValues));
    }

    @Override
    public double length() {
        return this.length;
    }

    @NotNull
    public final PositionPath<?> component1() {
        return this.curve;
    }

    @NotNull
    public final IntegralScanResult component2() {
        return this.samples;
    }

    @NotNull
    public final ArclengthReparamCurve2d copy(@NotNull PositionPath<?> curve, @NotNull IntegralScanResult samples) {
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)samples, (String)"samples");
        return new ArclengthReparamCurve2d(curve, samples);
    }

    public static /* synthetic */ ArclengthReparamCurve2d copy$default(ArclengthReparamCurve2d arclengthReparamCurve2d, PositionPath positionPath, IntegralScanResult integralScanResult, int n, Object object) {
        if ((n & 1) != 0) {
            positionPath = arclengthReparamCurve2d.curve;
        }
        if ((n & 2) != 0) {
            integralScanResult = arclengthReparamCurve2d.samples;
        }
        return arclengthReparamCurve2d.copy(positionPath, integralScanResult);
    }

    @NotNull
    public String toString() {
        return "ArclengthReparamCurve2d(curve=" + this.curve + ", samples=" + this.samples + ")";
    }

    public int hashCode() {
        int result = this.curve.hashCode();
        result = result * 31 + this.samples.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArclengthReparamCurve2d)) {
            return false;
        }
        ArclengthReparamCurve2d arclengthReparamCurve2d = (ArclengthReparamCurve2d)other;
        if (!Intrinsics.areEqual(this.curve, arclengthReparamCurve2d.curve)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.samples, (Object)arclengthReparamCurve2d.samples);
    }

    @JvmStatic
    public static final /* synthetic */ void write$Self$core(ArclengthReparamCurve2d self, CompositeEncoder output, SerialDescriptor serialDesc) {
        Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
        output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.curve);
        output.encodeSerializableElement(serialDesc, 1, (SerializationStrategy)IntegralScanResult$.serializer.INSTANCE, (Object)self.samples);
        if (output.shouldEncodeElementDefault(serialDesc, 2) ? true : Double.compare(self.length, ((Number)CollectionsKt.last(self.samples.sums)).doubleValue()) != 0) {
            output.encodeDoubleElement(serialDesc, 2, self.length);
        }
    }

    public /* synthetic */ ArclengthReparamCurve2d(int seen0, PositionPath curve, IntegralScanResult samples, double length, SerializationConstructorMarker serializationConstructorMarker) {
        if (3 != (3 & seen0)) {
            PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)$serializer.INSTANCE.getDescriptor());
        }
        this.curve = curve;
        this.samples = samples;
        this.length = (seen0 & 4) == 0 ? ((Number)CollectionsKt.last(this.samples.sums)).doubleValue() : length;
    }

    private static final double _init_$lambda$0(PositionPath $curve, double it) {
        return $curve.get(it, 2).drop(1).value().norm();
    }

    public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
        return $childSerializers;
    }

    static {
        Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new PolymorphicSerializer(Reflection.getOrCreateKotlinClass(PositionPath.class), new Annotation[0])), null, null};
        $childSerializers = lazyArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lgay/zharel/hermes/paths/ArclengthReparamCurve2d$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lgay/zharel/hermes/paths/ArclengthReparamCurve2d;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KSerializer<ArclengthReparamCurve2d> serializer() {
            return (KSerializer)$serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

