/*
 * Decompiled with CFR 0.152.
 */
package gay.zharel.hermes.profiles;

import gay.zharel.hermes.math.Math;
import gay.zharel.hermes.profiles.CancelableProfile;
import gay.zharel.hermes.profiles.DisplacementProfile;
import gay.zharel.hermes.profiles.ProfileGenerationKt;
import gay.zharel.hermes.profiles.ProfileMergingKt;
import gay.zharel.hermes.profiles.VoltageProfileUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u001aJ\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\t2\u0006\u0010\n\u001a\u00020\u0003\u00a8\u0006\u000b"}, d2={"createVoltageConstrainedProfile", "Lgay/zharel/hermes/profiles/CancelableProfile;", "length", "", "beginEndVel", "kV", "kA", "kS", "maxVoltage", "Lkotlin/Function1;", "resolution", "core"})
@SourceDebugExtension(value={"SMAP\nVoltageConstrainedProfiles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VoltageConstrainedProfiles.kt\ngay/zharel/hermes/profiles/VoltageConstrainedProfilesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,51:1\n1#2:52\n1563#3:53\n1634#3,3:54\n1563#3:57\n1634#3,3:58\n*S KotlinDebug\n*F\n+ 1 VoltageConstrainedProfiles.kt\ngay/zharel/hermes/profiles/VoltageConstrainedProfilesKt\n*L\n42#1:53\n42#1:54,3\n43#1:57\n43#1:58,3\n*E\n"})
public final class VoltageConstrainedProfilesKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final CancelableProfile createVoltageConstrainedProfile(double length, double beginEndVel, double kV, double kA, double kS, @NotNull Function1<? super Double, Double> maxVoltage, double resolution) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter(maxVoltage, (String)"maxVoltage");
        if (!(length > 0.0)) {
            boolean $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$42 = false;
            String $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$42 = "length (" + length + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$42.toString());
        }
        if (!(resolution > 0.0)) {
            boolean $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$52 = false;
            String $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$52 = "resolution (" + resolution + ") must be positive";
            throw new IllegalArgumentException($i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$52.toString());
        }
        if (!(beginEndVel >= 0.0)) {
            boolean $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$62 = false;
            String $i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$62 = "beginEndVel (" + beginEndVel + ") must be non-negative";
            throw new IllegalArgumentException($i$a$-require-VoltageConstrainedProfilesKt$createVoltageConstrainedProfile$62.toString());
        }
        int samples = java.lang.Math.max(1, (int)java.lang.Math.ceil(length / resolution));
        List<Double> disps = Math.rangeCentered(0.0, length, samples);
        Iterable $this$map$iv = disps;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Number)maxVoltage.invoke((Object)((double)it))).doubleValue() - kS);
        }
        List availableVoltages = (List)destination$iv$iv;
        Iterable $this$map$iv2 = availableVoltages;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            double d = ((Number)item$iv$iv).doubleValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(-((Number)VoltageProfileUtilsKt.accelerationFromVoltage(kA).invoke((Object)((double)it))).doubleValue());
        }
        List cancellationMinAccels = (List)destination$iv$iv2;
        DisplacementProfile forwardProfile = ProfileGenerationKt.generateVoltageConstrainedForwardProfile(disps, beginEndVel, kV, kA, availableVoltages);
        DisplacementProfile backwardProfile = ProfileGenerationKt.generateVoltageConstrainedBackwardProfile(disps, beginEndVel, kV, kA, availableVoltages);
        DisplacementProfile mergedProfile = ProfileMergingKt.mergeDisplacementProfiles(forwardProfile, backwardProfile);
        return new CancelableProfile(mergedProfile, disps, cancellationMinAccels);
    }
}

